/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.consistencycheckers;

import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.consistencycheckers.ConsistencyChecker;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class OssCorbaNameServiceAddressConsistencyChecker
extends ConsistencyChecker {
    private static Class THIS_CLASS;
    private static AbstractLogger logger;
    private String faultMsg;

    public OssCorbaNameServiceAddressConsistencyChecker() {
        THIS_CLASS = OssCorbaNameServiceAddressConsistencyChecker.class;
        logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    }

    public void checkConsistency() throws RbsConfigurationFailedException {
        String ossCorbaNameServiceAddress;
        logger.traceEnter(THIS_CLASS, "checkOssCorbaNameServiceAddress()");
        String ldn = "ManagedElement=1,NodeManagementFunction=1,RbsConfiguration=1";
        String attrName = "ossCorbaNameServiceAddress";
        try {
            ossCorbaNameServiceAddress = (String)this.ipOamService.getAttribute(ldn, attrName);
        }
        catch (MoAccessException e) {
            this.faultMsg = "Exception thrown while fetching attribute " + attrName;
            throw new RbsConfigurationFailedException(this.slogan, this.faultMsg, (Exception)((Object)e));
        }
        if (ossCorbaNameServiceAddress == null || ossCorbaNameServiceAddress.equals("")) {
            this.faultMsg = "The required attribute " + attrName + " is not set!";
            throw new RbsConfigurationFailedException(this.slogan, this.faultMsg);
        }
        logger.traceReturn(THIS_CLASS, "checkOssCorbaNameServiceAddress()");
    }
}

