/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.consistencycheckers;

import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.consistencycheckers.ConsistencyChecker;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.rollback.StringReplacingManagedObject;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class VpnInterfaceDataConsistencyChecker
extends ConsistencyChecker {
    private static Class THIS_CLASS;
    private static AbstractLogger logger;
    private String faultMsg;

    public VpnInterfaceDataConsistencyChecker() {
        THIS_CLASS = VpnInterfaceDataConsistencyChecker.class;
        logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    }

    public void checkConsistency() throws RbsConfigurationFailedException {
        StringReplacingManagedObject ipAccessHostEtRef;
        logger.traceEnter(THIS_CLASS, "checkConsistency()");
        if (this.vpnInterfaceDataLdn == null) {
            logger.info(THIS_CLASS, "No VpnInterface data found in the XML-file. Skipping consistency check for this MO.");
            logger.traceReturn(THIS_CLASS, "checkConsistency");
            return;
        }
        String vpnInterfaceLdn = this.ipOamService.findTrafficMoWithMoType("VpnInterface");
        if (vpnInterfaceLdn != null) {
            if (this.isMoIdUnique(vpnInterfaceLdn, "VpnInterfaceId", "VpnInterface")) {
                logger.info(THIS_CLASS, "vpnInterfaceId check passed!");
            } else {
                this.faultMsg = "VpnInterfaceId is the same as an existing VpnInterface MO";
                throw new RbsConfigurationFailedException(this.slogan, this.faultMsg);
            }
        }
        if ((ipAccessHostEtRef = this.getOamOuterIpAccessHostEt(this.vpnInterfaceDataLdn)) == null) {
            this.faultMsg = "The attribute ipAccessHostEtRef in MO " + this.vpnInterfaceDataLdn + " is null.";
            throw new RbsConfigurationFailedException(this.slogan, this.faultMsg);
        }
        String ipAccessHostEtRefLdn = ipAccessHostEtRef.getLdn();
        if (this.ipAccessHostEtDataLdn != null) {
            if (!ipAccessHostEtRefLdn.equals(this.ipAccessHostEtDataLdn)) {
                this.faultMsg = "The attribute ipAccessHostEtRef in MO " + this.vpnInterfaceDataLdn + " is not consistent.";
                throw new RbsConfigurationFailedException(this.slogan, this.faultMsg);
            }
        } else {
            try {
                if (this.ipOamService.getMo(ipAccessHostEtRefLdn) != null) {
                    this.referencedMos.add(ipAccessHostEtRefLdn);
                    this.referencedMos.add(this.getIpAccessHostEtsIpInterfaceMoRef(ipAccessHostEtRefLdn));
                    logger.traceDebug(THIS_CLASS, "The VpnInterface MO references the existing IpAccessHostEtRef MO " + ipAccessHostEtRefLdn);
                }
            }
            catch (MoNotFoundException e) {
                this.faultMsg = "The referenced MO " + ipAccessHostEtRefLdn + " was not found!";
                throw new RbsConfigurationFailedException(this.slogan, this.faultMsg, (Exception)((Object)e));
            }
        }
        logger.info(THIS_CLASS, "checkConsistency() passed");
        logger.traceReturn(THIS_CLASS, "checkConsistency()");
    }
}

