/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.parameterconverters;

import java.util.ArrayList;
import java.util.Arrays;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.parameterconverters.MoParameterConverterBase;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.AccessControlListData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.AclEntriesData;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class AccessControlListParameterConverter
extends MoParameterConverterBase {
    private static final Class THIS_CLASS = AccessControlListParameterConverter.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final AccessControlListData accessControlListData;

    public AccessControlListParameterConverter(AccessControlListData inAccessControlListData) {
        this.accessControlListData = inAccessControlListData;
    }

    public AttrList convert() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "convert()");
        AttrListImpl attrList = new AttrListImpl();
        ArrayList<AclEntriesData> tmpEntryList = new ArrayList<AclEntriesData>();
        Object[] aclEntriesData = this.accessControlListData.getAclEntriesData();
        tmpEntryList.addAll(Arrays.asList(aclEntriesData));
        Arrays.sort(aclEntriesData);
        Struct[] aclEntryMoData = new Struct[aclEntriesData.length];
        if (aclEntriesData != null) {
            for (int i = 0; i < aclEntriesData.length; ++i) {
                if (aclEntriesData[i] == null) continue;
                StructImpl aclEntry = ((AclEntriesData)aclEntriesData[i]).getAclEntry();
                aclEntryMoData[i] = aclEntry;
            }
        }
        if (aclEntriesData.length > 0) {
            attrList.addElement("aclEntries", (Object)aclEntryMoData);
        }
        this.addElementCheckNull("userLabel", this.accessControlListData.getUserLabel(), attrList);
        logger.traceReturn(THIS_CLASS, "convert()");
        return attrList;
    }

    public String getLdn() throws RbsConfigurationFailedException {
        String parentLdn = "ManagedElement=1,IpSystem=1";
        String currentRdn = this.getMoType() + "=" + this.accessControlListData.getAccessControlListId();
        String currentLdn = parentLdn + "," + currentRdn;
        return currentLdn;
    }

    public String getMoType() {
        return "AccessControlList";
    }
}

