/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.parameterconverters;

import java.util.ArrayList;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.parameterconverters.MoParameterConverterBase;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IkePeerData;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class IkePeerParameterConverter
extends MoParameterConverterBase {
    private static final Class THIS_CLASS = IkePeerParameterConverter.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final IkePeerData ikePeerData;
    private static final String FQDN = "FQDN";
    private static final String IP_V4_ADDRESS = "IP_V4_ADDRESS";
    private static final String ANY = "ANY";
    private static final String CERTIFICATE = "CERTIFICATE";

    public IkePeerParameterConverter(IkePeerData inIkePeerData) {
        this.ikePeerData = inIkePeerData;
    }

    public AttrList convert() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createIkePeerAttrList()");
        Integer presharedKey = new Integer(0);
        Integer certificate = new Integer(1);
        Integer authenticationMethod = null;
        String authenticationMethodString = this.ikePeerData.getAuthenticationMethod();
        if (authenticationMethodString.equalsIgnoreCase("preSharedKey")) {
            authenticationMethod = presharedKey;
        } else if (authenticationMethodString.equalsIgnoreCase(CERTIFICATE)) {
            authenticationMethod = certificate;
        }
        StructImpl peerIdentity = this.createPeerIdentity();
        StructImpl ownIdentity = this.createOwnIdentity();
        AttrListImpl attrList = new AttrListImpl();
        this.addElementCheckNull("authenticationMethod", authenticationMethod, attrList);
        this.addElementCheckNull("childSaLifeTime", this.ikePeerData.getChildSaLifeTimeStruct(), attrList);
        this.addElementCheckNull("ikeSaLifeTime", this.ikePeerData.getIkeSaLifeTime(), attrList);
        this.addElementCheckNull("logging", this.ikePeerData.getLogging(), attrList);
        this.addElementCheckNull("ownIdentity", ownIdentity, attrList);
        this.addElementCheckNull("peerIdentity", peerIdentity, attrList);
        this.addElementCheckNull("peerIpAddress", this.ikePeerData.getPeerIpAddress(), attrList);
        this.addElementCheckNull("userLabel", this.ikePeerData.getUserLabel(), attrList);
        this.addElementCheckNull("allowedTransforms", this.ikePeerData.getAllowedTransforms(), attrList);
        logger.traceReturn(THIS_CLASS, "createIkePeerAttrList()");
        return attrList;
    }

    protected StructImpl createPeerIdentity() {
        String myPeerIdentityIdFqdn;
        logger.traceEnter(THIS_CLASS, "createPeerIdentity()");
        ArrayList<String> structAttributes = new ArrayList<String>();
        ArrayList<Object> structValues = new ArrayList<Object>();
        Integer any = new Integer(0);
        Integer IpV4Address = new Integer(1);
        Integer fqdn = new Integer(2);
        Integer idType = null;
        String peerIdentityIdType = this.ikePeerData.getPeerIdentityIdType();
        if (peerIdentityIdType.equalsIgnoreCase(ANY)) {
            idType = any;
        } else if (peerIdentityIdType.equalsIgnoreCase(IP_V4_ADDRESS)) {
            idType = IpV4Address;
        } else if (peerIdentityIdType.equalsIgnoreCase(FQDN)) {
            idType = fqdn;
        }
        String ipv4Address = "";
        if (this.ikePeerData.getPeerIdentityIpv4Address() == null) {
            if (idType == IpV4Address) {
                ipv4Address = this.ikePeerData.getPeerIpAddress();
            }
        } else {
            ipv4Address = this.ikePeerData.getPeerIdentityIpv4Address();
        }
        if ((myPeerIdentityIdFqdn = this.ikePeerData.getPeerIdentityIdFqdn()) == null) {
            myPeerIdentityIdFqdn = "";
        }
        structAttributes.add("idFqdn");
        structAttributes.add("idType");
        structAttributes.add("ipv4Address");
        structValues.add(myPeerIdentityIdFqdn);
        structValues.add(idType);
        structValues.add(ipv4Address);
        String[] structAttributesArray = new String[structAttributes.size()];
        structAttributes.toArray(structAttributesArray);
        Object[] structValuesArray = new Object[structAttributes.size()];
        structValues.toArray(structValuesArray);
        StructImpl peerIdentity = new StructImpl(structAttributesArray, structValuesArray);
        logger.traceReturn(THIS_CLASS, "createPeerIdentity()");
        return peerIdentity;
    }

    protected StructImpl createOwnIdentity() {
        logger.traceEnter(THIS_CLASS, "createOwnIdentity()");
        ArrayList<String> structAttributes = new ArrayList<String>();
        ArrayList<Object> structValues = new ArrayList<Object>();
        Integer automatic = new Integer(0);
        Integer IpV4Address = new Integer(1);
        Integer fqdn = new Integer(2);
        Integer automatic_dn = new Integer(3);
        Integer idType = null;
        String ownIdentityIdType = this.ikePeerData.getOwnIdentityIdType();
        idType = ownIdentityIdType == null ? automatic : (ownIdentityIdType.equalsIgnoreCase(IP_V4_ADDRESS) ? IpV4Address : (ownIdentityIdType.equalsIgnoreCase(FQDN) ? fqdn : (ownIdentityIdType.equalsIgnoreCase("AUTOMATIC_DN") ? automatic_dn : automatic)));
        structAttributes.add("idFqdn");
        structAttributes.add("ownIdType");
        structAttributes.add("ipv4Address");
        String myOwnIdentityIdFqdn = this.ikePeerData.getOwnIdentityIdFqdn();
        if (this.ikePeerData.getOwnIdentityIdFqdn() == null) {
            myOwnIdentityIdFqdn = "";
        }
        String myOwnIdentityIpv4Address = this.ikePeerData.getOwnIdentityIpv4Address();
        if (this.ikePeerData.getOwnIdentityIpv4Address() == null) {
            myOwnIdentityIpv4Address = "";
        }
        structValues.add(myOwnIdentityIdFqdn);
        structValues.add(idType);
        structValues.add(myOwnIdentityIpv4Address);
        String[] structAttributesArray = new String[structAttributes.size()];
        structAttributes.toArray(structAttributesArray);
        Object[] structValuesArray = new Object[structAttributes.size()];
        structValues.toArray(structValuesArray);
        StructImpl ownIdentity = new StructImpl(structAttributesArray, structValuesArray);
        logger.traceReturn(THIS_CLASS, "createOwndentity()");
        return ownIdentity;
    }

    public String getLdn() throws RbsConfigurationFailedException {
        String parentLdn = "ManagedElement=1,IpSystem=1,IpSec=1";
        String currentRdn = this.getMoType() + "=" + this.ikePeerData.getIkePeerId();
        String currentLdn = parentLdn + "," + currentRdn;
        return currentLdn;
    }

    public String getMoType() {
        return "IkePeer";
    }
}

