/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.parameterconverters;

import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.parameterconverters.MoParameterConverterBase;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.rollback.StringReplacingManagedObject;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpAccessHostEtData;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class IpAccessHostEtParameterConverter
extends MoParameterConverterBase {
    private static final Class THIS_CLASS = IpAccessHostEtParameterConverter.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final IpAccessHostEtData ipAccessHostEtData;

    public IpAccessHostEtParameterConverter(IpAccessHostEtData inIpAccessHostEtData) {
        this.ipAccessHostEtData = inIpAccessHostEtData;
    }

    public AttrList convert() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "convert()");
        AttrListImpl attrList = new AttrListImpl();
        String ipInterfaceOrVpnLdn = this.correctIpInterfaceMoRef(this.ipAccessHostEtData.getIpInterfaceMoRefLdn());
        StringReplacingManagedObject ldnManagedObject = new StringReplacingManagedObject(ipInterfaceOrVpnLdn);
        this.addElementCheckNull("ipAddress", this.ipAccessHostEtData.getIpAddress(), attrList);
        this.addElementCheckNull("userLabel", this.ipAccessHostEtData.getUserLabel(), attrList);
        attrList.addElement("ipInterfaceMoRef", (Object)ldnManagedObject);
        Integer wantedState = RbsConfigurationDefinitions.ADMINISTRATIVE_STATE_UNLOCKED;
        attrList.addElement("administrativeState", (Object)wantedState);
        logger.traceReturn(THIS_CLASS, "convert()");
        return attrList;
    }

    public String getLdn() {
        String parentLdn = "ManagedElement=1,IpSystem=1";
        String myLdn = parentLdn + "," + this.getMoType() + "=" + this.ipAccessHostEtData.getIpAccessHostEtId();
        return myLdn;
    }

    public String getMoType() {
        return "IpAccessHostEt";
    }
}

