/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.parameterconverters;

import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.parameterconverters.MoParameterConverterBase;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.rollback.StringReplacingManagedObject;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpHostLinkData;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class IpHostLinkParameterConverter
extends MoParameterConverterBase {
    private static final Class THIS_CLASS = IpHostLinkParameterConverter.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final IpHostLinkData ipHostLinkData;

    public IpHostLinkParameterConverter(IpHostLinkData inIpHostLinkData) {
        this.ipHostLinkData = inIpHostLinkData;
    }

    public AttrList convert() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "convert()");
        AttrListImpl attrList = new AttrListImpl();
        String retrievedIpInterfaceLdn = this.correctIpInterfaceMoRef(this.ipHostLinkData.getIpInterfaceLdn());
        StringReplacingManagedObject ldnManagedObject = new StringReplacingManagedObject(retrievedIpInterfaceLdn);
        attrList.addElement("ipInterfaceMoRef", (Object)ldnManagedObject);
        attrList.addElement("ipv4Addresses", (Object)new String[]{this.ipHostLinkData.getIpAddress()});
        attrList.addElement("userLabel", (Object)this.ipHostLinkData.getUserLabel());
        logger.traceReturn(THIS_CLASS, "convert()");
        return attrList;
    }

    public String getLdn() {
        String parentLdn = "ManagedElement=1,IpOam=1,Ip=1";
        String currentRdn = this.getMoType() + "=" + this.ipHostLinkData.getIpHostLinkId();
        String currentLdn = parentLdn + "," + currentRdn;
        return currentLdn;
    }

    public String getMoType() {
        return "IpHostLink";
    }
}

