/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.parameterconverters;

import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.parameterconverters.MoParameterConverterBase;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.rollback.StringReplacingManagedObject;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpInterfaceData;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class IpInterfaceParameterConverter
extends MoParameterConverterBase {
    private static final Class THIS_CLASS = IpInterfaceParameterConverter.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final IpInterfaceData ipInterfaceData;

    public IpInterfaceParameterConverter(IpInterfaceData inIpInterfaceData) {
        this.ipInterfaceData = inIpInterfaceData;
    }

    public AttrList convert() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "convert()");
        AttrListImpl attrList = new AttrListImpl();
        this.addElementCheckNull("networkPrefixLength", this.ipInterfaceData.getNetworkPrefixLength(), attrList);
        this.addElementCheckNull("defaultRouter0", this.ipInterfaceData.getDefaultRouter0(), attrList);
        attrList.addElement("rps", (Object)Boolean.FALSE);
        this.addElementCheckNull("userLabel", this.ipInterfaceData.getUserLabel(), attrList);
        if (this.ipInterfaceData.getVid() == null || this.ipInterfaceData.getVid() == -1) {
            attrList.addElement("vid", (Object)new Integer(1));
            attrList.addElement("vLan", (Object)Boolean.FALSE);
        } else {
            attrList.addElement("vid", (Object)this.ipInterfaceData.getVid());
            attrList.addElement("vLan", (Object)Boolean.TRUE);
        }
        if (this.ipInterfaceData.getAccessControlListRefLdn() != null) {
            StringReplacingManagedObject ldnManagedObject = new StringReplacingManagedObject(this.ipInterfaceData.getAccessControlListRefLdn());
            attrList.addElement("accessControlListRef", (Object)ldnManagedObject);
        }
        logger.traceReturn(THIS_CLASS, "convert()");
        return attrList;
    }

    public String getLdn() throws RbsConfigurationFailedException {
        String parentLdn = this.getGigabitEthernetLdn();
        String currentRdn = this.getMoType() + "=" + this.ipInterfaceData.getIpInterfaceId();
        String currentLdn = parentLdn + "," + currentRdn;
        return currentLdn;
    }

    public String getMoType() {
        return "IpInterface";
    }
}

