/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.parameterconverters;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.parameterconverters.MoParameterConverterBase;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.rollback.StringReplacingManagedObject;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpSecTunnelData;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class IpSecTunnelParameterConverter
extends MoParameterConverterBase {
    private static final Class THIS_CLASS = IpSecTunnelParameterConverter.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final IpSecTunnelData ipSecTunnelData;
    private final String RAWIP = "RAWIP";
    private final String SCTP = "SCTP";
    private final String UDP = "UDP";
    private final String TCP = "TCP";
    private final String ICMP = "ICMP";
    private final String ANY = "ANY";
    protected final Map tsProtocolsMap;

    public IpSecTunnelParameterConverter(IpSecTunnelData inIpSecTunnelData) {
        this.ipSecTunnelData = inIpSecTunnelData;
        this.tsProtocolsMap = new HashMap();
        this.tsProtocolsMap.put("ANY", new Integer(0));
        this.tsProtocolsMap.put("ICMP", new Integer(1));
        this.tsProtocolsMap.put("TCP", new Integer(6));
        this.tsProtocolsMap.put("UDP", new Integer(17));
        this.tsProtocolsMap.put("SCTP", new Integer(132));
        this.tsProtocolsMap.put("RAWIP", new Integer(255));
    }

    public AttrList convert() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "convert()");
        AttrListImpl attrList = new AttrListImpl();
        int[] tsProtocol = this.handleTsProtocols(this.ipSecTunnelData.getTsProtocols());
        this.addElementCheckNull("tsRemoteIpAddressRanges", this.ipSecTunnelData.getTsRemoteIpAddressRanges(), attrList);
        this.addElementCheckNull("tsLocalIpAddressRanges", this.ipSecTunnelData.getTsLocalIpAddressRanges(), attrList);
        this.addElementCheckNull("tsProtocols", tsProtocol, attrList);
        this.addElementCheckNull("userLabel", this.ipSecTunnelData.getUserLabel(), attrList);
        this.addElementCheckNull("allowedTransforms", this.ipSecTunnelData.getAllowedTransforms(), attrList);
        StringReplacingManagedObject ikePeerRefLdnManagedObject = new StringReplacingManagedObject(this.ipSecTunnelData.getIkePeerRefLdn());
        attrList.addElement("ikePeerRef", (Object)ikePeerRefLdnManagedObject);
        StringReplacingManagedObject vpnInterfaceRefLdnManagedObject = new StringReplacingManagedObject(this.ipSecTunnelData.getVpnInterfaceRefLdn());
        attrList.addElement("vpnInterfaceRef", (Object)vpnInterfaceRefLdnManagedObject);
        this.addElementCheckNull("priority", this.ipSecTunnelData.getPriority(), attrList);
        logger.traceReturn(THIS_CLASS, "convert()");
        return attrList;
    }

    private int[] handleTsProtocols(String tsProtocols) {
        logger.traceEnter(THIS_CLASS, "handleTsProtocols()");
        Integer returnValue = (Integer)this.tsProtocolsMap.get("ANY");
        if (tsProtocols != null && this.tsProtocolsMap.containsKey(tsProtocols.toUpperCase(Locale.getDefault()))) {
            returnValue = (Integer)this.tsProtocolsMap.get(tsProtocols.toUpperCase(Locale.getDefault()));
        }
        int[] returnArray = new int[]{returnValue};
        logger.traceReturn(THIS_CLASS, "handleTsProtocols()");
        return returnArray;
    }

    public String getLdn() throws RbsConfigurationFailedException {
        String parentLdn = "ManagedElement=1,IpSystem=1,IpSec=1";
        String currentRdn = this.getMoType() + "=" + this.ipSecTunnelData.getIpSecTunnelId();
        String currentLdn = parentLdn + "," + currentRdn;
        return currentLdn;
    }

    public String getMoType() {
        return "IpSecTunnel";
    }
}

