/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.rollback;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpOamConfigurationService;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpOamConfigurationServiceImpl;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public abstract class AbstractIpRollbackStackItem {
    private static final Class THIS_CLASS = AbstractIpRollbackStackItem.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final String ldn;
    private final IpOamConfigurationService configurationService;

    public AbstractIpRollbackStackItem(String inLdn) {
        logger.traceEnter(THIS_CLASS, "AbstractIpRollbackStackItem()");
        this.ldn = inLdn;
        this.configurationService = IpOamConfigurationServiceImpl.getInstance();
        logger.traceReturn(THIS_CLASS, "AbstractIpRollbackStackItem()");
    }

    public String getLdn() {
        return this.ldn;
    }

    protected IpOamConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    protected static String getAttributesAsString(String[] attributeNames, Object[] attributeValues) {
        StringBuffer sb = new StringBuffer();
        if (attributeNames.length == attributeValues.length) {
            for (int i = 0; i < attributeNames.length; ++i) {
                sb.append(attributeNames[i] + ": " + attributeValues[i] + "\n");
            }
        }
        return sb.toString();
    }

    protected static String getAttributesAsString(AttrList attributeList) {
        StringBuffer sb = new StringBuffer();
        int size = attributeList.size();
        for (int i = 0; i < size; ++i) {
            try {
                Object value = attributeList.getValue(i);
                String name = attributeList.getName(i);
                sb.append(name + ": " + value + "\n");
                continue;
            }
            catch (MoAccessException e) {
                return "ERROR: " + e.toString();
            }
        }
        return sb.toString();
    }

    public abstract boolean doRollback();

    public abstract String toString();
}

