/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.rollback;

import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpOamConfigurationService;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpOamConfigurationServiceImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.rollback.AbstractIpRollbackStackItem;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class ActionIpRollbackStackItem
extends AbstractIpRollbackStackItem {
    private static final AbstractLogger logger = LoggingService.getLogger();
    private final String actionName;
    private final String[] attributeNames;
    private final Object[] attributeValues;

    public ActionIpRollbackStackItem(String inLdn, String inActionName, String[] inAttributeNames, Object[] inAttributeValues) {
        super(inLdn);
        this.actionName = inActionName;
        this.attributeNames = inAttributeNames;
        this.attributeValues = inAttributeValues;
    }

    public boolean doRollback() {
        logger.traceEnter(this.getClass(), "doRollback()");
        String ldn = this.getLdn();
        boolean success = true;
        if (this.actionName.equalsIgnoreCase("actionAddStaticRoute")) {
            success = this.rollbackActionAddStaticRoute();
        } else if (this.actionName.equalsIgnoreCase("actionDeleteStaticRoute")) {
            success = this.rollbackActionDeleteStaticRoute();
        } else if (this.actionName.equalsIgnoreCase("actionChangeNodeInterfaceName")) {
            success = this.rollbackActionChangeNodeInterfaceName();
        } else {
            this.logErrorMessage(ldn, "The action " + this.actionName + " is not supported for rollback.");
            return false;
        }
        logger.traceReturn(this.getClass(), "doRollback()");
        return success;
    }

    private boolean rollbackActionAddStaticRoute() {
        logger.traceEnter(this.getClass(), "rollbackActionAddStaticRoute()");
        String ipAddress = null;
        String subnetMask = null;
        String hopIpAddress = null;
        Integer routeMetric = null;
        boolean redistribute = false;
        if (this.attributeNames.length == this.attributeValues.length) {
            for (int i = 0; i < this.attributeNames.length; ++i) {
                String attributeName = this.attributeNames[i];
                Object attributeValue = this.attributeValues[i];
                if (attributeName.equals("ipAddress")) {
                    ipAddress = (String)attributeValue;
                    continue;
                }
                if (attributeName.equals("networkMask")) {
                    subnetMask = (String)attributeValue;
                    continue;
                }
                if (attributeName.equals("nextHopIpAddr")) {
                    hopIpAddress = (String)attributeValue;
                    continue;
                }
                if (attributeName.equals("routeMetric")) {
                    routeMetric = (Integer)attributeValue;
                    continue;
                }
                if (attributeName.equals("redistribute")) {
                    if (attributeValue == null) continue;
                    redistribute = (Boolean)attributeValue;
                    continue;
                }
                logger.traceAbnormal(this.getClass(), "Unsupported attribute " + attributeName + " with value " + attributeValue + " detected. Ignoring this attribute.");
            }
        } else {
            this.logErrorMessage(this.getLdn(), "attributeNames and attributeValues are not of equal length.");
            return false;
        }
        if (ipAddress == null || subnetMask == null || hopIpAddress == null || routeMetric == null) {
            this.logErrorMessage(this.getLdn(), "All attributes were not found in the input.");
            return false;
        }
        IpOamConfigurationService configurationService = IpOamConfigurationServiceImpl.getInstance();
        try {
            configurationService.performActionAddStaticRoute(ipAddress, subnetMask, hopIpAddress, routeMetric, redistribute);
        }
        catch (RbsConfigurationFailedException e) {
            this.logErrorMessage(this.getLdn(), e.getMessage());
            return false;
        }
        logger.traceReturn(this.getClass(), "rollbackActionAddStaticRoute()");
        return true;
    }

    private boolean rollbackActionDeleteStaticRoute() {
        logger.traceEnter(this.getClass(), "rollbackActionDeleteStaticRoute()");
        String nextHopIpAddress = null;
        String destinationIpAddress = null;
        if (this.attributeNames.length == this.attributeValues.length) {
            for (int i = 0; i < this.attributeNames.length; ++i) {
                String attributeName = this.attributeNames[i];
                Object attributeValue = this.attributeValues[i];
                if (attributeName.equals("nextHopIpAddr")) {
                    nextHopIpAddress = (String)attributeValue;
                    continue;
                }
                if (attributeName.equals("ipAddress")) {
                    destinationIpAddress = (String)attributeValue;
                    continue;
                }
                logger.traceAbnormal(this.getClass(), "Unsupported attribute " + attributeName + " with value " + attributeValue + " detected. Ignoring this attribute.");
            }
        } else {
            this.logErrorMessage(this.getLdn(), "attributeNames and attributeValues are not of equal length.");
            return false;
        }
        if (nextHopIpAddress == null || destinationIpAddress == null) {
            this.logErrorMessage(this.getLdn(), "All attributes were not found in the input.");
            return false;
        }
        IpOamConfigurationService configurationService = IpOamConfigurationServiceImpl.getInstance();
        try {
            configurationService.performActionDeleteStaticRoute(destinationIpAddress, nextHopIpAddress);
        }
        catch (RbsConfigurationFailedException e) {
            this.logErrorMessage(this.getLdn(), e.getMessage());
            return false;
        }
        logger.traceReturn(this.getClass(), "rollbackActionDeleteStaticRoute()");
        return true;
    }

    private boolean rollbackActionChangeNodeInterfaceName() {
        logger.traceEnter(this.getClass(), "rollbackActionChangeNodeInterfaceName");
        IpOamConfigurationService configurationService = IpOamConfigurationServiceImpl.getInstance();
        try {
            configurationService.changeNodeInterfaceName((String)this.attributeValues[0]);
        }
        catch (RbsConfigurationFailedException e) {
            this.logErrorMessage(this.getLdn(), e.getMessage());
            return false;
        }
        logger.traceReturn(this.getClass(), "rollbackActionChangeNodeInterfaceName");
        return true;
    }

    private void logErrorMessage(String ldn, String reason) {
        String errorMsg = "Could not perform action " + this.actionName + " on MO " + ldn + " in rollback. " + reason;
        logger.traceAbnormal(this.getClass(), errorMsg);
    }

    public String toString() {
        return "Action " + this.actionName + " on MO " + this.getLdn() + " with attributes " + ActionIpRollbackStackItem.getAttributesAsString(this.attributeNames, this.attributeValues);
    }
}

