/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.transactionpackages;

import se.ericsson.cello.ipoam.mom.IpOam;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpOamConfigurationService;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpOamConfigurationServiceImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class IpOamPinger
implements TransactionPackage {
    private final String ipAddress;
    private final IpOamConfigurationService ipOamConfigurationService = IpOamConfigurationServiceImpl.getInstance();
    private final String errorSlogan = "Could not ping.";
    private static final Class THIS_CLASS = IpOamPinger.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public IpOamPinger(String ipAddressToPing) {
        this.ipAddress = ipAddressToPing;
    }

    public void execute(Coordinator coordinator) throws MoAccessException, InactiveTransactionException {
        logger.traceEnter(THIS_CLASS, "execute()");
        String errMessage = "";
        RbsConfigurationHelper helper = this.ipOamConfigurationService.getRbsConfigurationHelper();
        IpOam ipOamMo = (IpOam)this.ipOamConfigurationService.getMo("ManagedElement=1,IpOam=1");
        int i = 0;
        int timeout = 5;
        int sleepTimeSeconds = 2;
        while (ipOamMo.actionPing(this.ipAddress, coordinator).indexOf("alive") == -1) {
            if (i >= 5) {
                errMessage = "Ping to IP address " + this.ipAddress + " failed.";
                helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, "Could not ping.", errMessage);
                throw new RbsConfigurationFailedException("Could not ping.", errMessage);
            }
            ++i;
            logger.traceDebug(THIS_CLASS, "Failed to ping IP adress " + this.ipAddress + ". Trying again in " + 2 + " seconds.");
            try {
                int sleepFactor = 1000;
                String isUnitTest = System.getProperty("UNIT_TEST");
                if (isUnitTest != null && isUnitTest.equalsIgnoreCase("TRUE")) {
                    sleepFactor = 1;
                }
                Thread.sleep(2 * sleepFactor);
            }
            catch (InterruptedException e) {
                logger.traceAbnormal(THIS_CLASS, "Sleep action interrupted while pinging OSS.");
            }
        }
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("Could not ping.", "Unable to execute ping action on the IpOam MO", exception);
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("Could not ping.", "Transaction exception while trying to ping " + this.ipAddress, exception);
    }
}

