/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.transactionpackages;

import se.ericsson.cello.ipsec.IpSecMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class IpSecCertificateChecker
implements TransactionPackage {
    private final String slogan = "Check IP Sec certificate failed.";
    private final IpSecMo ipSecMo;
    private boolean certificateInstalled;
    private static final Class THIS_CLASS = IpSecCertificateChecker.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public IpSecCertificateChecker(IpSecMo inIpSecMo) {
        this.ipSecMo = inIpSecMo;
    }

    public void execute(Coordinator coordinator) throws MoAccessException, InactiveTransactionException {
        logger.traceEnter(THIS_CLASS, "execute()");
        if (this.ipSecMo == null) {
            throw new RbsConfigurationFailedException("Check IP Sec certificate failed.", "No IpSec MO was found on the node!");
        }
        Struct ipSecCertInfo = this.ipSecMo.getCertificate(coordinator);
        String serialNumber = (String)ipSecCertInfo.getValue("serialNumber");
        this.certificateInstalled = serialNumber != "";
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    public boolean isCertificateInstalled() {
        return this.certificateInstalled;
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("Check IP Sec certificate failed.", "Execution exception thrown while checking IpSec certificates.", exception);
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("Check IP Sec certificate failed.", "Transaction exception thrown while checking IpSec certificates.", exception);
    }
}

