/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.transactionpackages;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpOamConfigurationService;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpOamConfigurationServiceImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class MoDeletor
implements TransactionPackage {
    private static final Class THIS_CLASS = MoDeletor.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final String ldn;

    public MoDeletor(String inLdn) {
        this.ldn = inLdn;
    }

    public void execute(Coordinator coordinator) throws MoAccessException, InactiveTransactionException {
        logger.traceEnter(THIS_CLASS, "execute()");
        IpOamConfigurationService ipOamConfigurationService = IpOamConfigurationServiceImpl.getInstance();
        ManagedObject mo = ipOamConfigurationService.getMo(this.ldn);
        logger.info(THIS_CLASS, "Deleting the MO " + this.ldn);
        mo.delete(coordinator);
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        String reason = "Caught an execution exception while deleting the MO " + this.ldn;
        logger.traceError(this.getClass(), reason);
        throw new RbsConfigurationFailedException("Execution exception in MoDeletor.", reason, exception);
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        String reason = "Caught a transaction exception while deleting the MO " + this.ldn;
        logger.traceError(this.getClass(), reason);
        throw new RbsConfigurationFailedException("Transaction exception in MoDeletor.", reason, exception);
    }
}

