/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.transactionpackages;

import se.ericsson.cello.ipoam.IpRoutingTableMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpOamConfigurationService;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpOamConfigurationServiceImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class StaticRouteAdder
implements TransactionPackage {
    private static final AbstractLogger logger = LoggingService.getLogger((String)StaticRouteAdder.class.getName());
    private final String destination;
    private final String subnetOrPrefixLength;
    private final String nextHop;
    private final int routeMetric;
    private final boolean redistribute;

    public StaticRouteAdder(String inDestination, String inSubnetOrPrefixLength, String inNextHop, int inRouteMetric, boolean inRedistribute) {
        this.destination = inDestination;
        this.subnetOrPrefixLength = inSubnetOrPrefixLength;
        this.nextHop = inNextHop;
        this.routeMetric = inRouteMetric;
        this.redistribute = inRedistribute;
    }

    public StaticRouteAdder(String inNextHop, int inRouteMetric) {
        this("0.0.0.0", "0.0.0.0", inNextHop, inRouteMetric, false);
    }

    public void execute(Coordinator coordinator) throws MoAccessException, InactiveTransactionException {
        logger.traceEnter(this.getClass(), "execute()");
        IpOamConfigurationService configurationService = IpOamConfigurationServiceImpl.getInstance();
        IpRoutingTableMo ipRoutingTableMo = (IpRoutingTableMo)configurationService.getMo("ManagedElement=1,IpOam=1,Ip=1,IpRoutingTable=1");
        ipRoutingTableMo.actionAddStaticRoute(this.destination, this.subnetOrPrefixLength, this.nextHop, this.routeMetric, this.redistribute, coordinator);
        logger.traceReturn(this.getClass(), "execute()");
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        String reason = "Unable to add static route.\nDestination: " + this.destination + "\nSubnet: " + this.subnetOrPrefixLength + "\nnextHopIpAddr: " + this.nextHop + "\nrouteMetric: " + this.routeMetric + "\nredistribute" + this.redistribute;
        logger.traceError(this.getClass(), reason);
        throw new RbsConfigurationFailedException("Execution exception in StaticRouteAdder.", reason, exception);
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        String reason = "Caught a transaction exception while adding static route in IpRoutingTable MO.";
        logger.traceError(this.getClass(), reason);
        throw new RbsConfigurationFailedException("Transaction exception in StaticRouteAdder.", reason, exception);
    }
}

