/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.transactionpackages;

import se.ericsson.cello.ipoam.IpRoutingTableMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpOamConfigurationService;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpOamConfigurationServiceImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class StaticRouteDeletorTp
implements TransactionPackage {
    private static final Class THIS_CLASS = StaticRouteDeletorTp.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final String nextHop;
    private final String destinationIpAddr;
    private IpOamConfigurationService ipOamConfigurationService = IpOamConfigurationServiceImpl.getInstance();

    public StaticRouteDeletorTp(String inDestinationIp, String inNextHop) {
        this.destinationIpAddr = inDestinationIp;
        this.nextHop = inNextHop;
    }

    public void execute(Coordinator coordinator) throws MoAccessException, InactiveTransactionException {
        logger.traceEnter(this.getClass(), "execute()");
        IpRoutingTableMo ipRoutingTableMo = (IpRoutingTableMo)this.ipOamConfigurationService.getMo("ManagedElement=1,IpOam=1,Ip=1,IpRoutingTable=1");
        int nrRoutingTableEntries = ipRoutingTableMo.actionNumberOfRoutes(coordinator);
        for (int i = 0; i < nrRoutingTableEntries; ++i) {
            Struct routingTableEntry = ipRoutingTableMo.actionGetRoutingTableEntry(i, coordinator);
            if (!routingTableEntry.getValue("nextHopIpAddr").equals(this.nextHop) || !routingTableEntry.getValue("destinationIpAddr").equals(this.destinationIpAddr)) continue;
            ipRoutingTableMo.actionDeleteStaticRoute(routingTableEntry, coordinator);
            logger.traceDebug(this.getClass(), "Delete one static route with destinationIpAddr=" + routingTableEntry.getValue("destinationIpAddr") + ", nextHopIpAddr=" + routingTableEntry.getValue("nextHopIpAddr"));
            RbsConfigurationReportLoggerFactory.getLogger().logAction("IpRoutingTable", "actionDeleteStaticRoute", routingTableEntry.getNames(), routingTableEntry.getValues());
            break;
        }
        logger.traceReturn(this.getClass(), "execute()");
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        logger.traceAbnormal(THIS_CLASS, "Unexpected exception during deleting of static routes: " + exception);
        throw new RbsConfigurationFailedException("Execution exception while deleting static routes", "Caught an execution exception", exception);
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        logger.traceAbnormal(THIS_CLASS, "Unexpected transactional failure during deleting of static routes: " + exception);
        throw new RbsConfigurationFailedException("Transaction exception while deleting static routes", "Caught a transaction exception", exception);
    }
}

