/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.npc;

import java.io.IOException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.AbstractRbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationUnlockHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.npc.RbsConfigurationNpcParser;
import se.ericsson.crbs.cat.mao.rbsconfiguration.npc.datastructure.NpcConfigData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.npc.transactionpackages.CreateCellRelationsTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.npc.transactionpackages.CreateCellsTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.npc.transactionpackages.CreateMmesTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.npc.transactionpackages.CreateTransportNetworkTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.npc.transactionpackages.SetLogicalNameTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.RbsConfigurationSiteBasicImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.RbsConfigurationSiteEquipmentImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.createcv.CreateAiCvFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.CreateGigabitMoTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.SetAutoConfigurationAllowedTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.UnlockGigabitMoTp;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class RbsConfigurationNpcHelper
extends AbstractRbsConfigurationHelper {
    private static final Class THIS_CLASS = RbsConfigurationNpcHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final transient RbsConfigurationNpcParser parser = new RbsConfigurationNpcParser();
    private RbsConfigurationHelper helper;
    protected Thread npcThread = new Thread("Will be replaced");

    public void runNpcConfiguration(final String logicalName, final boolean validateXml) {
        logger.traceEnter(THIS_CLASS, "runNpcConfiguration()");
        Runnable npcRunnable = new Runnable(){

            public void run() {
                RbsConfigurationNpcHelper.this.parseAndConfigureNpc(logicalName, validateXml);
            }
        };
        this.npcThread = new Thread(npcRunnable, "lteRbsNoamLm - RbsConfigurationNpc");
        this.npcThread.start();
        logger.traceReturn(THIS_CLASS, "runNpcConfiguration()");
    }

    protected void parseAndConfigureNpc(String logicalName, boolean validateXml) {
        this.helper = (RbsConfigurationHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationHelper.class);
        String npcFilePath = "";
        try {
            npcFilePath = (String)this.rbsConfiguration.retrievePersistently("localProductionTestFilePath");
            NpcConfigData npcConfigData = this.parser.parseNpcProductionConfigFile(npcFilePath, validateXml);
            this.configureNpc(logicalName, npcConfigData, validateXml);
        }
        catch (IOException ioe) {
            this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, "NPC failure", "Unable to parse the configuration file for NPC, original exception: " + ioe.getMessage());
            this.rbsConfiguration.resetProgressInformation();
            this.rbsConfiguration.cleanPersistentAttributesAndRemoveFiles("npc_");
            ((RbsConfigurationHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationHelper.class)).setConfigurationStateAndProgressLevel(0);
        }
        catch (RbsConfigurationFailedException rcfe) {
            ((RbsConfigurationHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationHelper.class)).setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, "NPC failure", "Unable to run NPC configuration: " + rcfe.getFormattedMessages());
            this.rbsConfiguration.resetProgressInformation();
            this.rbsConfiguration.cleanPersistentAttributesAndRemoveFiles("npc_");
            ((RbsConfigurationHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationHelper.class)).setConfigurationStateAndProgressLevel(0);
        }
    }

    protected void configureNpc(String logicalName, NpcConfigData npcConfigData, boolean validateXml) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "configureNpc()");
        TransactionHandler.run(new SetLogicalNameTp(logicalName, this.genericMaoContext.getMoRepositoryWrapper()));
        TransactionHandler.run(new SetAutoConfigurationAllowedTp(this.genericMaoContext, Boolean.TRUE));
        MoIterator gigaBitEthernetMos = this.genericMaoContext.getMoRepositoryWrapper().lookupType("GigaBitEthernet");
        if (gigaBitEthernetMos == null || gigaBitEthernetMos.size() == 0) {
            TransactionHandler.run(new CreateGigabitMoTp(this.genericMaoContext, RbsConfigurationDefinitions.PORT_NO_TWO, true));
            TransactionHandler.run(new UnlockGigabitMoTp(this.genericMaoContext));
        }
        RbsConfigurationSiteBasicImpl siteBasic = new RbsConfigurationSiteBasicImpl(this.rbsConfiguration, validateXml);
        TransactionHandler.runWithLoopWithoutException(siteBasic);
        TransactionHandler.runWithLoopWithoutException(siteBasic);
        TransactionHandler.runWithLoopWithoutException(siteBasic);
        TransactionHandler.run(new RbsConfigurationSiteEquipmentImpl(this.rbsConfiguration, validateXml));
        if (this.checkIfTransportNetworkAndCellsExist(npcConfigData)) {
            TransactionHandler.run(new CreateTransportNetworkTp(this.genericMaoContext, npcConfigData));
            TransactionHandler.run(new CreateCellsTp(this.genericMaoContext, npcConfigData));
            TransactionHandler.run(new CreateCellRelationsTp(this.genericMaoContext, npcConfigData));
            TransactionHandler.run(new CreateMmesTp(this.genericMaoContext, npcConfigData));
            RbsConfigurationUnlockHelper.getInstance().unlockAllCreatedMmes();
            RbsConfigurationUnlockHelper.getInstance().unlockAllCreatedCells();
        }
        this.helper.setRbsConfigLevel(RbsConfigurationDefinitions.RBS_CL_NPC_COMPLETE);
        CreateAiCvFactory.instance(this.rbsConfiguration).createCv("ProductionTestConfigurationComplete", "CV created after NPC configuration", "Could not create CV after finishing NPC test configuration: ");
        RbsConfigurationReportLoggerFactory.getLogger().flushLogEntryBufferToFile();
        logger.traceReturn(THIS_CLASS, "configureNpc()");
    }

    private boolean checkIfTransportNetworkAndCellsExist(NpcConfigData npcConfig) {
        logger.traceEnter(THIS_CLASS, "checkIfTransportNetworkAndCellsExist()");
        boolean npcConfigDataExists = false;
        if (npcConfig.transportNetwork != null && npcConfig.cells != null) {
            npcConfigDataExists = true;
        }
        logger.traceReturn(THIS_CLASS, "checkIfTransportNetworkAndCellsExist()");
        return npcConfigDataExists;
    }

    public String getHelperName() {
        return this.getClass().getName();
    }

    public Thread getNpcThread() {
        return this.npcThread;
    }
}

