/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.npc;

import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationUnlockHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.npc.datastructure.TransportNetworkData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLogger;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoFactoryMgrWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class TermPointToMmeHelper {
    private static final Class THIS_CLASS = TermPointToMmeHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final MoFactoryMgrWrapper aFactoryMgr;
    private final MoRepositoryWrapper aMoRepository;
    private final RbsConfigurationReportLogger reportLogger;
    private static final String tptmmeFailureSlogan = "TermPointToMme configuration failure";

    public TermPointToMmeHelper(GenericMaoContext aGenericMaoContext) {
        logger.traceEnter(THIS_CLASS, "TermPointToMmeHelper()");
        this.aMoRepository = aGenericMaoContext.getMoRepositoryWrapper();
        this.aFactoryMgr = aGenericMaoContext.getMoFactoryMgrWrapper();
        this.reportLogger = RbsConfigurationReportLoggerFactory.getLogger();
        logger.traceReturn(THIS_CLASS, "TermPointToMmeHelper()");
    }

    public void createTermPointToMmeMo(TransportNetworkData transportNetworkData, Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createTermPointToMmeMo()");
        ManagedObject eNodeBMao = this.aMoRepository.lookup("ManagedElement=1,ENodeBFunction=1");
        if (eNodeBMao == null) {
            String msg = "Could not find the system created MO ManagedElement=1,ENodeBFunction=1.";
            throw new RbsConfigurationFailedException(tptmmeFailureSlogan, "Could not find the system created MO ManagedElement=1,ENodeBFunction=1.");
        }
        String currentLdn = "ManagedElement=1,ENodeBFunction=1,TermPointToMme=" + transportNetworkData.mmeIpAddress;
        try {
            MoFactory tptMmeMoFactory = this.aFactoryMgr.lookup("TermPointToMme");
            if (tptMmeMoFactory == null) {
                String msg = "Could not find the MO factory for TermPointToMme.";
                throw new RbsConfigurationFailedException(tptmmeFailureSlogan, "Could not find the MO factory for TermPointToMme.");
            }
            AttrListImpl attrList = new AttrListImpl();
            attrList.addElement("administrativeState", (Object)RbsConfigurationDefinitions.ADMINISTRATIVE_STATE_LOCKED);
            attrList.addElement("domainName", (Object)transportNetworkData.domainName);
            attrList.addElement("ipAddress1", (Object)transportNetworkData.mmeIpAddress);
            ManagedObject tptMmeMo = this.aMoRepository.lookup(currentLdn);
            if (tptMmeMo == null) {
                tptMmeMo = tptMmeMoFactory.createMo(eNodeBMao, (AttrList)attrList, transportNetworkData.mmeIpAddress, null, coordinator);
                RbsConfigurationUnlockHelper.getInstance().registerCreatedMo(tptMmeMo, coordinator);
                this.reportLogger.logAction(currentLdn, "create", "TermPointToMme", transportNetworkData.mmeIpAddress);
            }
        }
        catch (MoAccessException mae) {
            String msg = "Failed to create the MO \"" + currentLdn + "\".";
            throw new RbsConfigurationFailedException(tptmmeFailureSlogan, msg, (Exception)((Object)mae));
        }
        catch (InactiveTransactionException ite) {
            String msg = "Failed to create the MO \"" + currentLdn + "\".";
            throw new RbsConfigurationFailedException(tptmmeFailureSlogan, msg, (Exception)((Object)ite));
        }
        logger.traceReturn(THIS_CLASS, "createTermPointToMmeMo()");
    }
}

