/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.npc;

import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationUnlockHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.npc.AbstractTransportNetworkHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.npc.datastructure.TransportNetworkData;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;

public class TransportNetworkHelper
extends AbstractTransportNetworkHelper {
    private static final Class THIS_CLASS = TransportNetworkHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public TransportNetworkHelper(GenericMaoContext aGenericMaoContext) {
        super(aGenericMaoContext);
        logger.traceEnter(THIS_CLASS, "TransportNetworkHelper()");
        logger.traceReturn(THIS_CLASS, "TransportNetworkHelper()");
    }

    public void configureTransportNetwork(TransportNetworkData tnData, Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "configureTransportNetwork()");
        ManagedObject ipInterface = this.createIpInterface(tnData, coordinator);
        ManagedObject ipAccessHostEt = this.createIpAccessHostEt(tnData, ipInterface, coordinator);
        ManagedObject ipAccessSctp = this.createIpAccessSctp(ipAccessHostEt, coordinator);
        this.createOrUpdateSctp(ipAccessSctp, coordinator);
        this.configureENodeBFunction(tnData, coordinator);
        RbsConfigurationUnlockHelper.getInstance().unlockAllCreatedMos(coordinator);
        logger.traceReturn(THIS_CLASS, "configureTransportNetwork()");
    }

    protected ManagedObject createIpAccessSctp(ManagedObject ipAccessHostEt, Coordinator coordinator) throws RbsConfigurationFailedException {
        ManagedObject ipAccessSctp = this.aMoRepository.lookup("ManagedElement=1,IpSystem=1,IpAccessSctp=1");
        if (ipAccessSctp == null) {
            AttrListImpl attrList = new AttrListImpl();
            attrList.addElement("ipAccessHostEtRef1", (Object)ipAccessHostEt);
            ManagedObject parent = this.findAndCheckParentMo("IpSystem", "ManagedElement=1,IpSystem=1");
            ipAccessSctp = this.createMo("IpAccessSctp", parent, attrList, coordinator);
        }
        return ipAccessSctp;
    }

    protected ManagedObject createIpAccessHostEt(TransportNetworkData transportNetworkData, ManagedObject ipInterface, Coordinator coordinator) throws RbsConfigurationFailedException {
        ManagedObject ipAccessHostEt = this.aMoRepository.lookup("ManagedElement=1,IpSystem=1,IpAccessHostEt=1");
        if (ipAccessHostEt == null) {
            AttrListImpl attrList = new AttrListImpl();
            attrList.addElement("administrativeState", (Object)RbsConfigurationDefinitions.ADMINISTRATIVE_STATE_UNLOCKED);
            attrList.addElement("ipAddress", (Object)transportNetworkData.ipAddress);
            attrList.addElement("ipInterfaceMoRef", (Object)ipInterface);
            ManagedObject parent = this.findAndCheckParentMo("IpSystem", "ManagedElement=1,IpSystem=1");
            ipAccessHostEt = this.createMo("IpAccessHostEt", parent, attrList, coordinator);
        }
        return ipAccessHostEt;
    }

    protected ManagedObject createIpInterface(TransportNetworkData transportNetworkData, Coordinator coordinator) throws RbsConfigurationFailedException {
        ManagedObject ipInterface = this.aMoRepository.lookup("ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,ExchangeTerminalIp=1,GigaBitEthernet=1,IpInterface=1");
        if (ipInterface == null) {
            AttrListImpl attrList = new AttrListImpl();
            attrList.addElement("defaultRouter0", (Object)transportNetworkData.defaultRouter);
            attrList.addElement("networkPrefixLength", (Object)transportNetworkData.networkPrefixLength);
            attrList.addElement("rps", (Object)Boolean.FALSE);
            ManagedObject parent = this.findAndCheckParentMo("GigaBitEthernet", "ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,ExchangeTerminalIp=1,GigaBitEthernet=1");
            ipInterface = this.createMo("IpInterface", parent, attrList, coordinator);
        }
        return ipInterface;
    }

    protected void createOrUpdateSctp(ManagedObject ipAccessSctp, Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createSctp()");
        ManagedObject rpu = this.moFinder.lookup("Sctp", "ManagedElement=1,SwManagement=1,ReliableProgramUniter=sctp_host", "Transport Network configuration failure!");
        ManagedObject eNodeBFunction = this.aMoRepository.lookup("ManagedElement=1,ENodeBFunction=1");
        ManagedObject sctp = this.aMoRepository.lookup("ManagedElement=1,TransportNetwork=1,Sctp=1");
        if (sctp == null) {
            sctp = this.createSctp(ipAccessSctp, rpu, coordinator);
        } else {
            this.updateSctp(ipAccessSctp, sctp, coordinator);
        }
        this.setSctpRefInENodeB(eNodeBFunction, sctp, coordinator);
        logger.traceReturn(THIS_CLASS, "createSctp()");
    }

    private void updateSctp(ManagedObject ipAccessSctp, ManagedObject sctp, Coordinator coordinator) throws RbsConfigurationFailedException {
        String[] attributeNames = new String[]{"ipAccessSctpRef"};
        Object[] attributeValues = new Object[]{ipAccessSctp};
        this.setAttributes(sctp, attributeNames, attributeValues, coordinator);
    }

    private ManagedObject createSctp(ManagedObject ipAccessSctp, ManagedObject rpu, Coordinator coordinator) throws RbsConfigurationFailedException {
        ManagedObject parent = this.findAndCheckParentMo("TransportNetwork", "ManagedElement=1,TransportNetwork=1");
        AttrListImpl attrList = new AttrListImpl();
        attrList.addElement("numberOfAssociations", (Object)RbsConfigurationDefinitions.NUMBER_OF_ASSOCIATIONS_VALUE);
        attrList.addElement("ipAccessSctpRef", (Object)ipAccessSctp);
        attrList.addElement("rpuId", (Object)rpu);
        ManagedObject sctp = this.createMo("Sctp", parent, attrList, coordinator);
        return sctp;
    }
}

