/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.npc.datastructure;

import java.io.IOException;

public class TransportNetworkData {
    public final transient String ipAddress;
    public final transient String defaultRouter;
    public final transient Integer networkPrefixLength;
    public final transient String eNBId;
    public final transient String eNBPlmnId;
    public final transient String mmeIpAddress;
    public final transient String domainName;

    public TransportNetworkData(String ipAddressIn, String defaultRouterIn, String subnetworkMaskIn, String eNBIdIn, String eNBPlmnIdIn, String mmeIpAddressIn, String domainNameIn) throws IOException {
        this.verifyInputParams(ipAddressIn, defaultRouterIn, subnetworkMaskIn, mmeIpAddressIn);
        this.ipAddress = ipAddressIn;
        this.defaultRouter = defaultRouterIn;
        this.networkPrefixLength = this.convertSubnetToNetworkPrefix(subnetworkMaskIn);
        this.eNBId = eNBIdIn;
        this.eNBPlmnId = eNBPlmnIdIn;
        this.mmeIpAddress = mmeIpAddressIn;
        this.domainName = domainNameIn;
    }

    private void verifyInputParams(String ipAddressInput, String defaultRouterInput, String subnetworkMaskInput, String mmeIpAddressInput) throws IOException {
        if (ipAddressInput == null) {
            throw new IOException("Invalid NPC Configuration file: ipAddress is missing.");
        }
        if (defaultRouterInput == null) {
            throw new IOException("Invalid NPC Configuration file: defaultRouter is missing.");
        }
        if (subnetworkMaskInput == null) {
            throw new IOException("Invalid NPC Configuration file: subnetworkMask is missing.");
        }
        if (mmeIpAddressInput == null) {
            throw new IOException("Invalid NPC Configuration file: mmeIpAddress is missing.");
        }
    }

    private Integer convertSubnetToNetworkPrefix(String subnetworkMask) throws IOException {
        String networkPrefixBinary = "";
        int firstPeriod = subnetworkMask.indexOf(46);
        int secondPeriod = subnetworkMask.indexOf(46, firstPeriod + 1);
        int thirdPeriod = subnetworkMask.indexOf(46, secondPeriod + 1);
        int snFieldA = Integer.parseInt(subnetworkMask.substring(0, firstPeriod));
        int snFieldB = Integer.parseInt(subnetworkMask.substring(firstPeriod + 1, secondPeriod));
        int snFieldC = Integer.parseInt(subnetworkMask.substring(secondPeriod + 1, thirdPeriod));
        int snFieldD = Integer.parseInt(subnetworkMask.substring(thirdPeriod + 1));
        networkPrefixBinary = Integer.toBinaryString(snFieldA) + Integer.toBinaryString(snFieldB) + Integer.toBinaryString(snFieldC) + Integer.toBinaryString(snFieldD);
        int lastOne = networkPrefixBinary.lastIndexOf(49);
        int firstZero = networkPrefixBinary.indexOf(48);
        if (firstZero < lastOne) {
            String msg = "SubnetworkMask " + subnetworkMask + " is not a valid mask";
            throw new IOException(msg);
        }
        return new Integer(networkPrefixBinary.lastIndexOf(49) + 1);
    }
}

