/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.npc.transactionpackages;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.npc.datastructure.NpcConfigData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.omf.mao.commonmo.AttrListImpl;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;

public class CreateCellRelationsTp
implements TransactionPackage {
    private final GenericMaoContext genericMaoContext;
    private final NpcConfigData npcConfigData;

    public CreateCellRelationsTp(GenericMaoContext inGenericMaoContext, NpcConfigData inNpcConfigData) {
        this.genericMaoContext = inGenericMaoContext;
        this.npcConfigData = inNpcConfigData;
    }

    public void execute(Coordinator coordinator) throws MoAccessException, InactiveTransactionException {
        this.removeOldRelations(coordinator);
        if (this.npcConfigData.cellRelations != null) {
            boolean fddType = this.npcConfigData.isFddType();
            String cellLdnBase = fddType ? "ManagedElement=1,ENodeBFunction=1,EUtranCellFDD=" : "ManagedElement=1,ENodeBFunction=1,EUtranCellTDD=";
            String cellType = fddType ? "EUtranCellFDD" : "EUtranCellTDD";
            for (int i = 0; i < this.npcConfigData.cellRelations.length; ++i) {
                String faultMsg;
                String slogan;
                String fromCellLdn = cellLdnBase + this.npcConfigData.cellRelations[i].fromCellId;
                String toCellLdn = cellLdnBase + this.npcConfigData.cellRelations[i].toCellId;
                ManagedObject fromCellMo = this.genericMaoContext.getMoRepositoryWrapper().lookup(fromCellLdn);
                ManagedObject toCellMo = this.genericMaoContext.getMoRepositoryWrapper().lookup(toCellLdn);
                if (fromCellMo == null) {
                    slogan = "MO not found";
                    faultMsg = "Could not find the " + cellType + " MO with ldn: " + fromCellLdn + ".";
                    throw new RbsConfigurationFailedException("MO not found", faultMsg);
                }
                if (toCellMo == null) {
                    slogan = "MO not found";
                    faultMsg = "Could not find the " + cellType + " MO with ldn: " + toCellLdn + ".";
                    throw new RbsConfigurationFailedException("MO not found", faultMsg);
                }
                ManagedObject parent = this.getEUtranFreqRelation(fromCellMo, coordinator, fddType);
                String cellRelationBase = parent.getLocalDistinguishedName() + "," + "EUtranCellRelation" + "=";
                int cellRelationId = this.getNextIdForLdnBase(cellRelationBase);
                MoFactory eutrancellrelationFactory = this.genericMaoContext.getMoFactoryMgrWrapper().lookup("EUtranCellRelation");
                AttrListImpl attrList = new AttrListImpl(this.genericMaoContext.getMoRepositoryWrapper());
                attrList.addAttribute("neighborCellRef", (Object)toCellMo);
                eutrancellrelationFactory.createMo(parent, (AttrList)attrList, Integer.toString(cellRelationId), null, coordinator);
                RbsConfigurationReportLoggerFactory.getLogger().logAction("EUtranCellRelation", "create", new String[]{"fromCell", "neighborCellRef"}, new String[]{fromCellMo.getLocalDistinguishedName(), toCellMo.getLocalDistinguishedName()});
            }
        }
    }

    private ManagedObject getEUtranFreqRelation(ManagedObject parent, Coordinator coordinator, boolean fddType) throws MoAccessException {
        ManagedObject result2 = null;
        Integer earfcnValue = null;
        earfcnValue = fddType ? (Integer)parent.getAttribute("earfcndl", coordinator) : (Integer)parent.getAttribute("earfcn", coordinator);
        MoIterator freqRelations = this.genericMaoContext.getMoRepositoryWrapper().lookupType("EUtranFreqRelation");
        while (freqRelations != null && freqRelations.hasMoreElements()) {
            ManagedObject freqRelation = freqRelations.nextMo();
            ManagedObject frequency = (ManagedObject)freqRelation.getAttribute("eutranFrequencyRef", coordinator);
            Integer arfcndlValue = (Integer)frequency.getAttribute("arfcnValueEUtranDl", coordinator);
            if (!freqRelation.getLocalDistinguishedName().startsWith(parent.getLocalDistinguishedName()) || arfcndlValue.intValue() != earfcnValue.intValue()) continue;
            result2 = freqRelation;
            break;
        }
        if (result2 == null) {
            ManagedObject eutranFrequencyMo = this.getEUtranFrequency(earfcnValue, coordinator);
            MoFactory eutranFreqRelationFactory = this.genericMaoContext.getMoFactoryMgrWrapper().lookup("EUtranFreqRelation");
            AttrListImpl attrList = new AttrListImpl(this.genericMaoContext.getMoRepositoryWrapper());
            attrList.addAttribute("eutranFrequencyRef", (Object)eutranFrequencyMo);
            String freqRelationLdnBase = parent.getLocalDistinguishedName() + "," + "EUtranFreqRelation" + "=";
            int freqRelationId = this.getNextIdForLdnBase(freqRelationLdnBase);
            result2 = eutranFreqRelationFactory.createMo(parent, (AttrList)attrList, Integer.toString(freqRelationId), null, coordinator);
        }
        return result2;
    }

    private ManagedObject getEUtranFrequency(Integer earfcn, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        ManagedObject eutranFrequencyMo = null;
        int nrOfFrequencyMos = 0;
        MoIterator frequencies = this.genericMaoContext.getMoRepositoryWrapper().lookupType("EUtranFrequency");
        while (frequencies != null && frequencies.hasMoreElements()) {
            ManagedObject frequencyMo = frequencies.nextMo();
            ++nrOfFrequencyMos;
            if ((long)((Integer)frequencyMo.getAttribute("arfcnValueEUtranDl", coordinator)).intValue() != earfcn.longValue()) continue;
            eutranFrequencyMo = frequencyMo;
            break;
        }
        if (eutranFrequencyMo == null) {
            ManagedObject networkMo = this.genericMaoContext.getMoRepositoryWrapper().lookup("ManagedElement=1,ENodeBFunction=1,EUtraNetwork=1");
            if (networkMo == null) {
                throw new MoNotFoundException("No EUtraNetwork MO found.");
            }
            MoFactory eutranFrequencyFactory = this.genericMaoContext.getMoFactoryMgrWrapper().lookup("EUtranFrequency");
            AttrListImpl attrList = new AttrListImpl(this.genericMaoContext.getMoRepositoryWrapper());
            attrList.addAttribute("arfcnValueEUtranDl", (Object)earfcn);
            eutranFrequencyMo = eutranFrequencyFactory.createMo(networkMo, (AttrList)attrList, Integer.toString(nrOfFrequencyMos + 1), null, coordinator);
        }
        return eutranFrequencyMo;
    }

    private void removeOldRelations(Coordinator coordinator) throws MoAccessException {
        MoIterator existingCellRelations = this.genericMaoContext.getMoRepositoryWrapper().lookupType("EUtranCellRelation");
        if (existingCellRelations != null) {
            while (existingCellRelations.hasMoreElements()) {
                existingCellRelations.nextMo().delete(coordinator);
            }
        }
    }

    private int getNextIdForLdnBase(String ldnBase) {
        ManagedObject result2;
        int nextId = 0;
        while ((result2 = this.genericMaoContext.getMoRepositoryWrapper().lookup(ldnBase + nextId++)) != null) {
        }
        return nextId;
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        String slogan = "Failure creating MO";
        String msg = "Failed to create: EUtranCellRelation MO.";
        throw new RbsConfigurationFailedException("Failure creating MO", "Failed to create: EUtranCellRelation MO.", exception);
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        String slogan = "Transaction failure";
        String faultMsg = "The transaction used when creating the cell relations is inactive.";
        throw new RbsConfigurationFailedException("Transaction failure", "The transaction used when creating the cell relations is inactive.", exception);
    }
}

