/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.npc.transactionpackages;

import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.npc.CellHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.npc.datastructure.NpcConfigData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;

public class CreateCellsTp
implements TransactionPackage {
    private final transient GenericMaoContext genericmaocontext;
    private final transient NpcConfigData npcConfigData;

    public CreateCellsTp(GenericMaoContext inGenericMaoContext, NpcConfigData inNpcConfigData) {
        this.genericmaocontext = inGenericMaoContext;
        this.npcConfigData = inNpcConfigData;
    }

    public void execute(Coordinator coordinator) throws MoAccessException, InactiveTransactionException {
        CellHelper cellHelper = new CellHelper(this.genericmaocontext);
        for (int cellIndex = 0; cellIndex < this.npcConfigData.cells.length; ++cellIndex) {
            cellHelper.createCell(this.npcConfigData.cells[cellIndex], coordinator);
        }
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        String cellType = "Undefined";
        if (this.npcConfigData != null) {
            cellType = this.npcConfigData.isFddType() ? "EUtranCellFDD" : "EUtranCellTDD";
        }
        String slogan = "Failure creating MO";
        String msg = "Failed to create: " + cellType + " MO.";
        throw new RbsConfigurationFailedException("Failure creating MO", msg, exception);
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        String slogan = "Transaction failure";
        String faultMsg = "The transaction used when creating the cells is inactive.";
        throw new RbsConfigurationFailedException("Transaction failure", "The transaction used when creating the cells is inactive.", exception);
    }
}

