/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.npc.transactionpackages;

import se.ericsson.cello.licensing.LicensingMo;
import se.ericsson.cello.managedelement.ManagedElementMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class SetLogicalNameTp
implements TransactionPackage {
    private static final Class THIS_CLASS = SetLogicalNameTp.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final String logicalName;
    private boolean setUln;
    private final MoRepositoryWrapper aMoRepository;

    public SetLogicalNameTp(String inlogicalName, MoRepositoryWrapper inAMoRepository) {
        this.logicalName = inlogicalName;
        this.aMoRepository = inAMoRepository;
    }

    public void execute(Coordinator coordinator) throws MoAccessException, InactiveTransactionException {
        logger.traceEnter(THIS_CLASS, "execute() logicalname = " + this.logicalName);
        ManagedElementMo managedElement = (ManagedElementMo)this.aMoRepository.lookup("ManagedElement=1");
        managedElement.setLogicalName(this.logicalName, coordinator);
        this.setUln = true;
        LicensingMo licensing = (LicensingMo)this.aMoRepository.lookup("ManagedElement=1,SystemFunctions=1,Licensing=1");
        licensing.setUln(this.logicalName, coordinator);
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        if (this.setUln) {
            throw new RbsConfigurationFailedException("Unable to set attribute", "Could not set Licensing.fingerprint/uln", exception);
        }
        throw new RbsConfigurationFailedException("Unable to set attribute", "Could not set ManagedElement::logicalName", exception);
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        this.handleExecutionException(exception);
    }
}

