/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.oss;

import org.omg.CORBA.SystemException;
import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.ipoam.EthernetLinkMo;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationContext;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.oss.OssInformer;
import se.ericsson.crbs.cat.mao.rbsconfiguration.oss.OssInformerHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.oss.ipaddresschange.NodeIpAddressChange;
import se.ericsson.crbs.cat.mao.rbsconfiguration.oss.ipaddresschange.OssNodeIpAddressChangedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.oss.ipaddresschange.OssNodeIpAddressChangedResolver;
import se.ericsson.crbs.cat.mao.rbsconfiguration.oss.ipaddresschange.OssNodeIpAddressChangedResolverFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.oss.ipaddresschange.Reason;
import se.ericsson.crbs.cat.mao.rbsconfiguration.oss.nodediscover.IpSecLevel;
import se.ericsson.crbs.cat.mao.rbsconfiguration.oss.nodediscover.NodeDiscovery;
import se.ericsson.crbs.cat.mao.rbsconfiguration.oss.nodediscover.NodeSecurityIntegration;
import se.ericsson.crbs.cat.mao.rbsconfiguration.oss.nodediscover.NodeSecurityIntegrationOperations;
import se.ericsson.crbs.cat.mao.rbsconfiguration.oss.nodediscover.NodeSecurityIntegrationPackage.NotAcceptedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.oss.nodediscover.OssNodeDiscoveryException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.oss.nodediscover.OssNodeDiscoveryResolver;
import se.ericsson.crbs.cat.mao.rbsconfiguration.oss.nodediscover.OssNodeDiscoveryResolverFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.oss.nodediscover.SecurityLevel;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.ProgressReportHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.RbsConfigurationSiteEquipmentFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.RbsConfigurationSiteEquipmentImpl;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class OssInformerImpl
implements OssInformer {
    private final Class THIS_CLASS = OssInformerImpl.class;
    private final AbstractLogger logger = LoggingService.getLogger((String)this.THIS_CLASS.getName());
    protected final String INFORMING_THREAD_NAME = "CRBS_lmCatOamLmU_RbsConfiguration_oss_informer";
    protected Thread ossInformingThread = null;
    private long currentOssThreadSleepingTime = 60000L;
    protected long currentTimeoutTime = 0L;
    private final RbsConfigurationContext rbsConfigurationContext;

    public OssInformerImpl(RbsConfigurationContext inRbsConfigurationContext) {
        this.rbsConfigurationContext = inRbsConfigurationContext;
    }

    public Thread getOssInformingThread() {
        return this.ossInformingThread;
    }

    public void setOssThreadSleepingTime(long ossThreadSleepingTime) {
        this.currentOssThreadSleepingTime = ossThreadSleepingTime;
    }

    public void informOss(final String rbsDn, final String rbsIpAddress) {
        this.logger.traceEnter(this.THIS_CLASS, "informOss()" + rbsIpAddress);
        RbsConfigurationHelper helper = (RbsConfigurationHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationHelper.class);
        final OssInformerHelper ossInformerHelper = new OssInformerHelper(helper, this.rbsConfigurationContext.getMoRepositoryWrapper(), rbsIpAddress.indexOf(":") != -1);
        Runnable ossInformer = new Runnable(){

            public void run() {
                long startTime = System.currentTimeMillis();
                while (!OssInformerImpl.this.doInformOss(rbsDn, rbsIpAddress, ossInformerHelper)) {
                    long currentTime;
                    if (OssInformerImpl.this.currentTimeoutTime > 0L && (currentTime = System.currentTimeMillis()) >= startTime + OssInformerImpl.this.currentTimeoutTime) {
                        OssInformerImpl.this.logger.traceGeneral(OssInformerImpl.this.THIS_CLASS, "informOss() timed out after " + OssInformerImpl.this.currentTimeoutTime + " milliseconds.");
                        break;
                    }
                    try {
                        Thread.sleep(OssInformerImpl.this.currentOssThreadSleepingTime);
                    }
                    catch (InterruptedException ie) {
                        OssInformerImpl.this.logger.info(OssInformerImpl.this.THIS_CLASS, "Could not sleep in OSS informing thread. " + ie.getMessage());
                    }
                }
            }
        };
        this.ossInformingThread = new Thread(ossInformer, "CRBS_lmCatOamLmU_RbsConfiguration_oss_informer");
        this.ossInformingThread.setDaemon(true);
        this.ossInformingThread.start();
        this.logger.traceReturn(this.THIS_CLASS, "informOss()");
    }

    public void nodeSecurityUp(String rbsIpAddress, String sshKey, String installerName, int wantedSecLevel, int minimumSecLevel, int reachedSecLevel, String securityChecksum, String securityChecksumVersion, String oamCertSerNo, String oamCertFingerPrint, int wantedIpSecLevel, int reachedIpSecLevel, String iPSecCUSCertSerNo, String iPSecCUSCertFingerPrint) {
        this.logger.traceEnter(this.THIS_CLASS, "nodeSecurityUp()");
        this.sendMessageToOss(null, rbsIpAddress, sshKey, installerName, wantedSecLevel, minimumSecLevel, reachedSecLevel, securityChecksum, securityChecksumVersion, oamCertSerNo, oamCertFingerPrint, wantedIpSecLevel, reachedIpSecLevel, iPSecCUSCertSerNo, iPSecCUSCertFingerPrint);
        this.logger.traceReturn(this.THIS_CLASS, "nodeSecurityUp()");
    }

    public void nodeSecurityAddressChanged(String rbsDn, String rbsIpAddress, String sshKey, String installerName, int wantedSecLevel, int minimumSecLevel, int reachedSecLevel, String securityChecksum, String securityChecksumVersion, String oamCertSerNo, String oamCertFingerPrint, int wantedIpSecLevel, int reachedIpSecLevel, String iPSecCUSCertSerNo, String iPSecCUSCertFingerPrint) {
        this.logger.traceEnter(this.THIS_CLASS, "nodeSecurityAddressChanged()");
        this.logger.traceDebug(this.THIS_CLASS, "calling sendMessageToOss: { rbsDn: \"" + rbsDn + "\", " + "rbsIpAddress: \"" + rbsIpAddress + "\", " + "sshKey: \"" + sshKey + "\", " + "installerName: \"" + installerName + "\", " + "wantedSecLevel: \"" + wantedSecLevel + "\", " + "minimumSecLevel: \"" + minimumSecLevel + "\", " + "reachedSecLevel: \"" + reachedSecLevel + "\", " + "securityChecksum: \"" + securityChecksum + "\", " + "securityChecksumVersion: \"" + securityChecksumVersion + "\", " + "oamCertSerNo: \"" + oamCertSerNo + "\", " + "oamCertFingerPrint: \"" + oamCertFingerPrint + "\", " + "wantedIpSecLevel: \"" + wantedIpSecLevel + "\", " + "reachedIpSecLevel: \"" + reachedIpSecLevel + "\", " + "iPSecCUSCertSerNo: \"" + iPSecCUSCertSerNo + "\", " + "iPSecCUSCertFingerPrint: \"" + iPSecCUSCertFingerPrint + "\"}");
        this.sendMessageToOss(rbsDn, rbsIpAddress, sshKey, installerName, wantedSecLevel, minimumSecLevel, reachedSecLevel, securityChecksum, securityChecksumVersion, oamCertSerNo, oamCertFingerPrint, wantedIpSecLevel, reachedIpSecLevel, iPSecCUSCertSerNo, iPSecCUSCertFingerPrint);
        this.logger.traceReturn(this.THIS_CLASS, "nodeSecurityAddressChanged()");
    }

    private void sendMessageToOss(final String rbsDn, final String rbsIpAddress, final String sshKey, final String installerName, final int wantedSecLevel, final int minimumSecLevel, int reachedSecLevel, final String securityChecksum, final String securityChecksumVersion, final String oamCertSerNo, final String oamCertFingerPrint, final int wantedIpSecLevel, final int reachedIpSecLevel, final String iPSecCUSCertSerNo, final String iPSecCUSCertFingerPrint) {
        final RbsConfigurationHelper helper = (RbsConfigurationHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationHelper.class);
        final OssInformerHelper ossInformerHelper = new OssInformerHelper(helper, this.rbsConfigurationContext.getMoRepositoryWrapper(), rbsIpAddress.indexOf(":") != -1);
        final int correctedReachedSecLevel = reachedSecLevel == 4 ? 3 : reachedSecLevel;
        this.logger.traceDebug(this.THIS_CLASS, "sendMessageToOss(): will report reached security level " + correctedReachedSecLevel);
        Runnable ossInformer = new Runnable(){

            public void run() {
                long startTime = System.currentTimeMillis();
                while (!OssInformerImpl.this.doNodeSecurityUp(rbsDn, rbsIpAddress, sshKey, installerName, OssInformerImpl.this.convertToSecurityLevelEnum(wantedSecLevel), OssInformerImpl.this.convertToSecurityLevelEnum(minimumSecLevel), OssInformerImpl.this.convertToSecurityLevelEnum(correctedReachedSecLevel), securityChecksum, securityChecksumVersion, oamCertSerNo, oamCertFingerPrint, IpSecLevel.from_int(wantedIpSecLevel), IpSecLevel.from_int(reachedIpSecLevel), iPSecCUSCertSerNo, iPSecCUSCertFingerPrint, helper, ossInformerHelper)) {
                    long currentTime;
                    if (OssInformerImpl.this.currentTimeoutTime > 0L && (currentTime = System.currentTimeMillis()) >= startTime + OssInformerImpl.this.currentTimeoutTime) {
                        OssInformerImpl.this.reportProgressReportRetrying("Informing OSS that the RBS is up and running timed out after: " + OssInformerImpl.this.currentTimeoutTime + " ms.");
                        OssInformerImpl.this.logger.traceGeneral(OssInformerImpl.this.THIS_CLASS, "informOss() timed out after " + OssInformerImpl.this.currentTimeoutTime + " milliseconds.");
                        break;
                    }
                    try {
                        Thread.sleep(OssInformerImpl.this.currentOssThreadSleepingTime);
                    }
                    catch (InterruptedException ie) {
                        OssInformerImpl.this.logger.traceAbnormal(OssInformerImpl.this.THIS_CLASS, "Could not sleep in OSS informing thread. " + ie.getMessage());
                    }
                }
            }
        };
        this.ossInformingThread = new Thread(ossInformer, "CRBS_lmCatOamLmU_RbsConfiguration_oss_informer");
        this.ossInformingThread.setDaemon(true);
        this.ossInformingThread.start();
    }

    public void notificationOfChangedIpAddress(String nodeId, String oldIp, String newIp, Reason reason, String hash) throws MoAccessException, se.ericsson.crbs.cat.mao.rbsconfiguration.oss.ipaddresschange.NodeIpAddressChangePackage.NotAcceptedException, OssNodeIpAddressChangedException {
        String nameServerAddress = "Not set yet";
        int nameServerPort = -1;
        String nodeIpAddressChangeServiceName = "Not set yet";
        try {
            RbsConfigurationHelper helper = (RbsConfigurationHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationHelper.class);
            OssInformerHelper ossInformerHelper = new OssInformerHelper(helper, this.rbsConfigurationContext.getMoRepositoryWrapper(), newIp.indexOf(":") != -1);
            nameServerAddress = ossInformerHelper.getOssAddress();
            nameServerPort = this.getOssPort();
            nodeIpAddressChangeServiceName = ossInformerHelper.getOssNodeIpAddressChangeServiceName();
            OssNodeIpAddressChangedResolver ossNodeIpAddressChangedResolver = OssNodeIpAddressChangedResolverFactory.createOssNodeIpAddressChangedResolver(nameServerAddress, nameServerPort, nodeIpAddressChangeServiceName);
            NodeIpAddressChange nodeIpAddressChange = null;
            nodeIpAddressChange = ossNodeIpAddressChangedResolver.resolveNodeIpAddressChange();
            String remoteCallParameters = "nodeId " + nodeId + ", oldIp " + oldIp + ", newIp " + newIp + ", reason " + reason + ", hash " + hash;
            this.logger.traceDebug(this.THIS_CLASS, "Calling " + nodeIpAddressChange + "\nremoteCallParameters: " + remoteCallParameters);
            nodeIpAddressChange.notificationOfChangedIpAddress(nodeId, oldIp, newIp, reason, hash);
            this.logger.traceDebug(this.THIS_CLASS, "Successfully called notificationOfChangedIpAddress().");
        }
        catch (MoAccessException mae) {
            String errorMsg = "Failed to retrieve name server address";
            throw new RbsConfigurationFailedException("Calling notificationOfChangedIpAddress() failed.", "Failed to retrieve name server address", (Exception)((Object)mae));
        }
        catch (OssNodeIpAddressChangedException oniace) {
            String errorMsg = "Failed to resolve \"" + nodeIpAddressChangeServiceName + "\" from OSS name service, \"" + nameServerAddress + "\", on port, " + nameServerPort;
            throw new OssNodeIpAddressChangedException(errorMsg, oniace);
        }
        catch (se.ericsson.crbs.cat.mao.rbsconfiguration.oss.ipaddresschange.NodeIpAddressChangePackage.NotAcceptedException nae) {
            String errorMsg = "Failed to notify \"" + nodeIpAddressChangeServiceName + "\"";
            throw new se.ericsson.crbs.cat.mao.rbsconfiguration.oss.ipaddresschange.NodeIpAddressChangePackage.NotAcceptedException(errorMsg, nae.nodeId, nae.oldIp, nae.newIp, nae.reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doInformOss(String rbsDn, String rbsIpAddress, OssInformerHelper ossInformerHelper) {
        this.logger.traceEnter(this.THIS_CLASS, "doInformOss(" + rbsIpAddress + ")");
        boolean success = false;
        String errorMsg = "";
        String debugPrintInfo = "";
        NodeDiscovery nodeDiscovery = null;
        NodeSecurityIntegration nodeSecurityIntegration = null;
        try {
            String nameServerAddress = ossInformerHelper.getOssAddress();
            int nameServerPort = this.getOssPort();
            if (rbsDn != null) {
                String nodeSecurityUpServiceName = ossInformerHelper.getOssNodeSecurityIntegrationServiceName(nameServerAddress);
                debugPrintInfo = " calling doResolveNodeSecurityInterface with nameServerAddress = " + nameServerAddress + ", nameServerPort = " + nameServerPort + ", nodeSecurityUpServiceName = " + nodeSecurityUpServiceName;
                this.logger.traceDebug(this.THIS_CLASS, "doInformOss:" + debugPrintInfo);
                nodeSecurityIntegration = this.doResolveNodeSecurityInterface(nameServerAddress, nameServerPort, nodeSecurityUpServiceName, rbsIpAddress.indexOf(":") != -1);
                this.logger.traceDebug(this.THIS_CLASS, "doInformOss: doResolveNodeSecurityInterface returned nodeSecurityIntegration = " + nodeSecurityIntegration);
                this.logger.traceDebug(this.THIS_CLASS, "doInformOss: calling nodeAddressChanged, rbsDn = " + rbsDn + ", rbsIpAddress = " + rbsIpAddress);
                nodeSecurityIntegration.nodeAddressChanged(rbsDn, rbsIpAddress);
            } else {
                String nodeDiscoveryServiceName = ossInformerHelper.getOssNodeDiscoveryServiceName();
                debugPrintInfo = " calling doResolveNodeInterface with nameServerAddress = " + nameServerAddress + ", nameServerPort = " + nameServerPort + ", nodeDiscoveryServiceName = " + nodeDiscoveryServiceName;
                this.logger.traceDebug(this.THIS_CLASS, "doInformOss:" + debugPrintInfo);
                nodeDiscovery = this.doResolveNodeInterface(nameServerAddress, nameServerPort, nodeDiscoveryServiceName, rbsIpAddress.indexOf(":") != -1);
                this.logger.traceDebug(this.THIS_CLASS, "doInformOss: doResolveNodeInterface returned nodeDiscovery = " + nodeDiscovery);
                this.logger.traceDebug(this.THIS_CLASS, "doInformOss: calling nodeUp, rbsIpAddress = " + rbsIpAddress);
                nodeDiscovery.nodeUp(rbsIpAddress);
            }
            this.logger.traceGeneral(this.THIS_CLASS, "Informed OSS about node up and running.");
            success = true;
        }
        catch (OssNodeDiscoveryException onde) {
            errorMsg = "Generic Failure. " + onde.getMessage() + ". Retrying...";
        }
        catch (se.ericsson.crbs.cat.mao.rbsconfiguration.oss.nodediscover.NodeDiscoveryPackage.NotAcceptedException nae) {
            errorMsg = "OSS did not accept the Node Discovery message. Retrying...";
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            errorMsg = "Unsystemized error: " + throwable + " " + throwable.getMessage();
        }
        finally {
            if (nodeDiscovery != null) {
                try {
                    nodeDiscovery._release();
                }
                catch (SystemException systemException) {
                    this.logger.info(this.THIS_CLASS, "Failed to release NodeDiscoveryStub, reason " + systemException.getMessage());
                }
            }
        }
        if (!success) {
            this.logger.info(this.THIS_CLASS, errorMsg + debugPrintInfo + ".Retrying...");
        } else {
            try {
                this.checkAndLockLmtPorts();
            }
            catch (OperationNotAllowedException e) {
                this.logger.traceGeneral(this.THIS_CLASS, "Hardware does not support disabling LMT ports: " + e.toString());
            }
            catch (MoAccessException e) {
                this.logger.traceError(this.THIS_CLASS, "Error when disabling LMT ports: " + e.toString());
            }
            catch (Exception e) {
                this.logger.traceError(this.THIS_CLASS, "General exception when disabling LMT ports: " + e.toString());
            }
        }
        this.logger.traceReturn(this.THIS_CLASS, "doInformOss(" + rbsIpAddress + ")");
        return success;
    }

    private void checkAndLockLmtPorts() throws MoAccessException {
        this.logger.traceEnter(this.THIS_CLASS, "checkAndLockLmtPorts()");
        RbsConfigurationSiteEquipmentImpl siteEquipment = (RbsConfigurationSiteEquipmentImpl)RbsConfigurationSiteEquipmentFactory.getInstance().getRbsConfigurationSiteEquipment(this.rbsConfigurationContext.getRbsConfigurationMao(), false);
        boolean isLmtPortsLocked = siteEquipment.getNodeData().isLmtPortsLocked();
        this.logger.traceDebug(this.THIS_CLASS, "Value of lmtPorts flag in site equipment is: " + isLmtPortsLocked);
        if (isLmtPortsLocked) {
            PlugInUnitMo nextMo;
            MoIterator moIterator = this.rbsConfigurationContext.getMoRepositoryWrapper().lookupType("PlugInUnit");
            this.logger.traceDebug(this.THIS_CLASS, "Number of PluginUnits found: " + (moIterator == null ? 0 : moIterator.size()));
            if (moIterator != null) {
                while (moIterator.hasMoreElements()) {
                    nextMo = (PlugInUnitMo)moIterator.nextMo();
                    this.logger.traceDebug(this.THIS_CLASS, "Call CPP to disable ports on PluginUnit: " + nextMo.getLocalDistinguishedName());
                    nextMo.actionDisablePersistent(null);
                }
            }
            moIterator = this.rbsConfigurationContext.getMoRepositoryWrapper().lookupType("EthernetLink");
            this.logger.traceDebug(this.THIS_CLASS, "Number of EthernetLinks found: " + (moIterator == null ? 0 : moIterator.size()));
            if (moIterator != null) {
                while (moIterator.hasMoreElements()) {
                    nextMo = (EthernetLinkMo)moIterator.nextMo();
                    this.logger.traceDebug(this.THIS_CLASS, "Call CPP to disable ports on EthernetLink: " + nextMo.getLocalDistinguishedName());
                    nextMo.actionDisablePersistent(null);
                }
            }
        }
        this.logger.traceReturn(this.THIS_CLASS, "checkAndLockLmtPorts()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doNodeSecurityUp(String rbsDn, String rbsIpAddress, String sshKey, String installerName, SecurityLevel wantedSecLevel, SecurityLevel minimumSecLevel, SecurityLevel reachedSecLevel, String securityChecksum, String securityChecksumVersion, String oamCertSerNo, String oamCertFingerPrint, IpSecLevel wantedIpSecLevel, IpSecLevel reachedIpSecLevel, String iPSecCUSCertSerNo, String iPSecCUSCertFingerPrint, RbsConfigurationHelper helper, OssInformerHelper ossInformerHelper) {
        this.logger.traceEnter(this.THIS_CLASS, "doNodeSecurityUp(" + rbsIpAddress + ")");
        String errorMsg = "";
        boolean success = false;
        NodeDiscovery nodeDiscovery = null;
        try {
            String nameServerAddress = ossInformerHelper.getOssAddress();
            int nameServerPort = this.getOssPort();
            String nodeSecurityUpServiceName = ossInformerHelper.getOssNodeSecurityIntegrationServiceName(nameServerAddress);
            String nodeDiscoveryServiceName = ossInformerHelper.getOssNodeDiscoveryServiceName();
            String usedServiceName = nodeSecurityUpServiceName;
            NodeSecurityIntegrationOperations nodeSecurityIntegration = null;
            boolean breakFromLoop = false;
            while (!breakFromLoop) {
                try {
                    this.logger.traceDebug(this.THIS_CLASS, "doNodeSecurityUp: calling doResolveNodeSecurityInterface with nameServerAddress = " + nameServerAddress + ", nameServerPort = " + nameServerPort + ", nodeSecurityUpServiceName = " + nodeSecurityUpServiceName);
                    nodeSecurityIntegration = this.doResolveNodeSecurityInterface(nameServerAddress, nameServerPort, nodeSecurityUpServiceName, rbsIpAddress.indexOf(":") != -1);
                    this.logger.traceDebug(this.THIS_CLASS, "doNodeSecurityUp: doResolveNodeSecurityInterface returned nodeSecurityIntegration = " + nodeSecurityIntegration);
                    breakFromLoop = true;
                }
                catch (OssNodeDiscoveryException onde) {
                    if (rbsDn != null) continue;
                    breakFromLoop = true;
                    nodeSecurityIntegration = null;
                    this.logger.traceGeneral(this.THIS_CLASS, "doNodeSecurityUp: doResolveNodeSecurityInterface failed..., OssNodeDiscoveryException " + onde.getMessage());
                }
            }
            if (nodeSecurityIntegration == null) {
                this.logger.traceDebug(this.THIS_CLASS, "doNodeSecurityUp: calling doResolveNodeInterface with nameServerAddress = " + nameServerAddress + ", nameServerPort = " + nameServerPort + ", nodeDiscoveryServiceName = " + nodeDiscoveryServiceName);
                nodeDiscovery = this.doResolveNodeInterface(nameServerAddress, nameServerPort, nodeDiscoveryServiceName, rbsIpAddress.indexOf(":") != -1);
                usedServiceName = nodeDiscoveryServiceName;
                this.logger.traceDebug(this.THIS_CLASS, "doNodeSecurityUp: doResolveNodeInterface returned nodeDiscovery = " + nodeDiscovery);
                nodeDiscovery.nodeUp(rbsIpAddress);
                this.logger.traceDebug(this.THIS_CLASS, "doNodeSecurityUp: successfully called nodeUp");
            } else {
                if (rbsDn != null) {
                    this.logger.traceDebug(this.THIS_CLASS, "doNodeSecurityUp: calling nodeSecurityAddressChanged. rbsDn: " + rbsDn + " rbsIpAddress: " + rbsIpAddress);
                    nodeSecurityIntegration.nodeSecurityAddressChanged(rbsDn, rbsIpAddress, sshKey, installerName, wantedSecLevel, minimumSecLevel, reachedSecLevel, securityChecksum, securityChecksumVersion, oamCertSerNo, oamCertFingerPrint, wantedIpSecLevel, reachedIpSecLevel, iPSecCUSCertSerNo, iPSecCUSCertFingerPrint);
                } else {
                    this.logger.traceDebug(this.THIS_CLASS, "doNodeSecurityUp: calling nodeSecurityUp. rbsIpAddress: " + rbsIpAddress);
                    nodeSecurityIntegration.nodeSecurityUp(rbsIpAddress, sshKey, installerName, wantedSecLevel, minimumSecLevel, reachedSecLevel, securityChecksum, securityChecksumVersion, oamCertSerNo, oamCertFingerPrint, wantedIpSecLevel, reachedIpSecLevel, iPSecCUSCertSerNo, iPSecCUSCertFingerPrint);
                }
                this.logger.traceDebug(this.THIS_CLASS, "doNodeSecurityUp: nodeSecurityUp successful");
            }
            this.logger.traceGeneral(this.THIS_CLASS, "Informed OSS about node up and running.");
            RbsConfigurationReportLoggerFactory.getLogger().logAction("OSS", "Inform OSS", new String[]{"IPAddress", "nameServerAddress:port", "nodeDiscoveryService"}, new Object[]{rbsIpAddress, nameServerAddress + ":" + nameServerPort, usedServiceName});
            ProgressReportHandler.getInstance().updateProgressReportInformation(2300, 5, "Successfuly informed OSS that the RBS is up and running", true);
            success = true;
        }
        catch (OssNodeDiscoveryException onde) {
            errorMsg = "Generic Failure. " + onde.getMessage() + ". Retrying...";
        }
        catch (MoAccessException mae) {
            errorMsg = "Generic Failure. " + mae.getVariablesAsString() + ". Retrying...";
        }
        catch (NotAcceptedException nae2) {
            errorMsg = "OSS did not accept the Node Security Integration message. Retrying...";
        }
        catch (se.ericsson.crbs.cat.mao.rbsconfiguration.oss.nodediscover.NodeDiscoveryPackage.NotAcceptedException nae) {
            errorMsg = "OSS did not accept the Node Discovery message. Retrying...";
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            errorMsg = "Unsystemized error: " + throwable + " " + throwable.getMessage();
        }
        finally {
            if (nodeDiscovery != null) {
                try {
                    nodeDiscovery._release();
                }
                catch (SystemException systemException) {
                    this.logger.info(this.THIS_CLASS, "Failed to release NodeDiscoveryStub, reason " + systemException.getMessage());
                }
            }
        }
        if (!success) {
            this.reportRetrying(helper, errorMsg);
        } else {
            try {
                this.checkAndLockLmtPorts();
            }
            catch (OperationNotAllowedException e) {
                this.logger.traceGeneral(this.THIS_CLASS, "Hardware does not support disabling LMT ports: " + e.toString());
            }
            catch (MoAccessException e) {
                this.logger.traceError(this.THIS_CLASS, "Error when disabling LMT ports: " + e.toString());
            }
            catch (Exception e) {
                this.logger.traceError(this.THIS_CLASS, "General exception when disabling LMT ports: " + e.toString());
            }
        }
        this.logger.traceReturn(this.THIS_CLASS, "doNodeSecurityUp(" + rbsIpAddress + ")");
        return success;
    }

    private SecurityLevel convertToSecurityLevelEnum(int secLevel) {
        SecurityLevel result2;
        switch (secLevel) {
            case 1: {
                result2 = SecurityLevel.level_1;
                break;
            }
            case 2: {
                result2 = SecurityLevel.level_2;
                break;
            }
            case 3: {
                result2 = SecurityLevel.level_3;
                break;
            }
            case 4: {
                result2 = SecurityLevel.level_3;
                break;
            }
            default: {
                result2 = SecurityLevel.level_1;
            }
        }
        return result2;
    }

    private NodeDiscovery doResolveNodeInterface(String nameServerAddress, int nameServerPort, String nodeDiscoveryServiceName, boolean isIpv6) throws OssNodeDiscoveryException {
        OssNodeDiscoveryResolver ossNodeDiscoveryResolver = OssNodeDiscoveryResolverFactory.createOssNodeDiscoveryResolver(nameServerAddress, nameServerPort, nodeDiscoveryServiceName, isIpv6);
        return ossNodeDiscoveryResolver.resolveNodeDiscovery();
    }

    private NodeSecurityIntegration doResolveNodeSecurityInterface(String nameServerAddress, int nameServerPort, String nodeSecurityServiceName, boolean isIpv6) throws OssNodeDiscoveryException {
        OssNodeDiscoveryResolver ossNodeDiscoveryResolver = OssNodeDiscoveryResolverFactory.createOssNodeDiscoveryResolver(nameServerAddress, nameServerPort, nodeSecurityServiceName, isIpv6);
        return ossNodeDiscoveryResolver.resolveNodeSecurityIntegration();
    }

    private void reportRetrying(RbsConfigurationHelper helper, String errorMsg) {
        this.reportProgressReportRetrying(errorMsg);
        helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_OSS_CONNECTION_FAULT, "OSS connection fault", errorMsg);
        this.logger.traceAbnormal(this.THIS_CLASS, errorMsg);
    }

    private void reportProgressReportRetrying(String errorMsg) {
        ProgressReportHandler.getInstance().updateProgressReportInformation(2300, 4, errorMsg, true);
    }

    private int getOssPort() {
        this.logger.traceEnter(this.THIS_CLASS, "getOSSPort()");
        int port = 50073;
        this.logger.traceReturn(this.THIS_CLASS, "getOSSPort() - 50073");
        return 50073;
    }

    public void setTimeoutTime(long timeoutTime) {
        this.currentTimeoutTime = timeoutTime;
    }
}

