/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.parameters;

import java.util.ArrayList;
import java.util.HashMap;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationContext;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.SensitiveDataHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public abstract class AbstractParameters {
    private static final Class THIS_CLASS = AbstractParameters.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    protected static final String NOT_SET = "";
    protected static final String COMMA = ",";
    protected static final String SPACE = " ";
    private static final String INDENTATION = "  ";
    private final Object MUTEX = new Object();
    protected final RbsConfigurationMao rbsConfigurationMao;
    private final String[] parameterNames;
    private final HashMap parameterMap = new HashMap();

    protected AbstractParameters(RbsConfigurationMao rbsConfigurationMaoIn, String[] parameterNamesIn) {
        this.rbsConfigurationMao = rbsConfigurationMaoIn;
        this.parameterNames = parameterNamesIn;
        this.retrievePersistently();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        Object object = this.MUTEX;
        synchronized (object) {
            for (int p = 0; p < this.parameterNames.length; ++p) {
                this.rbsConfigurationMao.removeAdditionalAttribute(this.parameterNames[p], null);
                this.parameterMap.put(this.parameterNames[p], NOT_SET);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Coordinator coordinator) {
        Object object = this.MUTEX;
        synchronized (object) {
            for (int p = 0; p < this.parameterNames.length; ++p) {
                this.rbsConfigurationMao.removeAdditionalAttribute(this.parameterNames[p], coordinator);
                this.parameterMap.put(this.parameterNames[p], NOT_SET);
            }
        }
    }

    public String toString() {
        StringBuffer result2 = new StringBuffer();
        for (int p = 0; p < this.parameterNames.length; ++p) {
            String value = this.getParameter(this.parameterNames[p]);
            if (value.length() <= 0) continue;
            result2.append((p == 0 ? NOT_SET : ", ") + this.parameterNames[p] + "=" + value);
        }
        return result2.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getParameter(String paramName) {
        Object object = this.MUTEX;
        synchronized (object) {
            return (String)this.parameterMap.get(paramName);
        }
    }

    protected String getConvertParameter(String correctName, String[] oldNames) {
        String valueReturn = this.getParameter(correctName);
        if (AbstractParameters.isEmpty(valueReturn) && oldNames != null) {
            for (int i = 0; oldNames.length > i; ++i) {
                String value = (String)this.rbsConfigurationMao.retrievePersistently(oldNames[i]);
                if (value == null) continue;
                return value;
            }
        }
        return valueReturn;
    }

    protected String correctParameterName(String correctName, String[] oldNames, Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "correctParameterName");
        String valueReturn = this.getParameter(correctName);
        if (AbstractParameters.isEmpty(valueReturn) && oldNames != null) {
            for (int i = 0; oldNames.length > i; ++i) {
                String value = (String)this.rbsConfigurationMao.retrievePersistently(oldNames[i]);
                if (value == null) continue;
                valueReturn = value;
                logger.traceDebug(THIS_CLASS, "Oldname=" + oldNames[i] + " Correctname=" + correctName + " Value=" + value);
                this.setParameter(correctName, value, coordinator);
                this.rbsConfigurationMao.removeAdditionalAttribute(oldNames[i], coordinator);
                break;
            }
        }
        logger.traceReturn(THIS_CLASS, "correctParameterName");
        return valueReturn;
    }

    protected boolean setParameter(String paramName, String paramValue) {
        return this.setParameter(paramName, paramValue, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setParameter(String paramName, String paramValue, Coordinator coordinator) {
        Object object = this.MUTEX;
        synchronized (object) {
            boolean result2 = false;
            if (this.parameterMap.containsKey(paramName)) {
                this.parameterMap.put(paramName, AbstractParameters.notNull(paramValue));
                this.storePersistently(paramName, coordinator);
                result2 = true;
            }
            return result2;
        }
    }

    protected String retrievePersistently(String paramName) {
        return AbstractParameters.notNull((String)this.rbsConfigurationMao.retrievePersistently(paramName));
    }

    private void retrievePersistently() {
        for (int p = 0; p < this.parameterNames.length; ++p) {
            this.parameterMap.put(this.parameterNames[p], AbstractParameters.notNull((String)this.rbsConfigurationMao.retrievePersistently(this.parameterNames[p])));
        }
    }

    private void storePersistently(String paramName, Coordinator coordinator) {
        try {
            if (coordinator == null) {
                this.rbsConfigurationMao.storePersistently(paramName, this.parameterMap.get(paramName));
            } else {
                this.rbsConfigurationMao.storePersistently(paramName, this.parameterMap.get(paramName), coordinator);
            }
        }
        catch (MoAccessException hopfullyWontHappen) {
            logger.traceError(THIS_CLASS, "Failed to store " + paramName + "=" + this.parameterMap.get(paramName) + " persistently");
        }
    }

    protected SensitiveDataHelper getSensitiveDataHelper() {
        RbsConfigurationContext context = this.rbsConfigurationMao.getRbsConfigurationContext();
        SensitiveDataHelper sensitiveDataHelper = (SensitiveDataHelper)context.getHelper(SensitiveDataHelper.class);
        return sensitiveDataHelper;
    }

    protected static String notNull(String someParam) {
        return someParam == null ? NOT_SET : someParam;
    }

    protected static boolean isEmpty(String someParam) {
        return someParam == null || NOT_SET.equals(someParam);
    }

    protected static String getIndentation(int indentLevel) {
        StringBuffer indentation = new StringBuffer();
        for (int i = 0; i < indentLevel; ++i) {
            indentation.append(INDENTATION);
        }
        return indentation.toString();
    }

    protected static String[] split(String delimterSeparatedList) {
        if (delimterSeparatedList.indexOf(COMMA) != -1) {
            return AbstractParameters.split(delimterSeparatedList, COMMA);
        }
        return AbstractParameters.split(delimterSeparatedList.trim(), SPACE);
    }

    public static String[] split(String delimterSeparatedList, String delimeter) {
        ArrayList<String> strList = new ArrayList<String>();
        int delimeterPos = -1;
        do {
            int prevDelimeterPos;
            String tmpAddress;
            if ((tmpAddress = delimterSeparatedList.substring(prevDelimeterPos + 1, (delimeterPos = delimterSeparatedList.indexOf(delimeter, (prevDelimeterPos = delimeterPos) + 1)) == -1 ? delimterSeparatedList.length() : delimeterPos).trim()).length() <= 0) continue;
            strList.add(tmpAddress);
        } while (delimeterPos != -1);
        return strList.toArray(new String[strList.size()]);
    }
}

