/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.parameters;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.AbstractParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.FileParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.IpParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.NodeParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.SecurityParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.StateMachineParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.UpgradeParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.VlanIds;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class AutoIntParameters
extends DefaultHandler {
    private static final Class THIS_CLASS = AutoIntParameters.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String XML_TOP_TAG = "StartAutoIntegration";
    private static final String XML_SECONDARY_TAG = "TemporaryIpsecTunnel";
    private static final String VALUE_ATTR = " value=\"";
    private static final String OPENING_XML_START_TAG = "<";
    private static final String OPENING_XML_END_TAG = "</";
    private static final String CLOSING_XML_START_TAG = "/>";
    private static final String CLOSING_XML_END_TAG = ">";
    private static final String VALUE_ATTRIBUTE_NAME = "value";
    private static final Object INSTANCE_MUTEX = new Object();
    private static AutoIntParameters instance;
    private final RbsConfigurationMao rbsConfigurationMao;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized AutoIntParameters instance(RbsConfigurationMao rbsConfigurationMao) {
        logger.traceEnter(THIS_CLASS, "instance()");
        Object object = INSTANCE_MUTEX;
        synchronized (object) {
            if (instance == null) {
                instance = new AutoIntParameters(rbsConfigurationMao);
            }
        }
        logger.traceReturn(THIS_CLASS, "instance()");
        return instance;
    }

    public static AutoIntParameters instance() {
        return instance;
    }

    private AutoIntParameters(RbsConfigurationMao rbsConfigurationMaoIn) {
        this.rbsConfigurationMao = rbsConfigurationMaoIn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        Object object = INSTANCE_MUTEX;
        synchronized (object) {
            this.getStateMachineParameters().delete();
            this.getNodeParameters().delete();
            this.getVlanIds().delete();
            this.getIpParameters().delete();
            this.getFileParameters().delete();
            this.getIpParameters().getOuterIpConfigurationData().delete();
            this.getIpParameters().getInnerIpConfigurationData().delete();
            this.getFileParameters().delete();
            this.getUpgradeParameters().delete();
            this.getSecurityParameters().delete();
            instance = null;
        }
    }

    public StateMachineParameters getStateMachineParameters() {
        return StateMachineParameters.instance(this.rbsConfigurationMao);
    }

    public NodeParameters getNodeParameters() {
        return NodeParameters.instance(this.rbsConfigurationMao);
    }

    public VlanIds getVlanIds() {
        return VlanIds.instance(this.rbsConfigurationMao);
    }

    public IpParameters getIpParameters() {
        return IpParameters.instance(this.rbsConfigurationMao);
    }

    public FileParameters getFileParameters() {
        return FileParameters.instance(this.rbsConfigurationMao);
    }

    public UpgradeParameters getUpgradeParameters() {
        return UpgradeParameters.instance(this.rbsConfigurationMao);
    }

    public SecurityParameters getSecurityParameters() {
        return SecurityParameters.instance(this.rbsConfigurationMao);
    }

    public String toString() {
        String[] ts = new String[]{this.getStateMachineParameters().toString(), this.getNodeParameters().toString(), this.getVlanIds().toString(), this.getIpParameters().toString(), this.getIpParameters().getOuterIpConfigurationData().toString(), this.getIpParameters().getInnerIpConfigurationData().toString(), this.getFileParameters().toString(), this.getUpgradeParameters().toString(), this.getSecurityParameters().toString()};
        StringBuffer result2 = new StringBuffer();
        for (int t = 0; t < ts.length; ++t) {
            if (ts[t].length() <= 0) continue;
            result2.append((result2.length() > 0 ? ", " : "") + ts[t]);
        }
        return result2.toString();
    }

    public void parse(String xmlString) throws IOException {
        logger.traceEnter(THIS_CLASS, "parse(xmlString)");
        try {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            ByteArrayInputStream bais = new ByteArrayInputStream(xmlString.getBytes());
            InputSource input = new InputSource(bais);
            saxParser.parse(input, (DefaultHandler)this);
        }
        catch (SAXParseException e) {
            throw new IOException("Exception in Line:" + e.getLineNumber() + " & column:" + e.getColumnNumber());
        }
        catch (SAXException e) {
            throw new IOException(e.toString());
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.toString());
        }
        logger.traceReturn(THIS_CLASS, "parse(xmlString)");
    }

    public void startDocument() throws SAXException {
        this.delete();
    }

    public void startElement(String namespaceUri, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        logger.traceEnter(this.getClass(), "startElement(" + qualifiedName + ")");
        String valueStr = attributes.getValue(VALUE_ATTRIBUTE_NAME);
        if (!(this.getNodeParameters().setParameter(qualifiedName, valueStr) || this.getVlanIds().setParameter(qualifiedName, valueStr) || this.getIpParameters().setParameter(qualifiedName, valueStr) || this.getIpParameters().getOuterIpConfigurationData().setParameter(qualifiedName, valueStr) || this.getIpParameters().getInnerIpConfigurationData().setParameter(qualifiedName, valueStr) || this.getFileParameters().setParameter(qualifiedName, valueStr) || this.getFileParameters().getWebServerAddressesInstance().setParameter(qualifiedName, valueStr) || this.getUpgradeParameters().setParameter(qualifiedName, valueStr) || this.getSecurityParameters().setParameter(qualifiedName, valueStr))) {
            logger.traceAbnormal(THIS_CLASS, "Unknown element in XML:" + qualifiedName + " value:" + valueStr);
        }
        logger.traceReturn(this.getClass(), "startElement(" + qualifiedName + ")");
    }

    public String getAsXml() {
        StringBuffer xmlBuf = new StringBuffer();
        if (!this.getIpParameters().existsAndNotEmptyTempIpsecTunnelParameters()) {
            xmlBuf.append(OPENING_XML_START_TAG);
            xmlBuf.append(XML_TOP_TAG);
            xmlBuf.append(CLOSING_XML_END_TAG);
            xmlBuf.append("\n");
            xmlBuf.append(this.getXmlTag("VlanId", Integer.toString(this.getIpParameters().getVlanId())));
            xmlBuf.append(this.getXmlTag("DhcpClientIdentifier", this.getNodeParameters().getDhcpClientIdentifier()));
            xmlBuf.append(this.getXmlTag("SmrsUserId", this.getFileParameters().getSmrsUserName()));
            if (this.getFileParameters().getSmrsPassword().length() > 0) {
                xmlBuf.append(this.getXmlTag("SmrsPassword", "[HIDDEN]"));
            }
            xmlBuf.append(this.getXmlTag("SmrsAddress", this.getFileParameters().getSmrsAddress()));
            xmlBuf.append(this.getXmlTag("SmrsSummaryFilePath", this.getFileParameters().getSmrsSummaryFilePath()));
            xmlBuf.append(this.getXmlTag("DnsServerAddress", this.getIpParameters().getDnsServerAddress()));
            xmlBuf.append(this.getXmlTag("DefDomainName", this.getIpParameters().getDefaultDomainName()));
            xmlBuf.append(this.getXmlTag("OamHostIpAddress", this.getIpParameters().getIpAddress()));
            xmlBuf.append(this.getXmlTag("OamSubnetmask", this.getIpParameters().getSubnetMask()));
            xmlBuf.append(this.getXmlTag("OamNetworkPrefixLength", this.getIpParameters().getNetworkPrefixLength()));
            xmlBuf.append(this.getXmlTag("DefaultRouter0", this.getIpParameters().getDefaultRouter()));
            xmlBuf.append(this.getXmlTag("SiteBasicFilePath", this.getFileParameters().getSiteBasicFilePath()));
            xmlBuf.append(this.getXmlTag("SiteEquipmentFilePath", this.getFileParameters().getSiteEquipmentFilePath()));
            xmlBuf.append(this.getXmlTag("LicenseKeyFilePath", this.getFileParameters().getLicenseKeyFilePath()));
            xmlBuf.append(this.getXmlTag("UpgradePackageFilePath", this.getUpgradeParameters().getUpgradePackageFilePath()));
            xmlBuf.append(this.getXmlTag("RbsIntegrationCode", this.getSecurityParameters().getIntegrationCode()));
            xmlBuf.append(this.getXmlTag("ActivateSecurity", this.getSecurityParameters().getActivateSecurity()));
            xmlBuf.append(this.getXmlTag("ActivateIpSecurity", this.getSecurityParameters().getActivateIpSecurity()));
            xmlBuf.append(this.getXmlTag("LogicalName", this.getNodeParameters().getLogicalName()));
            xmlBuf.append(this.getXmlTag("UniqueLogicalName", this.getNodeParameters().getUniqueLogicalName()));
            xmlBuf.append(this.getXmlTag("ClientUtcTime", this.getNodeParameters().getClientUtcTime()));
            xmlBuf.append(OPENING_XML_END_TAG);
            xmlBuf.append(XML_TOP_TAG);
            xmlBuf.append(CLOSING_XML_END_TAG);
        } else {
            xmlBuf.append(OPENING_XML_START_TAG);
            xmlBuf.append(XML_TOP_TAG);
            xmlBuf.append(CLOSING_XML_END_TAG);
            xmlBuf.append("\n");
            xmlBuf.append(this.getXmlTag("VlanId", Integer.toString(this.getIpParameters().getVlanId())));
            xmlBuf.append(this.getXmlTag("DhcpClientIdentifier", this.getNodeParameters().getDhcpClientIdentifier()));
            xmlBuf.append(this.getXmlTag("SmrsUserId", this.getFileParameters().getSmrsUserName()));
            if (this.getFileParameters().getSmrsPassword().length() > 0) {
                xmlBuf.append(this.getXmlTag("SmrsPassword", "[HIDDEN]"));
            }
            xmlBuf.append(this.getXmlTag("SmrsAddress", this.getFileParameters().getSmrsAddress()));
            xmlBuf.append(this.getXmlTag("SmrsSummaryFilePath", this.getFileParameters().getSmrsSummaryFilePath()));
            xmlBuf.append(this.getXmlTag("DnsServerAddress", this.getIpParameters().getDnsServerAddress()));
            xmlBuf.append(this.getXmlTag("DefDomainName", this.getIpParameters().getDefaultDomainName()));
            xmlBuf.append(this.getXmlTag("OamHostIpAddress", this.getIpParameters().getIpAddress()));
            xmlBuf.append(this.getXmlTag("OamSubnetmask", this.getIpParameters().getSubnetMask()));
            xmlBuf.append(this.getXmlTag("OamNetworkPrefixLength", this.getIpParameters().getNetworkPrefixLength()));
            xmlBuf.append(this.getXmlTag("DefaultRouter0", this.getIpParameters().getDefaultRouter()));
            xmlBuf.append(OPENING_XML_START_TAG);
            xmlBuf.append(XML_SECONDARY_TAG);
            xmlBuf.append(CLOSING_XML_END_TAG);
            xmlBuf.append("\n");
            xmlBuf.append(this.getXmlTag("outerDnsServer", this.getIpParameters().getOuterIpConfigurationData().getOuterDnsServer()));
            xmlBuf.append(this.getXmlTag("SecGwIpAdd", this.getIpParameters().getOuterIpConfigurationData().getInitialSecGwIpAdd()));
            xmlBuf.append(this.getXmlTag("SecGwFqdn", this.getIpParameters().getOuterIpConfigurationData().getInitialSecGwFqdn()));
            xmlBuf.append(this.getXmlTag("outerIpAddress", this.getIpParameters().getOuterIpConfigurationData().getOuterIpAddress()));
            xmlBuf.append(this.getXmlTag("outerSubnetMask", this.getIpParameters().getOuterIpConfigurationData().getOuterSubnetMask()));
            xmlBuf.append(this.getXmlTag("outerDefaultRouter0", this.getIpParameters().getOuterIpConfigurationData().getOuterDefaultRouterZero()));
            xmlBuf.append(this.getXmlTag("InnerDnsServer", this.getIpParameters().getInnerIpConfigurationData().getInnerDnsServer()));
            xmlBuf.append(this.getXmlTag("ipAddress", this.getIpParameters().getInnerIpConfigurationData().getInnerIpAddress()));
            xmlBuf.append(OPENING_XML_END_TAG);
            xmlBuf.append(XML_SECONDARY_TAG);
            xmlBuf.append(CLOSING_XML_END_TAG);
            xmlBuf.append("\n");
            xmlBuf.append(this.getXmlTag("SiteBasicFilePath", this.getFileParameters().getSiteBasicFilePath()));
            xmlBuf.append(this.getXmlTag("SiteEquipmentFilePath", this.getFileParameters().getSiteEquipmentFilePath()));
            xmlBuf.append(this.getXmlTag("LicenseKeyFilePath", this.getFileParameters().getLicenseKeyFilePath()));
            xmlBuf.append(this.getXmlTag("UpgradePackageFilePath", this.getUpgradeParameters().getUpgradePackageFilePath()));
            xmlBuf.append(this.getXmlTag("RbsIntegrationCode", this.getSecurityParameters().getIntegrationCode()));
            xmlBuf.append(this.getXmlTag("ActivateSecurity", this.getSecurityParameters().getActivateSecurity()));
            xmlBuf.append(this.getXmlTag("ActivateIpSecurity", this.getSecurityParameters().getActivateIpSecurity()));
            xmlBuf.append(this.getXmlTag("LogicalName", this.getNodeParameters().getLogicalName()));
            xmlBuf.append(this.getXmlTag("UniqueLogicalName", this.getNodeParameters().getUniqueLogicalName()));
            xmlBuf.append(this.getXmlTag("ClientUtcTime", this.getNodeParameters().getClientUtcTime()));
            xmlBuf.append(OPENING_XML_END_TAG);
            xmlBuf.append(XML_TOP_TAG);
            xmlBuf.append(CLOSING_XML_END_TAG);
        }
        return xmlBuf.toString();
    }

    private String getXmlTag(String tagName, String tagValue) {
        StringBuffer xmlTag = new StringBuffer();
        if (tagValue.length() > 0) {
            xmlTag.append(AbstractParameters.getIndentation(1)).append(OPENING_XML_START_TAG).append(tagName).append(VALUE_ATTR).append(tagValue).append("\"").append(CLOSING_XML_START_TAG).append("\n");
        }
        return xmlTag.toString();
    }
}

