/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.parameters;

import org.xml.sax.Attributes;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.common.StringHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.AbstractParameters;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class CabinetParameters
extends AbstractParameters {
    private static final Class THIS_CLASS = CabinetParameters.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    protected static final String CABINET = "Cabinet";
    protected static final String CABINET_PRODUCTION_DATE = "productionDate";
    protected static final String CABINET_PRODUCT_NAME = "productName";
    protected static final String CABINET_PRODUCT_NUMBER = "productNumber";
    protected static final String CABINET_PRODUCT_REVISION = "productRevision";
    protected static final String CABINET_SERIAL_NUMBER = "serialNumber";
    private static final String[] parameters = new String[]{"productionDate", "productName", "productNumber", "productRevision", "serialNumber"};
    private static final String OPENING_XML_START_TAG = "<";
    private static final String CLOSING_XML_START_TAG = "/>";
    private static final Object INSTANCE_MUTEX = new Object();
    private static CabinetParameters instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized CabinetParameters instance(RbsConfigurationMao rbsConfigurationMao) {
        logger.traceEnter(THIS_CLASS, "instance()");
        Object object = INSTANCE_MUTEX;
        synchronized (object) {
            if (instance == null) {
                instance = new CabinetParameters(rbsConfigurationMao);
            }
        }
        logger.traceReturn(THIS_CLASS, "instance()");
        return instance;
    }

    public static CabinetParameters instance() {
        return instance;
    }

    public void delete() {
        this.delete(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Coordinator coordinator) {
        Object object = INSTANCE_MUTEX;
        synchronized (object) {
            super.delete(coordinator);
            instance = null;
        }
    }

    private CabinetParameters(RbsConfigurationMao rbsConfigurationMaoIn) {
        super(rbsConfigurationMaoIn, parameters);
    }

    public String getCabinetProductionDate() {
        return this.getParameter(CABINET_PRODUCTION_DATE);
    }

    public void setCabinetProductionDate(String cabinetProductionDate) {
        this.setParameter(CABINET_PRODUCTION_DATE, cabinetProductionDate);
    }

    public String getCabinetProductName() {
        return this.getParameter(CABINET_PRODUCT_NAME);
    }

    public void setCabinetProductName(String cabinetProductName) {
        this.setParameter(CABINET_PRODUCT_NAME, cabinetProductName);
    }

    public String getCabinetProductNumber() {
        return this.getParameter(CABINET_PRODUCT_NUMBER);
    }

    public void setCabinetProductNumber(String cabinetProductNumber) {
        this.setParameter(CABINET_PRODUCT_NUMBER, cabinetProductNumber);
    }

    public String getCabinetProductRevision() {
        return this.getParameter(CABINET_PRODUCT_REVISION);
    }

    public void setCabinetProductRevision(String cabinetProductRevision) {
        this.setParameter(CABINET_PRODUCT_REVISION, cabinetProductRevision);
    }

    public String getCabinetSerialNumber() {
        return this.getParameter(CABINET_SERIAL_NUMBER);
    }

    public void setCabinetSerialNumber(String cabinetSerialNumber) {
        this.setParameter(CABINET_SERIAL_NUMBER, cabinetSerialNumber);
    }

    protected boolean setCabinetParameters(String qualifiedName, Attributes attributes) {
        boolean result2 = false;
        if (CABINET.equalsIgnoreCase(qualifiedName)) {
            this.setCabinetProductionDate(attributes.getValue(CABINET_PRODUCTION_DATE));
            this.setCabinetProductName(attributes.getValue(CABINET_PRODUCT_NAME));
            this.setCabinetProductNumber(attributes.getValue(CABINET_PRODUCT_NUMBER));
            this.setCabinetProductRevision(attributes.getValue(CABINET_PRODUCT_REVISION));
            this.setCabinetSerialNumber(attributes.getValue(CABINET_SERIAL_NUMBER));
            result2 = true;
        }
        return result2;
    }

    protected String getCabinetXmlTag() {
        StringBuffer xmlTag = new StringBuffer();
        xmlTag.append(CabinetParameters.getIndentation(1)).append(OPENING_XML_START_TAG).append(CABINET).append(" ").append(CABINET_PRODUCTION_DATE).append("=").append(StringHelper.doubleQuote((String)this.getCabinetProductionDate())).append(" ").append(CABINET_PRODUCT_NAME).append("=").append(StringHelper.doubleQuote((String)this.getCabinetProductName())).append(" ").append(CABINET_PRODUCT_NUMBER).append("=").append(StringHelper.doubleQuote((String)this.getCabinetProductNumber())).append(" ").append(CABINET_PRODUCT_REVISION).append("=").append(StringHelper.doubleQuote((String)this.getCabinetProductRevision())).append(" ").append(CABINET_SERIAL_NUMBER).append("=").append(StringHelper.doubleQuote((String)this.getCabinetSerialNumber())).append(CLOSING_XML_START_TAG).append("\n");
        return xmlTag.toString();
    }
}

