/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.parameters;

import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.AbstractParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.WebServerAddresses;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class FileParameters
extends AbstractParameters {
    private static final Class THIS_CLASS = FileParameters.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    protected static final String SMRS_ADDRESS = "SmrsAddress";
    static final String SMRS_USER = "SmrsUserId";
    static final String SMRS_PASSWORD = "SmrsPassword";
    protected static final String SFTP_ADDRESS = "SftpAddress";
    protected static final String SFTP_USER = "SftpUserId";
    protected static final String SFTP_PASSWORD = "SftpPassword";
    protected static final String SFTP_SUMMARY_FILE_PATH = "SftpSummaryFilePath";
    protected static final String SMRS_SUMMARY_FILE_PATH = "SmrsSummaryFilePath";
    protected static final String INTEGRATION_BASIC_PACKAGE_FILE_PATH = "IntegrationBasicPackageFilePath";
    protected static final String REMOTE_INTEGRATION_BASIC_PACKAGE_PATH = "RemoteIntegrationBasicPackagePath";
    protected static final String INTEGRATION_BASIC_PACKAGE_FILE_EXTRACT_PATH = "IntegrationBasicPackageFileExtractPath";
    protected static final String CABINET_EQUIPMENT_FILE_PATH = "CabinetEquipmentFilePath";
    protected static final String REMOTE_CABINET_EQUIPMENT_FILE_PATH = "RemoteCabinetEquipmentFilePath";
    protected static final String OAM_ACCESS_FILE_PATH = "OamAccessFilePath";
    protected static final String REMOTE_OAM_ACCESS_FILE_PATH = "RemoteOamAccessFilePath";
    protected static final String ANTENNA_SYSTEM_FILE_PATH = "AntennaSystemFilePath";
    protected static final String REMOTE_ANTENNA_SYSTEM_FILE_PATH = "RemoteAntennaSystemFilePath";
    protected static final String SITE_BASIC_FILE_PATH = "SiteBasicFilePath";
    public static final String REMOTE_SITE_BASIC_PATH = "RemoteSiteBasicPath";
    public static final String SITE_INSTALLATION_FILE_PATH = "SiteInstallationFilePath";
    protected static final String LOCAL_SITE_BASIC_FILE_PATH = "localSiteBasicFilePath";
    public static final String LOWER_CASE_REMOTE_SITE_BASIC_PATH = "remoteSiteBasicPath";
    protected static final String SITE_EQUIPMENT_FILE_PATH = "SiteEquipmentFilePath";
    protected static final String REMOTE_SITE_EQUIP_PATH = "RemoteSiteEquipPath";
    protected static final String LOCAL_SITE_EQUIPMENT_FILE_PATH = "localSiteEquipmentFilePath";
    protected static final String LOWER_CASE_REMOTE_SITE_EQUIP_PATH = "remoteSiteEquipPath";
    protected static final String LICENSE_KEY_FILE_PATH = "LicenseKeyFilePath";
    protected static final String LICENSE_KEY_REMOTE_PATH = "LicenseKeyRemotePath";
    protected static final String LOCAL_LICENSE_KEY_FILE_PATH = "localLkfPath";
    protected static final String REMOTE_LICENSE_KEY_FILE_PATH = "remoteLkfPath";
    protected static final String LEGACY_SMRS_ADDRESS = "smrsAddress";
    protected static final String LEGACY_SMRS_SUMMARY_PATH = "smrsSummryPath";
    public static final String NODE_SELF_CONFIGURATION_MODE = "nodeSelfConfigurationMode";
    private static final String[] parameters = new String[]{"SmrsAddress", "SmrsSummaryFilePath", "SiteBasicFilePath", "RemoteSiteBasicPath", "SiteInstallationFilePath", "SiteEquipmentFilePath", "RemoteSiteEquipPath", "LicenseKeyFilePath", "LicenseKeyRemotePath", "SftpUserId", "SftpPassword", "SftpAddress", "SftpSummaryFilePath", "IntegrationBasicPackageFilePath", "IntegrationBasicPackageFileExtractPath", "CabinetEquipmentFilePath", "OamAccessFilePath", "AntennaSystemFilePath", "nodeSelfConfigurationMode"};
    private static final Object INSTANCE_MUTEX = new Object();
    private static FileParameters instance;
    private final WebServerAddresses webServerAddresses;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized FileParameters instance(RbsConfigurationMao rbsConfigurationMao) {
        logger.traceEnter(THIS_CLASS, "instance()");
        Object object = INSTANCE_MUTEX;
        synchronized (object) {
            if (instance == null) {
                instance = new FileParameters(rbsConfigurationMao);
            }
        }
        logger.traceReturn(THIS_CLASS, "instance()");
        return instance;
    }

    public static FileParameters instance() {
        return instance;
    }

    private FileParameters(RbsConfigurationMao rbsConfigurationMaoIn) {
        super(rbsConfigurationMaoIn, parameters);
        this.webServerAddresses = WebServerAddresses.instance(rbsConfigurationMaoIn);
    }

    public String correctParameterNames(Coordinator coordinator) {
        String param = this.correctParameterName(SMRS_ADDRESS, new String[]{LEGACY_SMRS_ADDRESS}, coordinator);
        param = "," + param + this.correctParameterName(SMRS_SUMMARY_FILE_PATH, new String[]{LEGACY_SMRS_SUMMARY_PATH}, coordinator);
        param = "," + param + this.correctParameterName(SITE_BASIC_FILE_PATH, new String[]{LOCAL_SITE_BASIC_FILE_PATH}, coordinator);
        param = "," + param + this.correctParameterName(SITE_EQUIPMENT_FILE_PATH, new String[]{LOCAL_SITE_EQUIPMENT_FILE_PATH}, coordinator);
        param = "," + param + this.correctParameterName(LICENSE_KEY_FILE_PATH, new String[]{LOCAL_LICENSE_KEY_FILE_PATH}, coordinator);
        param = "," + param + this.correctParameterName(LICENSE_KEY_REMOTE_PATH, new String[]{REMOTE_LICENSE_KEY_FILE_PATH}, coordinator);
        param = "," + param + this.correctParameterName(REMOTE_SITE_BASIC_PATH, new String[]{LOWER_CASE_REMOTE_SITE_BASIC_PATH}, coordinator);
        param = "," + param + this.correctParameterName(REMOTE_SITE_EQUIP_PATH, new String[]{LOWER_CASE_REMOTE_SITE_EQUIP_PATH}, coordinator);
        return param;
    }

    public void delete() {
        this.delete(null, true);
    }

    public void delete(boolean deleteWebServerAddresses) {
        this.delete(null, deleteWebServerAddresses);
    }

    public void delete(Coordinator coordinator) {
        this.delete(coordinator, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delete(Coordinator coordinator, boolean deleteWebServerAddresses) {
        Object object = INSTANCE_MUTEX;
        synchronized (object) {
            super.delete(coordinator);
            if (deleteWebServerAddresses) {
                this.webServerAddresses.delete();
            }
            try {
                this.getSensitiveDataHelper().removeSmrsUserName(coordinator);
            }
            catch (RbsConfigurationFailedException hopfullyWontHappen) {
                logger.traceError(THIS_CLASS, "Failed to remove smrsUsername=***** persistently");
            }
            try {
                this.getSensitiveDataHelper().removeSmrsPassword(coordinator);
            }
            catch (RbsConfigurationFailedException hopfullyWontHappen) {
                logger.traceError(THIS_CLASS, "Failed to remove smrsPassword=***** persistently");
            }
            instance = null;
        }
    }

    public String toString() {
        String tstr = super.toString();
        return this.webServerAddresses.toString() + (tstr.length() == 0 ? "" : ", " + tstr);
    }

    public WebServerAddresses getWebServerAddressesInstance() {
        return this.webServerAddresses;
    }

    public String getSmrsAddress() {
        return this.getParameter(SMRS_ADDRESS);
    }

    public void setSmrsAddress(String smrsAddress) {
        this.setParameter(SMRS_ADDRESS, smrsAddress);
    }

    public String getSmrsUserName() {
        return this.getSensitiveDataHelper().retrieveSmrsUserName();
    }

    public void setSmrsUserName(String smrsUserName) {
        this.setSmrsUserName(smrsUserName, null);
    }

    public void setSmrsUserName(String smrsUserName, Coordinator coordinator) {
        try {
            this.getSensitiveDataHelper().storeSmrsUserName(smrsUserName, coordinator);
        }
        catch (MoAccessException hopfullyWontHappen) {
            logger.traceError(THIS_CLASS, "Failed to store smrsUsername=" + smrsUserName + " persistently");
        }
    }

    public String getSmrsPassword() {
        return this.getSensitiveDataHelper().retrieveSmrsPassword();
    }

    public void setSmrsPassword(String smrsPassword) {
        this.setSmrsPassword(smrsPassword, null);
    }

    public void setSmrsPassword(String smrsPassword, Coordinator coordinator) {
        try {
            this.getSensitiveDataHelper().storeSmrsPassword(smrsPassword, null);
        }
        catch (MoAccessException hopfullyWontHappen) {
            logger.traceError(THIS_CLASS, "Failed to store smrsPassword=***** persistently");
        }
    }

    public String getSmrsSummaryFilePath() {
        return this.getParameter(SMRS_SUMMARY_FILE_PATH);
    }

    public void setSmrsSummaryFilePath(String smrsSummaryFilePath) {
        this.setParameter(SMRS_SUMMARY_FILE_PATH, smrsSummaryFilePath);
    }

    public String getSiteBasicFilePath() {
        return this.getParameter(SITE_BASIC_FILE_PATH);
    }

    public void setSiteBasicFilePath(String siteBasicFilePath) {
        this.setParameter(SITE_BASIC_FILE_PATH, siteBasicFilePath);
    }

    public String getSiteBasicRemotePath() {
        return this.getParameter(REMOTE_SITE_BASIC_PATH);
    }

    public void setSiteBasicRemotePath(String siteBasicRemotePath) {
        this.setParameter(REMOTE_SITE_BASIC_PATH, siteBasicRemotePath);
    }

    public String getSiteEquipmentFilePath() {
        return this.getParameter(SITE_EQUIPMENT_FILE_PATH);
    }

    public void setSiteEquipmentFilePath(String siteEquipmentFilePath) {
        this.setParameter(SITE_EQUIPMENT_FILE_PATH, siteEquipmentFilePath);
    }

    public String getSiteEquipmentRemotePath() {
        return this.getParameter(REMOTE_SITE_EQUIP_PATH);
    }

    public void setSiteEquipmentRemotePath(String siteEquipmentRemotePath) {
        this.setParameter(REMOTE_SITE_EQUIP_PATH, siteEquipmentRemotePath);
    }

    public String getLicenseKeyFilePath() {
        return this.getParameter(LICENSE_KEY_FILE_PATH);
    }

    public void setLicenseKeyFilePath(String licenseKeyFilePath) {
        this.setParameter(LICENSE_KEY_FILE_PATH, licenseKeyFilePath);
    }

    public String getLicenseKeyRemotePath() {
        return this.getParameter(LICENSE_KEY_REMOTE_PATH);
    }

    public void setLicenseKeyRemotePath(String licenseKeyRemotePath) {
        this.setParameter(LICENSE_KEY_REMOTE_PATH, licenseKeyRemotePath);
    }

    protected boolean setParameter(String paramName, String paramValue, Coordinator coordinator) {
        boolean result2 = false;
        if (paramName.equals(SMRS_USER)) {
            this.setSmrsUserName(paramValue, coordinator);
            result2 = true;
        } else if (paramName.equals(SMRS_PASSWORD)) {
            this.setSmrsPassword(paramValue, coordinator);
            result2 = true;
        } else {
            return super.setParameter(paramName, paramValue, coordinator);
        }
        return result2;
    }

    public String getIntegrationBasicPackageFilePath() {
        return this.getParameter(INTEGRATION_BASIC_PACKAGE_FILE_PATH);
    }

    public void setIntegrationBasicPackageRemotePath(String inRemoteIbpPath) {
        this.setParameter(REMOTE_INTEGRATION_BASIC_PACKAGE_PATH, inRemoteIbpPath);
    }

    public String getIntegrationBasicPackageRemotePath() {
        return this.getParameter(REMOTE_INTEGRATION_BASIC_PACKAGE_PATH);
    }

    public void setIntegrationBasicPackageFilePath(String integrationBasicPackageFilePath) {
        this.setParameter(INTEGRATION_BASIC_PACKAGE_FILE_PATH, integrationBasicPackageFilePath);
    }

    public String getIntegrationBasicPackageFileExtractPath() {
        return this.getParameter(INTEGRATION_BASIC_PACKAGE_FILE_EXTRACT_PATH);
    }

    public void setIntegrationBasicPackageFileExtractPath(String integrationBasicPackageFileExtractPath) {
        this.setParameter(INTEGRATION_BASIC_PACKAGE_FILE_EXTRACT_PATH, integrationBasicPackageFileExtractPath);
    }

    public String getCabinetEquipmentFilePath() {
        return this.getParameter(CABINET_EQUIPMENT_FILE_PATH);
    }

    public String getCabinetEquipmentRemotePath() {
        return this.getParameter(REMOTE_CABINET_EQUIPMENT_FILE_PATH);
    }

    public void setCabinetEquipmentRemotePath(String remoteCabinetEquipFilePath) {
        this.setParameter(REMOTE_CABINET_EQUIPMENT_FILE_PATH, remoteCabinetEquipFilePath);
    }

    public void setCabinetEquipmentFilePath(String cabinetEquipmentFilePath) {
        this.setParameter(CABINET_EQUIPMENT_FILE_PATH, cabinetEquipmentFilePath);
    }

    public String getOamAccessFilePath() {
        return this.getParameter(OAM_ACCESS_FILE_PATH);
    }

    public String getOamAccessRemotePath() {
        return this.getParameter(REMOTE_OAM_ACCESS_FILE_PATH);
    }

    public void setOamAccessRemotePath(String remoteOamAccessFilePath) {
        this.setParameter(REMOTE_OAM_ACCESS_FILE_PATH, remoteOamAccessFilePath);
    }

    public void setOamAccessFilePath(String oamAccessFilePath) {
        this.setParameter(OAM_ACCESS_FILE_PATH, oamAccessFilePath);
    }

    public String getAntennaSystemFilePath() {
        return this.getParameter(ANTENNA_SYSTEM_FILE_PATH);
    }

    public void setAntennaSystemFilePath(String antennaSystemFilePath) {
        this.setParameter(ANTENNA_SYSTEM_FILE_PATH, antennaSystemFilePath);
    }

    public String getAntennaSystemRemotePath() {
        return this.getParameter(REMOTE_ANTENNA_SYSTEM_FILE_PATH);
    }

    public void setAntennaSystemRemotePath(String remoteAntennaSystemFilePath) {
        this.setParameter(REMOTE_ANTENNA_SYSTEM_FILE_PATH, remoteAntennaSystemFilePath);
    }

    public String getSftpUser() {
        return this.getParameter(SFTP_USER);
    }

    public void setSftpUser(String sftpUsername) {
        this.setParameter(SFTP_USER, sftpUsername);
    }

    public String getSftpPassword() {
        return this.getParameter(SFTP_PASSWORD);
    }

    public void setSftpPassword(String sftpPassword) {
        this.setParameter(SFTP_PASSWORD, sftpPassword);
    }

    public String getSftpAddress() {
        return this.getParameter(SFTP_ADDRESS);
    }

    public void setSftpAddress(String sftpAddress) {
        this.setParameter(SFTP_ADDRESS, sftpAddress);
    }

    public String getSftpSummaryFilePath() {
        return this.getParameter(SFTP_SUMMARY_FILE_PATH);
    }

    public void setSftpSummaryFilePath(String sftpSummaryFilePath) {
        this.setParameter(SFTP_SUMMARY_FILE_PATH, sftpSummaryFilePath);
    }

    public String getNodeSelfConfigurationMode() {
        return this.getParameter(NODE_SELF_CONFIGURATION_MODE);
    }

    public void setNodeSelfConfigurationMode(String nodeSelfConfigurationMode) {
        this.setParameter(NODE_SELF_CONFIGURATION_MODE, nodeSelfConfigurationMode);
    }

    public String getSiteInstallationFilePath() {
        return this.getParameter(SITE_INSTALLATION_FILE_PATH);
    }

    public void setSiteInstallationFilePath(String siteInstallationFilePath) {
        this.setParameter(SITE_INSTALLATION_FILE_PATH, siteInstallationFilePath);
    }
}

