/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.parameters;

import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.AbstractParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.InnerIpConfigurationData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.OuterIpConfigurationData;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class IpParameters
extends AbstractParameters {
    private static final Class THIS_CLASS = IpParameters.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    protected static final String LEGACY_OAM_HOST_IP_ADDRESS = "oamHostIpAddress";
    public static final String DEF_DOMAIN_NAME = "defDomainName";
    public static final String LOWER_CASE_DNS_SERVER_ADDRESS = "dnsServerAddress";
    public static final String LOWER_CASE_OAM_SUBNET_MASK = "oamSubnetMask";
    public static final String LOWER_CASE_OAM_NETWORK_PREFIX_LENGTH = "oamNetworkPrefixLength";
    protected static final String OAM_HOST_IP_ADDRESS = "OamHostIpAddress";
    protected static final String OAM_SUBNET_MASK = "OamSubnetmask";
    protected static final String OAM_NETWORK_PREFIX_LENGTH = "OamNetworkPrefixLength";
    protected static final String VLAN_ID = "VlanId";
    protected static final String DEFAULT_ROUTER = "DefaultRouter0";
    protected static final String DNS_SERVER_ADDRESS = "DnsServerAddress";
    protected static final String DEFAULT_DOMAIN_NAME = "DefDomainName";
    protected static final String DOMAIN_NAME = "DomainName";
    protected static final String NTP_SERVER_ADDRESS = "NtpServerAddress";
    protected static final String IP_HOST_LINK_RDN_VALUE = "ipHostLinkRdnValue";
    protected static final String CORBA_ON_SITE_LAN = "CorbaOnSiteLan";
    protected static final String TEMP_IPSEC_TUNNEL_ENABLED = "TempIpsecTunnelEnabled";
    static final String IP_INTERFACE_MANUAL = "MANUAL";
    static final String IP_INTERFACE_DHCP = "DHCP";
    private static final String[] parameters = new String[]{"OamHostIpAddress", "OamSubnetmask", "OamNetworkPrefixLength", "VlanId", "DefaultRouter0", "DnsServerAddress", "NtpServerAddress", "ipHostLinkRdnValue", "DefDomainName", "DomainName", "CorbaOnSiteLan"};
    private static final Object INSTANCE_MUTEX = new Object();
    private static IpParameters instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized IpParameters instance(RbsConfigurationMao rbsConfigurationMao) {
        logger.traceEnter(THIS_CLASS, "instance()");
        Object object = INSTANCE_MUTEX;
        synchronized (object) {
            if (instance == null) {
                instance = new IpParameters(rbsConfigurationMao);
            }
        }
        logger.traceReturn(THIS_CLASS, "instance()");
        return instance;
    }

    public static IpParameters instance() {
        return instance;
    }

    private IpParameters(RbsConfigurationMao rbsConfigurationMaoIn) {
        super(rbsConfigurationMaoIn, parameters);
    }

    public void delete() {
        this.delete(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Coordinator coordinator) {
        Object object = INSTANCE_MUTEX;
        synchronized (object) {
            super.delete(coordinator);
            instance = null;
        }
    }

    public String correctParameterNames(Coordinator coordinator) {
        String params = this.correctParameterName(OAM_HOST_IP_ADDRESS, new String[]{LEGACY_OAM_HOST_IP_ADDRESS}, coordinator);
        params = params + "," + this.correctParameterName(OAM_SUBNET_MASK, new String[]{LOWER_CASE_OAM_SUBNET_MASK}, coordinator);
        params = params + "," + this.correctParameterName(OAM_NETWORK_PREFIX_LENGTH, new String[]{LOWER_CASE_OAM_NETWORK_PREFIX_LENGTH}, coordinator);
        params = params + "," + this.correctParameterName(DNS_SERVER_ADDRESS, new String[]{LOWER_CASE_DNS_SERVER_ADDRESS}, coordinator);
        params = params + "," + this.correctParameterName(DEFAULT_DOMAIN_NAME, new String[]{DEF_DOMAIN_NAME}, coordinator);
        return params;
    }

    public String getIpAddress() {
        return this.getParameter(OAM_HOST_IP_ADDRESS);
    }

    public void setIpAddress(String ipAddress) {
        this.setParameter(OAM_HOST_IP_ADDRESS, ipAddress);
    }

    public String getSubnetMask() {
        return this.getParameter(OAM_SUBNET_MASK);
    }

    public void setSubnetMask(String subnetMask) {
        this.setParameter(OAM_SUBNET_MASK, subnetMask);
    }

    public String getNetworkPrefixLength() {
        return this.getParameter(OAM_NETWORK_PREFIX_LENGTH);
    }

    public void setNetworkPrefixLength(String networkPrefixLength) {
        this.setParameter(OAM_NETWORK_PREFIX_LENGTH, networkPrefixLength);
    }

    public int getVlanId() {
        String vlanIdStr = this.getParameter(VLAN_ID);
        return "".equals(vlanIdStr) ? -2 : Integer.parseInt(vlanIdStr);
    }

    public void setVlanId(int vlanId) {
        this.setParameter(VLAN_ID, Integer.toString(vlanId));
    }

    public String getDefaultRouter() {
        return this.getParameter(DEFAULT_ROUTER);
    }

    public void setDefaultRouter(String defaultRouter) {
        this.setParameter(DEFAULT_ROUTER, defaultRouter);
    }

    public String getDnsServerAddress() {
        return this.getParameter(DNS_SERVER_ADDRESS);
    }

    public String getNtpServerAddress() {
        return this.getParameter(NTP_SERVER_ADDRESS);
    }

    public void setNtpServerAddress(String ntpServerAddress) {
        this.setParameter(NTP_SERVER_ADDRESS, ntpServerAddress);
    }

    public void setDnsServerAddress(String dnsServerAddress) {
        this.setParameter(DNS_SERVER_ADDRESS, dnsServerAddress);
    }

    public String getIpHostLinkRdnValue() {
        return this.getParameter(IP_HOST_LINK_RDN_VALUE);
    }

    public void setIpHostLinkRdnValue(String ipHostLinkRdnValue) {
        this.setParameter(IP_HOST_LINK_RDN_VALUE, ipHostLinkRdnValue);
    }

    public String getDefaultDomainName() {
        return this.getParameter(DEFAULT_DOMAIN_NAME);
    }

    public void setDefaultDomainName(String defDomainName) {
        this.setParameter(DEFAULT_DOMAIN_NAME, defDomainName);
    }

    public boolean isDefaultDomainNameEmpty() {
        return IpParameters.isEmpty(this.getParameter(DEFAULT_DOMAIN_NAME));
    }

    public boolean isSecGwFqdnEmpty() {
        return IpParameters.isEmpty(this.getOuterIpConfigurationData().getInitialSecGwFqdn());
    }

    public boolean isSecGwIpAddEmpty() {
        return IpParameters.isEmpty(this.getOuterIpConfigurationData().getInitialSecGwIpAdd());
    }

    public String getDomainName() {
        return this.getParameter(DOMAIN_NAME);
    }

    public void setDomainName(String domainName) {
        this.setParameter(DOMAIN_NAME, domainName);
    }

    public boolean isDomainNameEmpty() {
        return IpParameters.isEmpty(this.getParameter(DOMAIN_NAME));
    }

    public boolean getCorbaOnSiteLan() {
        return Boolean.valueOf(this.getParameter(CORBA_ON_SITE_LAN));
    }

    public void setCorbaOnSiteLan(String corbaOnSiteLan) {
        this.setParameter(CORBA_ON_SITE_LAN, corbaOnSiteLan);
    }

    public OuterIpConfigurationData getOuterIpConfigurationData() {
        return OuterIpConfigurationData.instance(this.rbsConfigurationMao);
    }

    public InnerIpConfigurationData getInnerIpConfigurationData() {
        return InnerIpConfigurationData.instance(this.rbsConfigurationMao);
    }

    public boolean existsAndNotEmptyTempIpsecTunnelParameters() {
        boolean result2 = false;
        if (RbsConfigurationHelper.existsAndNotEmpty(this.getOuterIpConfigurationData().getInitialSecGwIpAdd()) || RbsConfigurationHelper.existsAndNotEmpty(this.getOuterIpConfigurationData().getInitialSecGwFqdn())) {
            result2 = true;
        }
        return result2;
    }

    public String getConfigurationModeIpInterface() {
        String configurationMode = IP_INTERFACE_MANUAL;
        configurationMode = RbsConfigurationHelper.existsAndNotEmpty(this.getOuterIpConfigurationData().getOuterIpAddress()) && RbsConfigurationHelper.existsAndNotEmpty(this.getOuterIpConfigurationData().getOuterSubnetMask()) && RbsConfigurationHelper.existsAndNotEmpty(this.getOuterIpConfigurationData().getOuterDefaultRouterZero()) ? IP_INTERFACE_MANUAL : IP_INTERFACE_DHCP;
        return configurationMode;
    }

    public Integer getConfigurationModeVpnInterface() {
        Integer configurationMode = RbsConfigurationDefinitions.VPN_INTERFACE_CONF_MODE_IKE;
        if (RbsConfigurationHelper.existsAndNotEmpty(this.getInnerIpConfigurationData().getInnerIpAddress())) {
            configurationMode = RbsConfigurationDefinitions.VPN_INTERFACE_CONF_MODE_MANUAL;
        }
        return configurationMode;
    }

    public Integer getIpVersionVpnInterface() {
        Integer ipVersion = RbsConfigurationDefinitions.VPN_INTERFACE_IP_VERSION_V6;
        String innerAddress = this.getInnerIpConfigurationData().getInnerIpAddress();
        if (RbsConfigurationHelper.existsAndNotEmpty(innerAddress) && innerAddress.indexOf(":") == -1) {
            ipVersion = RbsConfigurationDefinitions.VPN_INTERFACE_IP_VERSION_V4;
        }
        return ipVersion;
    }
}

