/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.parameters;

import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.FqdnIpAddressPair;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.AbstractParameters;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class SecGwAddresses
extends AbstractParameters {
    private static final Class THIS_CLASS = SecGwAddresses.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    protected static final String SEC_GW_ADDRESSES = "SecGwAddresses";
    private static final Object INSTANCE_MUTEX = new Object();
    private static SecGwAddresses instance;
    private final Object MUTEX = new Object();
    private FqdnIpAddressPair[] secGwAddresses;
    private int nextSecGwAddress = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized SecGwAddresses instance(RbsConfigurationMao rbsConfigurationMao) {
        logger.traceEnter(THIS_CLASS, "instance()");
        Object object = INSTANCE_MUTEX;
        synchronized (object) {
            if (instance == null) {
                instance = new SecGwAddresses(rbsConfigurationMao);
            }
        }
        logger.traceReturn(THIS_CLASS, "instance()");
        return instance;
    }

    public static SecGwAddresses instance() {
        return instance;
    }

    private SecGwAddresses(RbsConfigurationMao rbsConfigurationMaoArg) {
        super(rbsConfigurationMaoArg, new String[0]);
        this.retrievePersistently();
    }

    public void delete() {
        this.delete(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Coordinator coordinator) {
        Object object = INSTANCE_MUTEX;
        synchronized (object) {
            super.delete(coordinator);
            this.setSecGwAddresses(new FqdnIpAddressPair[0]);
            instance = null;
        }
    }

    public String toString() {
        return "SecGwAddresses=" + this.toStringInt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSecGwAddresses(FqdnIpAddressPair[] addresses) {
        logger.traceEnter(THIS_CLASS, "setSecGwAddresses(FqdnIpAddressPair[])");
        Object object = this.MUTEX;
        synchronized (object) {
            this.secGwAddresses = addresses == null ? new FqdnIpAddressPair[]{} : addresses;
            this.setNextSecGwAddress(0);
            this.storePersistently();
        }
        logger.traceReturn(THIS_CLASS, "setSecGwAddresses(FqdnIpAddressPair[])");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushSecGwAddress(FqdnIpAddressPair address) {
        logger.traceEnter(THIS_CLASS, "pushSecGwAddress()");
        Object object = this.MUTEX;
        synchronized (object) {
            FqdnIpAddressPair[] secGwAddressesCopy = this.secGwAddresses;
            this.secGwAddresses = new FqdnIpAddressPair[secGwAddressesCopy.length + 1];
            for (int i = 0; i < secGwAddressesCopy.length; ++i) {
                this.secGwAddresses[i] = secGwAddressesCopy[i];
            }
            this.secGwAddresses[secGwAddressesCopy.length] = address;
        }
        logger.traceReturn(THIS_CLASS, "pushSecGwAddress()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSecGwAddresses(int[] addresses) {
        logger.traceEnter(THIS_CLASS, "setSecGwAddresses(int[])");
        if (addresses == null) {
            addresses = new int[]{};
        }
        int noOfAddresses = addresses.length / 4;
        Object object = this.MUTEX;
        synchronized (object) {
            this.secGwAddresses = new FqdnIpAddressPair[noOfAddresses];
            for (int a = 0; a < noOfAddresses; ++a) {
                StringBuffer ab = new StringBuffer();
                for (int b = 0; b < 4; ++b) {
                    ab.append((b == 0 ? "" : ".") + addresses[a * 4 + b]);
                }
                this.secGwAddresses[a] = new FqdnIpAddressPair(ab.toString(), null);
            }
            this.storePersistently();
        }
        logger.traceReturn(THIS_CLASS, "setSecGwAddresses(int[])");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setParameter(String paramName, String paramValue) {
        logger.traceEnter(THIS_CLASS, "setParameter() " + paramName + "=\"" + paramValue + "\"");
        boolean result2 = false;
        Object object = this.MUTEX;
        synchronized (object) {
            if (SEC_GW_ADDRESSES.equals(paramName)) {
                this.setSecGwAddresses(FqdnIpAddressPair.split(paramValue));
                result2 = true;
            }
        }
        logger.traceReturn(THIS_CLASS, "setParameter()");
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FqdnIpAddressPair[] getSecGwAddresses() {
        Object object = this.MUTEX;
        synchronized (object) {
            return this.secGwAddresses;
        }
    }

    public boolean isEmpty() {
        FqdnIpAddressPair[] address = this.getSecGwAddresses();
        if (address != null && address.length > 0) {
            return address[0] == null || AbstractParameters.isEmpty(address[0].getIpAddress()) && AbstractParameters.isEmpty(address[0].getFqdn());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FqdnIpAddressPair getSecGwAddress() {
        FqdnIpAddressPair result2;
        logger.traceEnter(THIS_CLASS, "getNextSecGwAddress()");
        Object object = this.MUTEX;
        synchronized (object) {
            result2 = this.nextSecGwAddress >= this.secGwAddresses.length ? null : this.secGwAddresses[this.nextSecGwAddress++];
            this.storePersistently();
        }
        logger.traceReturn(THIS_CLASS, "getNextSecGwAddress() " + result2);
        return result2;
    }

    public boolean hasNextSecGwAddress() {
        boolean result2 = false;
        logger.traceEnter(THIS_CLASS, "hasNextSecGwAddress()");
        if (this.secGwAddresses.length > this.nextSecGwAddress) {
            result2 = true;
        }
        logger.traceReturn(THIS_CLASS, "hasNextSecGwAddress() " + result2);
        return result2;
    }

    protected void retrievePersistently() {
        logger.traceEnter(THIS_CLASS, "retrievePersistently()");
        String secGwAddr = (String)this.rbsConfigurationMao.retrievePersistently(SEC_GW_ADDRESSES);
        this.secGwAddresses = secGwAddr != null && secGwAddr.trim().length() > 0 ? FqdnIpAddressPair.split(secGwAddr, ",") : new FqdnIpAddressPair[0];
        logger.traceReturn(THIS_CLASS, "retrievePersistently() " + secGwAddr);
    }

    private void storePersistently() {
        logger.traceEnter(THIS_CLASS, "storePersistently()");
        StringBuffer secGwAddrSb = new StringBuffer();
        if (this.secGwAddresses.length == 0) {
            this.rbsConfigurationMao.removeAdditionalAttribute(SEC_GW_ADDRESSES, null);
        } else {
            try {
                String asString = this.toStringInt();
                this.rbsConfigurationMao.storePersistently(SEC_GW_ADDRESSES, asString);
                logger.traceDebug(THIS_CLASS, "storePersistently() " + asString);
            }
            catch (MoAccessException hopfullyWontHappen) {
                logger.traceError(THIS_CLASS, "Failed to store SecGwAddresses=" + secGwAddrSb.toString() + " persistently");
            }
        }
        logger.traceReturn(THIS_CLASS, "storePersistently()");
    }

    private String toStringInt() {
        StringBuffer secGwAddrSb = new StringBuffer();
        for (int i = 0; i < this.secGwAddresses.length; ++i) {
            secGwAddrSb.append((i == 0 ? "" : ",") + this.secGwAddresses[i]);
        }
        return secGwAddrSb.toString();
    }

    public void setNextSecGwAddress(int inNextSecGwAddress) {
        this.nextSecGwAddress = inNextSecGwAddress;
    }
}

