/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.parameters;

import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.AbstractParameters;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class SecurityParameters
extends AbstractParameters {
    private static final Class THIS_CLASS = SecurityParameters.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    protected static final String ACTIVATE_SECURITY = "ActivateSecurity";
    protected static final String ACTIVATE_IP_SECURITY = "ActivateIpSecurity";
    protected static final String INTEGRATION_CODE = "RbsIntegrationCode";
    protected static final String LOCAL_INITIAL_SECURITY_CONFIGURATION_FILE_PATH = "localInitialSecurityConfigurationFilePath";
    private static final String[] parameters = new String[]{"ActivateSecurity", "ActivateIpSecurity", "localInitialSecurityConfigurationFilePath"};
    private static final Object INSTANCE_MUTEX = new Object();
    private static SecurityParameters instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized SecurityParameters instance(RbsConfigurationMao rbsConfigurationMao) {
        logger.traceEnter(THIS_CLASS, "instance()");
        Object object = INSTANCE_MUTEX;
        synchronized (object) {
            if (instance == null) {
                instance = new SecurityParameters(rbsConfigurationMao);
            }
        }
        logger.traceReturn(THIS_CLASS, "instance()");
        return instance;
    }

    public static SecurityParameters instance() {
        return instance;
    }

    private SecurityParameters(RbsConfigurationMao rbsConfigurationMaoIn) {
        super(rbsConfigurationMaoIn, parameters);
    }

    public void delete() {
        this.delete(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Coordinator coordinator) {
        Object object = INSTANCE_MUTEX;
        synchronized (object) {
            super.delete(coordinator);
            try {
                this.getSensitiveDataHelper().removeRbsIntegrationCode(coordinator);
            }
            catch (RbsConfigurationFailedException hopfullyWontHappen) {
                logger.traceError(THIS_CLASS, "Failed to remove rbsIntegrationCode=***** persistently");
            }
            instance = null;
        }
    }

    public String getActivateSecurity() {
        return this.getParameter(ACTIVATE_SECURITY);
    }

    public boolean getActivateSecurityAsBoolean() {
        return Boolean.valueOf(this.getParameter(ACTIVATE_SECURITY));
    }

    public void setActivateSecurity(String activateSecurity) {
        this.setParameter(ACTIVATE_SECURITY, activateSecurity);
    }

    public String getActivateIpSecurity() {
        return this.getParameter(ACTIVATE_IP_SECURITY);
    }

    public boolean getActivateIpSecurityAsBoolean() {
        return Boolean.valueOf(this.getParameter(ACTIVATE_IP_SECURITY));
    }

    public void setActivateIpSecurity(String activateIpSecurity) {
        this.setParameter(ACTIVATE_IP_SECURITY, activateIpSecurity);
    }

    public String getIntegrationCode() {
        return this.getSensitiveDataHelper().retrieveRbsIntegrationCode();
    }

    public void setIntegrationCode(String integrationCode) {
        this.setIntegrationCode(integrationCode, null);
    }

    public void setIntegrationCode(String integrationCode, Coordinator coordinator) {
        try {
            this.getSensitiveDataHelper().storeRbsIntegrationCode(integrationCode, coordinator);
        }
        catch (MoAccessException hopfullyWontHappen) {
            logger.traceError(THIS_CLASS, "Failed to store RbsIntegrationCode=" + integrationCode + " persistently");
        }
    }

    public String getLocalInitialSecurityConfigurationFile() {
        return this.getParameter(LOCAL_INITIAL_SECURITY_CONFIGURATION_FILE_PATH);
    }

    public void setLocalInitialSecurityConfigurationFile(String localInitialSecurityConfigurationFile) {
        this.setParameter(LOCAL_INITIAL_SECURITY_CONFIGURATION_FILE_PATH, localInitialSecurityConfigurationFile);
    }

    protected boolean setParameter(String paramName, String paramValue, Coordinator coordinator) {
        boolean result2 = false;
        if (!paramName.equals(INTEGRATION_CODE)) {
            return super.setParameter(paramName, paramValue, coordinator);
        }
        this.setIntegrationCode(paramValue, coordinator);
        result2 = true;
        return result2;
    }
}

