/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.parameters;

import java.util.ArrayList;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.AbstractParameters;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class VlanIds
extends AbstractParameters {
    private static final Class THIS_CLASS = VlanIds.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    protected static final String VLAN_IDS = "VlanIds";
    private final String NEXT_VLANID_DELIMETER = "#";
    private static final Object INSTANCE_MUTEX = new Object();
    private static VlanIds instance;
    private final Object MUTEX = new Object();
    private int[] vlanIds;
    private int nextVlanId = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized VlanIds instance(RbsConfigurationMao rbsConfigurationMaoIn) {
        logger.traceEnter(THIS_CLASS, "instance()");
        Object object = INSTANCE_MUTEX;
        synchronized (object) {
            if (instance == null) {
                instance = new VlanIds(rbsConfigurationMaoIn);
            }
        }
        logger.traceReturn(THIS_CLASS, "instance()");
        return instance;
    }

    public static VlanIds instance() {
        return instance;
    }

    private VlanIds(RbsConfigurationMao rbsConfigurationMaoIn) {
        super(rbsConfigurationMaoIn, new String[0]);
        this.retrievePersistently();
    }

    public void delete() {
        this.delete(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Coordinator coordinator) {
        Object object = INSTANCE_MUTEX;
        synchronized (object) {
            super.delete(coordinator);
            this.setVlanIds(new int[0]);
            instance = null;
        }
    }

    public String toString() {
        return "VlanIds=" + this.toStringInt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVlanIds(int[] vlanIdsIn) {
        logger.traceEnter(THIS_CLASS, "setVlanIds()");
        Object object = this.MUTEX;
        synchronized (object) {
            this.vlanIds = vlanIdsIn == null ? new int[]{} : vlanIdsIn;
            this.nextVlanId = 0;
            this.storePersistently();
        }
        logger.traceReturn(THIS_CLASS, "setVlanIds()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setParameter(String paramName, String paramValue) {
        logger.traceEnter(THIS_CLASS, "setParameter() " + paramName + "=\"" + paramValue + "\"");
        boolean result2 = false;
        Object object = this.MUTEX;
        synchronized (object) {
            if (VLAN_IDS.equals(paramName)) {
                String[] vlanIdsStr = VlanIds.split(paramValue);
                int[] tempVlanIds = new int[vlanIdsStr.length];
                for (int i = 0; i < vlanIdsStr.length; ++i) {
                    tempVlanIds[i] = Integer.parseInt(vlanIdsStr[i]);
                }
                this.setVlanIds(tempVlanIds);
                result2 = true;
            }
        }
        logger.traceReturn(THIS_CLASS, "setParameter()");
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getVlanIds() {
        Object object = this.MUTEX;
        synchronized (object) {
            return this.vlanIds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNextVlanId() {
        boolean result2;
        logger.traceEnter(THIS_CLASS, "hasNextVlanId()");
        Object object = this.MUTEX;
        synchronized (object) {
            result2 = this.nextVlanId < this.vlanIds.length;
        }
        logger.traceReturn(THIS_CLASS, "hasNextVlanId() " + result2);
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextVlanId() throws RbsConfigurationFailedException {
        int result2;
        logger.traceEnter(THIS_CLASS, "getNextVlanId()");
        Object object = this.MUTEX;
        synchronized (object) {
            if (!this.hasNextVlanId()) {
                throw new RbsConfigurationFailedException("Internal error, there is no more vlanIds in list");
            }
            result2 = this.vlanIds[this.nextVlanId++];
            this.storePersistently();
        }
        logger.traceReturn(THIS_CLASS, "getNextVlanId() " + result2);
        return result2;
    }

    protected void retrievePersistently() {
        logger.traceEnter(THIS_CLASS, "retrievePersistently()");
        String vlanIdsString = VlanIds.notNull((String)this.rbsConfigurationMao.retrievePersistently(VLAN_IDS));
        ArrayList<Integer> vlanIdList = new ArrayList<Integer>();
        if (vlanIdsString != null && vlanIdsString.trim().length() > 0) {
            int nextVlanIdDelimeterPos = vlanIdsString.indexOf("#");
            int delimeterPos = -1;
            do {
                int prevDelimeterPos;
                String tmpVlanId;
                if ((tmpVlanId = vlanIdsString.substring(prevDelimeterPos + 1, (delimeterPos = vlanIdsString.indexOf(",", (prevDelimeterPos = delimeterPos) + 1)) == -1 ? nextVlanIdDelimeterPos : delimeterPos).trim()).length() <= 0) continue;
                vlanIdList.add(Integer.valueOf(tmpVlanId));
            } while (delimeterPos != -1);
            this.nextVlanId = Integer.parseInt(vlanIdsString.substring(nextVlanIdDelimeterPos + 1));
        }
        StringBuffer trace = new StringBuffer();
        this.vlanIds = new int[vlanIdList.size()];
        for (int i = 0; i < vlanIdList.size(); ++i) {
            this.vlanIds[i] = (Integer)vlanIdList.get(i);
            trace.append((i == 0 ? "" : ",") + this.vlanIds[i]);
        }
        trace.append("#" + this.nextVlanId);
        logger.traceReturn(THIS_CLASS, "retrievePersistently() " + trace);
    }

    private void storePersistently() {
        logger.traceEnter(THIS_CLASS, "storePersistently()");
        if (this.vlanIds.length == 0) {
            this.rbsConfigurationMao.removeAdditionalAttribute(VLAN_IDS, null);
        } else {
            try {
                this.rbsConfigurationMao.storePersistently(VLAN_IDS, this.toStringInt());
            }
            catch (MoAccessException hopfullyWontHappen) {
                logger.traceError(THIS_CLASS, "Failed to store VlanIds persistently");
            }
        }
        logger.traceReturn(THIS_CLASS, "storePersistently()");
    }

    private String toStringInt() {
        StringBuffer vlanIdsSb = new StringBuffer();
        for (int i = 0; i < this.vlanIds.length; ++i) {
            vlanIdsSb.append((i == 0 ? "" : ",") + this.vlanIds[i]);
        }
        vlanIdsSb.append("#" + this.nextVlanId);
        return vlanIdsSb.toString();
    }
}

