/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.pbootparam;

import enea.ose.system.OseProcess;
import enea.ose.system.Signal;
import se.ericsson.crbs.cat.mao.rbsconfiguration.pbootparam.CsPbootGetParam;
import se.ericsson.crbs.cat.mao.rbsconfiguration.pbootparam.CsPbootGetParamReply;
import se.ericsson.crbs.cat.mao.rbsconfiguration.pbootparam.PbootParamProxy;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.vlanscan.SignalHelperWrapper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.vlanscan.SignalHelperWrapperFactory;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.common.proxy.OseSenderReceiverImpl;

public class PbootParamProxyImpl
extends OseSenderReceiverImpl
implements PbootParamProxy {
    private static final Class THIS_CLASS = PbootParamProxyImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String CS_PBOOT_SERVER_PROCESS = "Cs_pbootServer_proc";
    private static final int CS_PBOOT_RSP_TMO = 500;

    public String getPbootParameter(String pbootParameterName) {
        logger.traceEnter(THIS_CLASS, "getPbootParameter(\"" + pbootParameterName + "\")");
        String pbootParameterValue = null;
        OseProcess pbootProc = OseProcess.hunt((String)CS_PBOOT_SERVER_PROCESS);
        if (pbootProc != null) {
            SignalHelperWrapper signalHelperWrapper = SignalHelperWrapperFactory.getSignalHelperWrapper();
            if (pbootParameterName.equals("ethernetid0")) {
                signalHelperWrapper.send(pbootProc, (Signal)new CsPbootGetParam(pbootParameterName, 15L));
            } else {
                signalHelperWrapper.send(pbootProc, (Signal)new CsPbootGetParam(pbootParameterName));
            }
            CsPbootGetParamReply csPbootGetParamReply = (CsPbootGetParamReply)signalHelperWrapper.receive(CsPbootGetParamReply.class, 500);
            if (csPbootGetParamReply != null) {
                if (csPbootGetParamReply.getResultCode() == 0L) {
                    if (!csPbootGetParamReply.getName().equals(pbootParameterName)) {
                        logger.traceError(THIS_CLASS, "Received parameter value for wrong parameter from PBOOT server: name = \"" + csPbootGetParamReply.getName() + "\"");
                    } else {
                        pbootParameterValue = csPbootGetParamReply.getValue();
                    }
                }
            } else {
                logger.traceError(THIS_CLASS, "No response received from PBOOT server");
            }
        } else {
            logger.traceError(THIS_CLASS, "PBOOT server not found");
        }
        logger.traceReturn(THIS_CLASS, "getPbootParameter(\"" + pbootParameterName + "\")");
        return pbootParameterValue;
    }
}

