/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.postset;

import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationContext;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.OptionalFeaturesHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.postset.PostSetExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.postset.PostSetHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.postset.PostSetHandlerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.ProgressReportHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLogger;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.wrappers.MoFactoryMgrWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public abstract class AbstractPostSetExecutor
implements PostSetExecutor {
    public static final String EXTERNAL_CONFIGURATION_BY_OSS_HAS_FAILED = "External configuration by OSS has failed.";
    private static final Class THIS_CLASS = AbstractPostSetExecutor.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    protected static final Integer CONFIGURATION_LEVEL_NOT_USED = new Integer(-1);
    protected final String executorName;
    protected final ProgressReportHandler progressReportHandler;
    protected RbsConfigurationMao rbsConfigurationMao;
    protected final RbsConfigurationContext rbsConfigurationContext;
    protected final MoRepositoryWrapper moRepositoryWrapper;
    protected final MoFactoryMgrWrapper moFactoryMgrWrapper;
    protected final RbsConfigurationHelper helper;
    protected final PostSetHandler postSetHandler;
    protected final Integer configurationLevel;
    protected final boolean basedOnConfigurationLevel;

    public AbstractPostSetExecutor(String theExecutorName, RbsConfigurationMao theRbsConfigurationMao, Integer theConfigurationLevel) {
        logger.traceEnter(THIS_CLASS, "AbstractPostSetExecutor(" + theExecutorName + ")");
        this.executorName = theExecutorName;
        this.rbsConfigurationMao = theRbsConfigurationMao;
        this.rbsConfigurationContext = theRbsConfigurationMao.getRbsConfigurationContext();
        this.helper = (RbsConfigurationHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationHelper.class);
        this.moRepositoryWrapper = this.rbsConfigurationContext.getGenericMaoContext().getMoRepositoryWrapper();
        this.moFactoryMgrWrapper = theRbsConfigurationMao.getRbsConfigurationContext().getGenericMaoContext().getMoFactoryMgrWrapper();
        this.progressReportHandler = ProgressReportHandler.getInstance();
        this.postSetHandler = PostSetHandlerFactory.getInstance().getPostSetHandler(theRbsConfigurationMao);
        this.configurationLevel = theConfigurationLevel;
        this.basedOnConfigurationLevel = CONFIGURATION_LEVEL_NOT_USED.intValue() != this.configurationLevel.intValue();
        logger.traceReturn(THIS_CLASS, "AbstractPostSetExecutor(" + theExecutorName + ")");
    }

    public String getExecutorName() {
        return this.executorName;
    }

    public abstract void execute(Coordinator var1);

    public final boolean isBasedOnConfigLevel() {
        return this.basedOnConfigurationLevel;
    }

    public final Integer getConfigurationLevel() {
        return this.configurationLevel;
    }

    protected String getOssFailureMessage(Coordinator coordinator) {
        String faultReason = EXTERNAL_CONFIGURATION_BY_OSS_HAS_FAILED;
        try {
            Struct attributeValue;
            Object attributeValueObject = this.rbsConfigurationMao.getAttribute("configFaultReason", coordinator);
            if (attributeValueObject != null && (attributeValue = (Struct)attributeValueObject).getValue("faultReason").equals(RbsConfigurationDefinitions.RBS_FR_OSS_CONFIGURATION_FAULT)) {
                faultReason = attributeValue.getValue("faultInformation").toString();
            }
        }
        catch (MoAccessException e) {
            faultReason = EXTERNAL_CONFIGURATION_BY_OSS_HAS_FAILED;
        }
        return faultReason;
    }

    protected void updateProgressReportInformation(int integrationStepNumber, int status, String detailedInformation, boolean updateProgressReport, Coordinator coordinator) {
        this.progressReportHandler.updateProgressReportInformation(integrationStepNumber, status, detailedInformation, updateProgressReport, coordinator);
    }

    protected void logActivatedFeatures(String headerMessage, OptionalFeaturesHelper.FeaturesHolder[] activatedFeatures, Coordinator coordinator) {
        RbsConfigurationReportLogger rbsConfigurationReportLogger = RbsConfigurationReportLoggerFactory.getLogger();
        rbsConfigurationReportLogger.logInformation("Activation of features", headerMessage, coordinator);
        for (int i = 0; i < activatedFeatures.length; ++i) {
            rbsConfigurationReportLogger.logAttribute(activatedFeatures[i].moType, activatedFeatures[i].attributeName, activatedFeatures[i].attributeValue, coordinator);
        }
    }
}

