/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.postset;

import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.postset.AbstractPostSetExecutor;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class CellPostSetExecutor
extends AbstractPostSetExecutor {
    private static final String OSS_SUCCESSFULLY_FINISHED_UNLOCK_OF_CELLS = "OSS successfully finished unlock of cells";
    private static final String OSS_IS_UNLOCKING_CELLS = "OSS is unlocking cells";
    private static final Class THIS_CLASS = CellPostSetExecutor.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public CellPostSetExecutor(Integer theConfigurationLevel, RbsConfigurationMao theRbsConfigurationMao) {
        super(THIS_CLASS.getName(), theRbsConfigurationMao, theConfigurationLevel);
    }

    public void execute(Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "execute()");
        if (RbsConfigurationDefinitions.RBS_CL_UNLOCKING_CELLS.equals(this.configurationLevel)) {
            this.setUnlockingOfCellsTriggered(coordinator);
            this.executeUnlockingCells(coordinator);
        } else if (RbsConfigurationDefinitions.RBS_CL_CELLS_UNLOCKED.equals(this.configurationLevel)) {
            this.setUnlockingOfCellsTriggered(coordinator);
            this.executeCellsUnlocked(coordinator);
        } else if (RbsConfigurationDefinitions.RBS_CL_UNLOCKING_CELLS_FAILED.equals(this.configurationLevel)) {
            this.setUnlockingOfCellsTriggered(coordinator);
            this.executeUnlockingOfCellsFailed(coordinator);
        }
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    private void setUnlockingOfCellsTriggered(Coordinator coordinator) {
        try {
            this.rbsConfigurationMao.storePersistently("unlockingOfCellsTriggered", Boolean.TRUE.toString(), coordinator);
        }
        catch (MoAccessException mae) {
            String errorMsg = "Failed to set indication that unlocking of cells have been triggered by OSS";
            logger.traceAbnormal(THIS_CLASS, ExceptionHelper.appendReason((String)"Failed to set indication that unlocking of cells have been triggered by OSS", (Throwable)mae));
        }
    }

    private void executeUnlockingCells(Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "executeUnlockingCells()");
        this.helper.setRbsProgressInformation(RbsConfigurationDefinitions.RBS_PI_OSS_UNLOCKING_CELLS, coordinator);
        this.updateProgressReportInformation(2550, 3, OSS_IS_UNLOCKING_CELLS, true, coordinator);
        logger.traceReturn(THIS_CLASS, "executeUnlockingCells()");
    }

    private void executeCellsUnlocked(Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "executeCellsUnlocked()");
        this.updateProgressReportInformation(2550, 5, OSS_SUCCESSFULLY_FINISHED_UNLOCK_OF_CELLS, true, coordinator);
        logger.traceReturn(THIS_CLASS, "executeCellsUnlocked()");
    }

    private void executeUnlockingOfCellsFailed(Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "executeUnlockingOfCellsFailed()");
        this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_OSS_CONFIGURATION_FAULT, "Unlocking of cells failure", this.getOssFailureMessage(coordinator), coordinator);
        this.updateProgressReportInformation(2550, 6, "Unlocking of cells failed", true, coordinator);
        logger.traceReturn(THIS_CLASS, "executeUnlockingOfCellsFailed()");
    }
}

