/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.postset;

import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.postset.AbstractPostSetExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class ConfigFaultReasonPostSetExecutor
extends AbstractPostSetExecutor {
    private static final Class THIS_CLASS = ConfigFaultReasonPostSetExecutor.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final String faultSlogan;
    private final String faultInfo;
    private final Object attributeValue;

    public ConfigFaultReasonPostSetExecutor(String theFaultSlogan, String theFaultInfo, Object theAttributeValue, RbsConfigurationMao theRbsConfigurationMao) {
        super(THIS_CLASS.getName(), theRbsConfigurationMao, AbstractPostSetExecutor.CONFIGURATION_LEVEL_NOT_USED);
        this.faultSlogan = theFaultSlogan;
        this.faultInfo = theFaultInfo;
        this.attributeValue = theAttributeValue;
    }

    public void execute(Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "execute()");
        String localFaultSlogan = this.faultSlogan;
        String localFaultInfo = this.faultInfo;
        try {
            if (localFaultInfo == null) {
                Struct configFaultReason = (Struct)this.attributeValue;
                localFaultInfo = (String)configFaultReason.getValue("faultInformation");
            }
            if (!"".equals(this.faultInfo)) {
                if (localFaultSlogan == null) {
                    localFaultSlogan = "External fault";
                }
                RbsConfigurationReportLoggerFactory.getLogger().logFailure(localFaultSlogan, localFaultInfo, coordinator);
            }
        }
        catch (Exception e) {
            logger.traceAbnormal(THIS_CLASS, ExceptionHelper.appendReason((String)"Failed to execute fault set by OSS", (Throwable)e));
        }
        logger.traceReturn(THIS_CLASS, "execute()");
    }
}

