/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.postset;

import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.OptionalFeaturesHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.postset.AbstractPostSetExecutor;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class FeaturePostSetExecutor
extends AbstractPostSetExecutor {
    private static final String[] HEADER = new String[]{"##################################\n", "# List of:                       #\n", "# ACTIVATED/DEACTIVATED features #\n", "# ENABLED/DISABLED licenses      #\n", "##################################\n"};
    private static final String SEPARATOR = "::";
    private static final int PADDING_LENGTH = 90;
    private static final char PAD_CHAR = ' ';
    private static final String OSS_ACTIVATING_FEATURES = "OSS activating features";
    private static final Class THIS_CLASS = FeaturePostSetExecutor.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public FeaturePostSetExecutor(Integer theConfigurationLevel, RbsConfigurationMao theRbsConfigurationMao) {
        super(THIS_CLASS.getName(), theRbsConfigurationMao, theConfigurationLevel);
    }

    public void execute(Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "execute()");
        if (RbsConfigurationDefinitions.RBS_CL_ACTIVATING_FEATURES.equals(this.configurationLevel)) {
            this.setActivationOfFeaturesTriggered(coordinator);
            this.executeActivatingFeatures(coordinator);
        } else if (RbsConfigurationDefinitions.RBS_CL_FEATURES_ACTIVATED.equals(this.configurationLevel)) {
            this.setActivationOfFeaturesTriggered(coordinator);
            this.executeFeaturesActivated(coordinator);
        } else if (RbsConfigurationDefinitions.RBS_CL_ACTIVATING_FEATURES_FAILED.equals(this.configurationLevel)) {
            this.setActivationOfFeaturesTriggered(coordinator);
            this.executeActivatingFeaturesFailed(coordinator);
        }
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    private void setActivationOfFeaturesTriggered(Coordinator coordinator) {
        try {
            this.rbsConfigurationMao.storePersistently("featureActivationTriggered", Boolean.TRUE.toString(), coordinator);
        }
        catch (MoAccessException mae) {
            String errorMsg = "Failed to set indication that activation of features have been triggered by OSS";
            logger.traceAbnormal(THIS_CLASS, ExceptionHelper.appendReason((String)"Failed to set indication that activation of features have been triggered by OSS", (Throwable)mae));
        }
    }

    private void executeActivatingFeatures(Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "executeActivatingFeatures()");
        this.helper.setRbsProgressInformation(RbsConfigurationDefinitions.RBS_PI_OSS_ACTIVATING_CONFIGURATION, coordinator);
        this.updateProgressReportInformation(2525, 3, OSS_ACTIVATING_FEATURES, true, coordinator);
        logger.traceReturn(THIS_CLASS, "executeActivatingFeatures()");
    }

    private void executeFeaturesActivated(Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "executeFeaturesActivated()");
        OptionalFeaturesHelper optionalFeaturesHelper = new OptionalFeaturesHelper(this.moRepositoryWrapper);
        OptionalFeaturesHelper.FeaturesHolder[] activatedFeatures = optionalFeaturesHelper.getActivatedFeatures(coordinator);
        this.logActivatedFeatures("Features after successful activation", activatedFeatures, coordinator);
        this.updateProgressReportInformation(2525, 5, this.getProgressMessage(activatedFeatures), true, coordinator);
        logger.traceReturn(THIS_CLASS, "executeFeaturesActivated()");
    }

    private void executeActivatingFeaturesFailed(Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "executeActivatingFeaturesFailed()");
        OptionalFeaturesHelper optionalFeaturesHelper = new OptionalFeaturesHelper(this.moRepositoryWrapper);
        OptionalFeaturesHelper.FeaturesHolder[] activatedFeatures = optionalFeaturesHelper.getActivatedFeatures(coordinator);
        this.logActivatedFeatures("Features after failed activation", activatedFeatures, coordinator);
        this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_OSS_CONFIGURATION_FAULT, "Activation of features failure", this.getOssFailureMessage(coordinator), coordinator);
        this.updateProgressReportInformation(2525, 6, this.getProgressMessage(activatedFeatures), true, coordinator);
        logger.traceReturn(THIS_CLASS, "executeActivatingFeaturesFailed()");
    }

    private String getProgressMessage(OptionalFeaturesHelper.FeaturesHolder[] activatedFeatures) {
        int i;
        StringBuffer progressMessage = new StringBuffer(2000);
        for (i = 0; i < HEADER.length; ++i) {
            progressMessage.append(HEADER[i]);
        }
        for (i = 0; i < activatedFeatures.length; ++i) {
            progressMessage.append(this.padString(activatedFeatures[i].moType + SEPARATOR + activatedFeatures[i].attributeName, 90));
            progressMessage.append(activatedFeatures[i].attributeValue);
            if (i >= activatedFeatures.length - 1) continue;
            progressMessage.append('\n');
        }
        return progressMessage.toString();
    }

    private StringBuffer padString(String text, int requiredLength) {
        StringBuffer str = new StringBuffer(text);
        int strLength = str.length();
        if (requiredLength > 0 && requiredLength > strLength) {
            for (int i = strLength; i < requiredLength; ++i) {
                str.append(' ');
            }
        }
        return str;
    }
}

