/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.postset;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.postset.AbstractPostSetExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.postset.CellPostSetExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.postset.DoNothingPostSetExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.postset.FeaturePostSetExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.postset.IntegrationCompletePostSetExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.postset.OssPostSetExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.postset.PostSetExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.postset.PostSetHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.postset.S1CompletePostSetExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.postset.SiteConfigurationCompletePostSetExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.ProgressReportFileHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.transactions.TransactionServicesFactoryImpl;
import se.ericsson.security.cppsec.esa.ExpressSecurityActivation;
import se.ericsson.security.cppsec.esa.ExpressSecurityActivationFactory;

public class PostSetHandlerImpl
implements PostSetHandler {
    public static final Object MUTEX_OBJECT = new Object();
    private static final Class THIS_CLASS = PostSetHandlerImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final RbsConfigurationMao rbsConfigurationMao;
    private final ExpressSecurityActivation esa;
    private final ProgressReportFileHandler progressReportFileHandler;
    private final PostSetExecutingThread postSetExecutingThread;
    private final RbsConfigurationHelper helper;

    public PostSetHandlerImpl(RbsConfigurationMao inputRbsConfigurationMao) {
        this.rbsConfigurationMao = inputRbsConfigurationMao;
        this.esa = ExpressSecurityActivationFactory.createExpressSecurityActivation(null);
        this.progressReportFileHandler = this.rbsConfigurationMao.getProgressReportFileHandler();
        this.helper = (RbsConfigurationHelper)inputRbsConfigurationMao.getRbsConfigurationContext().getHelper(RbsConfigurationHelper.class);
        this.postSetExecutingThread = new PostSetExecutingThread();
        this.postSetExecutingThread.start();
    }

    public void finalizeSecurityActivation() {
        logger.traceEnter(THIS_CLASS, "finalizeSecurityActivation()");
        this.esa.finalizeActivation();
        logger.traceReturn(THIS_CLASS, "finalizeSecurityActivation()");
    }

    public void registerExecutorBasedOnConfigLevel(Integer configurationLevel) {
        logger.traceEnter(THIS_CLASS, "registerExecutorBasedOnConfigLevel()");
        this.postSetExecutingThread.addPostSetExecutor(this.getPostSetExecutor(configurationLevel));
        logger.traceReturn(THIS_CLASS, "registerExecutorBasedOnConfigLevel()");
    }

    public void registerExecutor(PostSetExecutor postSetExecutor) {
        logger.traceEnter(THIS_CLASS, "registerExecutorBasedOnConfigLevel()");
        this.postSetExecutingThread.addPostSetExecutor(postSetExecutor);
        logger.traceReturn(THIS_CLASS, "registerExecutorBasedOnConfigLevel()");
    }

    public void stop() throws InterruptedException {
        this.postSetExecutingThread.stopIt();
    }

    private PostSetExecutor getPostSetExecutor(Integer configurationLevel) {
        AbstractPostSetExecutor postSetExecutor = new DoNothingPostSetExecutor(configurationLevel, this.rbsConfigurationMao);
        if (this.isPostSetOssRelated(configurationLevel)) {
            postSetExecutor = new OssPostSetExecutor(configurationLevel, this.rbsConfigurationMao, this.progressReportFileHandler);
        } else if (this.isPostSetS1ResponseRelated(configurationLevel)) {
            postSetExecutor = new S1CompletePostSetExecutor(configurationLevel, this.rbsConfigurationMao);
        } else if (RbsConfigurationDefinitions.RBS_CL_INTEGRATION_COMPLETE.equals(configurationLevel)) {
            postSetExecutor = new IntegrationCompletePostSetExecutor(this.rbsConfigurationMao, this.progressReportFileHandler);
        } else if (RbsConfigurationDefinitions.RBS_CL_SITE_CONFIG_COMPLETE.equals(configurationLevel)) {
            postSetExecutor = new SiteConfigurationCompletePostSetExecutor(this.rbsConfigurationMao);
        } else if (this.isPosSetFeatureRelated(configurationLevel)) {
            postSetExecutor = new FeaturePostSetExecutor(configurationLevel, this.rbsConfigurationMao);
        } else if (this.isPostSetCellRelated(configurationLevel)) {
            postSetExecutor = new CellPostSetExecutor(configurationLevel, this.rbsConfigurationMao);
        }
        return postSetExecutor;
    }

    private boolean isPostSetS1ResponseRelated(Integer configurationLevel) {
        return RbsConfigurationDefinitions.RBS_CL_S1_COMPLETE.equals(configurationLevel) || RbsConfigurationDefinitions.RBS_CL_S1_NOT_NEEDED.equals(configurationLevel);
    }

    private boolean isPostSetOssRelated(Integer configurationLevel) {
        return RbsConfigurationDefinitions.RBS_CL_OSS_ACTIVATING_CONFIGURATION.equals(configurationLevel) || RbsConfigurationDefinitions.RBS_CL_OSS_CONFIGURATION_SUCCESSFUL.equals(configurationLevel) || RbsConfigurationDefinitions.RBS_CL_OSS_CONFIGURATION_FAILED.equals(configurationLevel);
    }

    private boolean isPostSetCellRelated(Integer configurationLevel) {
        return RbsConfigurationDefinitions.RBS_CL_UNLOCKING_CELLS.equals(configurationLevel) || RbsConfigurationDefinitions.RBS_CL_CELLS_UNLOCKED.equals(configurationLevel) || RbsConfigurationDefinitions.RBS_CL_UNLOCKING_CELLS_FAILED.equals(configurationLevel);
    }

    private boolean isPosSetFeatureRelated(Integer configurationLevel) {
        return RbsConfigurationDefinitions.RBS_CL_ACTIVATING_FEATURES.equals(configurationLevel) || RbsConfigurationDefinitions.RBS_CL_FEATURES_ACTIVATED.equals(configurationLevel) || RbsConfigurationDefinitions.RBS_CL_ACTIVATING_FEATURES_FAILED.equals(configurationLevel);
    }

    private class PostSetExecutingThread
    extends Thread {
        private final List postSetQueueList;
        private boolean keepRunning;

        public PostSetExecutingThread() {
            super("lteRbs_PostSetExecutor");
            this.postSetQueueList = new ArrayList();
            this.keepRunning = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addPostSetExecutor(PostSetExecutor postSetExecutor) {
            Object object = MUTEX_OBJECT;
            synchronized (object) {
                this.postSetQueueList.add(postSetExecutor);
                MUTEX_OBJECT.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopIt() throws InterruptedException {
            Object object = MUTEX_OBJECT;
            synchronized (object) {
                this.keepRunning = false;
                this.interrupt();
            }
            this.join();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.keepRunning) {
                ArrayList copiedPostSetQueueList = new ArrayList();
                Object object = MUTEX_OBJECT;
                synchronized (object) {
                    if (this.postSetQueueList.size() == 0) {
                        try {
                            MUTEX_OBJECT.wait();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    copiedPostSetQueueList.addAll(this.postSetQueueList);
                    this.postSetQueueList.clear();
                }
                if (copiedPostSetQueueList.size() <= 0) continue;
                this.executeExecutorsInQueue(copiedPostSetQueueList);
                object = MUTEX_OBJECT;
                synchronized (object) {
                    MUTEX_OBJECT.notifyAll();
                }
                copiedPostSetQueueList.clear();
            }
        }

        private void executeExecutorsInQueue(List copiedPostSetQueueList) {
            Control control = null;
            PostSetExecutor postSetExecutor = null;
            try {
                TransactionFactory transactionFactory = TransactionServicesFactoryImpl.getInstance().getCppTransactionFactory();
                control = transactionFactory.create(0);
                Coordinator newCoordinator = control.getCoordinator();
                try {
                    for (int i = 0; i < copiedPostSetQueueList.size(); ++i) {
                        postSetExecutor = (PostSetExecutor)copiedPostSetQueueList.get(i);
                        logger.traceGeneral(THIS_CLASS, "Executing post set executor: " + postSetExecutor.getExecutorName());
                        if (postSetExecutor.isBasedOnConfigLevel()) {
                            Integer configurationLevel = postSetExecutor.getConfigurationLevel();
                            RbsConfigurationReportLoggerFactory.getLogger().logAttribute("RbsConfiguration", "rbsConfigLevel", RbsConfigurationDefinitions.RBS_CL[configurationLevel], newCoordinator);
                        }
                        postSetExecutor.execute(newCoordinator);
                    }
                }
                catch (Exception e) {
                    control.getTerminator().rollback();
                    logger.traceError(THIS_CLASS, "Failed to execute post set executor: " + ExceptionHelper.appendReason((String)(postSetExecutor == null ? "\"not set\"" : postSetExecutor.getExecutorName()), (Throwable)e));
                    PostSetHandlerImpl.this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_OTHER_FAULT, "Configuration failed!", "Transaction failure. Retrying.");
                }
                control.getTerminator().commit();
            }
            catch (TransactionRolledBackException e) {
                PostSetHandlerImpl.this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_OTHER_FAULT, "Configuration failed!", "Transaction failure. Retrying.");
            }
            catch (InactiveTransactionException e) {
                PostSetHandlerImpl.this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_OTHER_FAULT, "Configuration failed!", "Transaction failure. Retrying.");
            }
        }
    }
}

