/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.postset;

import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.OptionalFeaturesHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.postset.AbstractPostSetExecutor;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class S1CompletePostSetExecutor
extends AbstractPostSetExecutor {
    public static final String S1_CONNECTION_SUCCESSFULY_ESTABLISHED = "S1 connection successfuly established";
    public static final String S1_CONNECTION_NOT_NEEDED = "S1 connection not needed";
    public static final String OSS_IS_FINISHING_RBS_CONFIGURATION = "OSS is finishing RBS configuration";
    private static final Class THIS_CLASS = S1CompletePostSetExecutor.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public S1CompletePostSetExecutor(Integer theConfigurationLevel, RbsConfigurationMao inRbsConfigurationMao) {
        super(THIS_CLASS.getName(), inRbsConfigurationMao, theConfigurationLevel);
    }

    public void execute(Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "execute()");
        if (RbsConfigurationDefinitions.RBS_CL_S1_COMPLETE.equals(this.configurationLevel)) {
            this.executeStandardCellSetup(coordinator);
        } else if (RbsConfigurationDefinitions.RBS_CL_S1_NOT_NEEDED.equals(this.configurationLevel)) {
            this.executeWihtoutCellSetup(coordinator);
        }
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    private void executeStandardCellSetup(Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "executeStandardCellSetup()");
        OptionalFeaturesHelper optionalFeaturesHelper = new OptionalFeaturesHelper(this.moRepositoryWrapper);
        OptionalFeaturesHelper.FeaturesHolder[] featuresAtS1Complete = optionalFeaturesHelper.getActivatedFeatures(coordinator);
        this.logActivatedFeatures("Features after S1 complete reached", featuresAtS1Complete, coordinator);
        this.helper.setConfigurationStateAndProgressLevel(110, coordinator);
        this.helper.setRbsProgressInformation(RbsConfigurationDefinitions.RBS_PI_OSS_UNLOCKING_CELLS, coordinator);
        this.updateProgressReportInformation(2600, 3, OSS_IS_FINISHING_RBS_CONFIGURATION, false, coordinator);
        this.updateProgressReportInformation(2500, 5, S1_CONNECTION_SUCCESSFULY_ESTABLISHED, true, coordinator);
        logger.traceReturn(THIS_CLASS, "executeStandardCellSetup()");
    }

    private void executeWihtoutCellSetup(Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "executeWihtoutCellSetup()");
        this.helper.setConfigurationStateAndProgressLevel(110, coordinator);
        this.helper.setRbsProgressInformation(RbsConfigurationDefinitions.RBS_PI_OSS_UNLOCKING_CELLS, coordinator);
        this.updateProgressReportInformation(2600, 3, OSS_IS_FINISHING_RBS_CONFIGURATION, false, coordinator);
        this.updateProgressReportInformation(2500, 5, S1_CONNECTION_NOT_NEEDED, true, coordinator);
        logger.traceReturn(THIS_CLASS, "executeWihtoutCellSetup()");
    }
}

