/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.IntegrationStep;

public class IntegrationGroup
implements Comparable {
    public static final String TOP_XML_TAG = "IntegrationGroup";
    public static final String XML_NAME_ATTRIBUTE = "name";
    public static final String XML_GROUP_NUMBER_ATTRIBUTE = "group";
    public static final String XML_MESSAGE_ATTRIBUTE = "message";
    private static final String INTEGRATION_GROUP_START_XML_TAG = "<IntegrationGroup name=\"";
    private static final String INTEGRATION_GROUP_GROUP_NUMBER_XML_TAG = "\" group=\"";
    private static final String INTEGRATION_GROUP_MESSAGE_XML_TAG = "\" message=\"";
    private static final String INTEGRATION_GROUP_END_START_XML_TAG = "\">";
    private static final String INTEGRATION_GROUP_END_XML_TAG = "</IntegrationGroup>";
    private final List subItems;
    private final int groupNumber;
    private String name;
    private String message;
    private IntegrationGroup parentIntegrationGroup = null;

    public IntegrationGroup(int inGroupNumber, String inName, String inMessage) {
        this.groupNumber = inGroupNumber;
        this.name = inName;
        this.message = inMessage;
        this.subItems = new ArrayList();
    }

    public String[] getXmls() {
        ArrayList<String> xmlList = new ArrayList<String>();
        StringBuffer xmlBuf = new StringBuffer(1000);
        xmlBuf.append(INTEGRATION_GROUP_START_XML_TAG).append(this.name).append(INTEGRATION_GROUP_GROUP_NUMBER_XML_TAG).append(this.groupNumber).append(INTEGRATION_GROUP_MESSAGE_XML_TAG).append(this.message).append(INTEGRATION_GROUP_END_START_XML_TAG);
        xmlList.add(xmlBuf.toString());
        for (int i = 0; i < this.subItems.size(); ++i) {
            int j;
            String[] xmls;
            Object subItem = this.subItems.get(i);
            if (subItem instanceof IntegrationStep) {
                IntegrationStep integrationStep = (IntegrationStep)subItem;
                xmls = integrationStep.getXmls();
                for (j = 0; j < xmls.length; ++j) {
                    xmlList.add("  " + xmls[j]);
                }
                continue;
            }
            if (!(subItem instanceof IntegrationGroup)) continue;
            IntegrationGroup integrationGroup = (IntegrationGroup)subItem;
            xmls = integrationGroup.getXmls();
            for (j = 0; j < xmls.length; ++j) {
                xmlList.add("  " + xmls[j]);
            }
        }
        xmlList.add(INTEGRATION_GROUP_END_XML_TAG);
        String[] xmls = new String[xmlList.size()];
        xmlList.toArray(xmls);
        return xmls;
    }

    public int getGroupNumber() {
        return this.groupNumber;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String inMessage) {
        this.message = inMessage;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String inName) {
        this.name = inName;
    }

    public void addIntegrationStep(IntegrationStep integrationStep) {
        if (!this.subItems.contains(integrationStep)) {
            this.subItems.add(integrationStep);
        }
    }

    public IntegrationGroup[] getIntegrationGroups() {
        ArrayList<IntegrationGroup> tmpList = new ArrayList<IntegrationGroup>();
        for (int i = 0; i < this.subItems.size(); ++i) {
            Object subItem = this.subItems.get(i);
            if (!(subItem instanceof IntegrationGroup)) continue;
            IntegrationGroup integrationGroup = (IntegrationGroup)subItem;
            tmpList.add(integrationGroup);
            IntegrationGroup[] subIntegrationGroups = integrationGroup.getIntegrationGroups();
            if (subIntegrationGroups.length <= 0) continue;
            tmpList.addAll(Arrays.asList(subIntegrationGroups));
        }
        IntegrationGroup[] integrationGroups = new IntegrationGroup[tmpList.size()];
        tmpList.toArray(integrationGroups);
        return integrationGroups;
    }

    public IntegrationStep[] getIntegrationSteps() {
        ArrayList<IntegrationStep> tmpList = new ArrayList<IntegrationStep>();
        for (int i = 0; i < this.subItems.size(); ++i) {
            Object subItem = this.subItems.get(i);
            if (!(subItem instanceof IntegrationStep)) continue;
            IntegrationStep integrationStep = (IntegrationStep)subItem;
            tmpList.add(integrationStep);
        }
        IntegrationStep[] integrationSteps = new IntegrationStep[tmpList.size()];
        tmpList.toArray(integrationSteps);
        return integrationSteps;
    }

    public void addIntegrationGroup(IntegrationGroup integrationGroup) {
        if (!this.subItems.contains(integrationGroup)) {
            integrationGroup.setParentIntegrationGroup(this);
            this.subItems.add(integrationGroup);
        }
    }

    public void setParentIntegrationGroup(IntegrationGroup inParentIntegrationGroup) {
        this.parentIntegrationGroup = inParentIntegrationGroup;
    }

    public IntegrationGroup getParentIntegrationGroup() {
        return this.parentIntegrationGroup;
    }

    public int hashCode() {
        return this.groupNumber;
    }

    public boolean equals(Object otherObject) {
        boolean isEqual = false;
        if (otherObject instanceof IntegrationGroup) {
            IntegrationGroup otherIntegrationGroup = (IntegrationGroup)otherObject;
            isEqual = this.groupNumber == otherIntegrationGroup.getGroupNumber();
        }
        return isEqual;
    }

    public int compareTo(Object otherObject) {
        int result2 = 0;
        if (otherObject instanceof IntegrationGroup) {
            IntegrationGroup otherIntegrationGroup = (IntegrationGroup)otherObject;
            if (this.groupNumber < otherIntegrationGroup.getGroupNumber()) {
                result2 = -1;
            } else if (this.groupNumber > otherIntegrationGroup.getGroupNumber()) {
                result2 = 1;
            }
        }
        return result2;
    }
}

