/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport;

import java.text.SimpleDateFormat;
import se.ericsson.crbs.cat.common.StringHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.ProgressReportCreator;
import se.ericsson.crbs.common.DateTimeHelper;

public class IntegrationStep
implements Comparable {
    public static final String TOP_XML_TAG = "IntegrationStep";
    public static final String XML_NAME_ATTRIBUTE = "name";
    public static final String XML_STEP_NUMBER_ATTRIBUTE = "step";
    public static final String XML_STATUS_ATTRIBUTE = "status";
    public static final String XML_TIME_STAMP_ATTRIBUTE = "timeStamp";
    public static final String DETAILED_MESSAGE_XML_TAG = "DetailedInformation";
    public static final String NOT_STARTED = "Not started";
    private static final String INTEGRATION_STEP_START_XML_TAG = "<IntegrationStep name=\"";
    private static final String INTEGRATION_STEP_STATUS_XML_TAG = "\" status=\"";
    private static final String INTEGRATION_STEP_STEP_NUMBER_XML_TAG = "\" step=\"";
    private static final String INTEGRATION_STEP_TIME_STAMP_XML_TAG = "\" timeStamp=\"";
    private static final String INTEGRATION_STEP_END_START_XML_TAG = "\">";
    private static final String DETAILED_INFO_START_XML_TAG = "<DetailedInformation>";
    private static final String DETAILED_INFO_END_XML_TAG = "</DetailedInformation>";
    private static final String INTEGRATION_STEP_END_XML_TAG = "</IntegrationStep>";
    private static final SimpleDateFormat DATE_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private final int stepNumber;
    private String name;
    private int status;
    private long timeStamp;
    private String detailedInformation;
    private boolean statusHasBeenRetrying = false;
    private boolean statusHasBeenExecuting = false;
    private boolean statusHasBeenFailed = false;
    private boolean statusHasBeenWarning = false;

    public IntegrationStep(int inStepNumber, String inName, int inStatus, long inTimeStamp, String inDetailedInformation) {
        this.stepNumber = inStepNumber;
        this.name = inName;
        this.status = inStatus;
        if (this.status == 4) {
            this.statusHasBeenRetrying = true;
        } else if (this.status == 3) {
            this.statusHasBeenExecuting = true;
        } else if (this.status == 0) {
            this.statusHasBeenFailed = true;
        } else if (this.status == 6) {
            this.statusHasBeenWarning = true;
        }
        this.timeStamp = inTimeStamp;
        this.setDetailedInformation(inDetailedInformation);
    }

    public String[] getXmls() {
        String[] xmls = new String[3];
        StringBuffer xmlBuf = new StringBuffer(1000);
        xmlBuf.append(INTEGRATION_STEP_START_XML_TAG).append(this.name).append(INTEGRATION_STEP_STEP_NUMBER_XML_TAG).append(this.stepNumber).append(INTEGRATION_STEP_STATUS_XML_TAG).append(this.getStatusString()).append(INTEGRATION_STEP_TIME_STAMP_XML_TAG).append(this.getTimeStamp()).append(INTEGRATION_STEP_END_START_XML_TAG);
        xmls[0] = xmlBuf.toString();
        xmlBuf.setLength(0);
        xmlBuf.append("  ").append(DETAILED_INFO_START_XML_TAG).append(this.detailedInformation).append(DETAILED_INFO_END_XML_TAG);
        xmls[1] = xmlBuf.toString();
        xmls[2] = INTEGRATION_STEP_END_XML_TAG;
        return xmls;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String inName) {
        this.name = inName;
    }

    public int getStepNumber() {
        return this.stepNumber;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusString() {
        return ProgressReportCreator.STATUS_VALUE_STRINGS[this.status];
    }

    public String getShortStatusString() {
        return ProgressReportCreator.SHORT_STATUS_VALUE_STRINGS[this.status];
    }

    public boolean setStatus(int inputStatus) {
        int currentStatus = this.status;
        boolean keepCurrent = this.checkKeepCurrentStatus(inputStatus);
        this.status = this.checkRetrying(inputStatus) ? 4 : (keepCurrent ? currentStatus : inputStatus);
        this.setStatusHasBeen(inputStatus);
        return keepCurrent;
    }

    private boolean checkKeepCurrentStatus(int inputStatus) {
        return inputStatus == 4 && !this.statusHasBeenExecuting;
    }

    private boolean checkRetrying(int inputStatus) {
        return inputStatus == 3 && (this.statusHasBeenRetrying || this.statusHasBeenFailed || this.statusHasBeenWarning);
    }

    private void setStatusHasBeen(int inputStatus) {
        if (inputStatus == 1) {
            this.statusHasBeenExecuting = false;
            this.statusHasBeenRetrying = false;
            this.statusHasBeenFailed = false;
            this.statusHasBeenWarning = false;
        }
        if (inputStatus == 4) {
            this.statusHasBeenRetrying = true;
        }
        if (inputStatus == 0) {
            this.statusHasBeenFailed = true;
        }
        if (inputStatus == 6) {
            this.statusHasBeenWarning = true;
        }
        if (inputStatus == 3) {
            this.statusHasBeenExecuting = true;
        }
    }

    public String getTimeStamp() {
        String result2 = this.status == 1 ? NOT_STARTED : DateTimeHelper.dateToString((long)this.timeStamp, (SimpleDateFormat)DATE_TIME_FORMAT);
        return result2;
    }

    public void setTimeStamp(long inTimeStamp) {
        this.timeStamp = inTimeStamp;
    }

    public String getDetailedInformation() {
        return this.detailedInformation;
    }

    public final void setDetailedInformation(String inDetailedInformation) {
        this.detailedInformation = this.removeXmlTags(inDetailedInformation);
    }

    private String removeXmlTags(String inDetailedInformation) {
        String withoutAmpersand = StringHelper.replaceInString((String)inDetailedInformation, (String)"&", (String)"&amp;");
        String withoutLt = StringHelper.replaceInString((String)withoutAmpersand, (String)"<", (String)"&lt;");
        return StringHelper.replaceInString((String)withoutLt, (String)">", (String)"&gt;");
    }

    public int hashCode() {
        return this.stepNumber;
    }

    public boolean equals(Object otherObject) {
        boolean isEqual = false;
        if (otherObject instanceof IntegrationStep) {
            IntegrationStep otherIntegrationStep = (IntegrationStep)otherObject;
            isEqual = this.stepNumber == otherIntegrationStep.getStepNumber();
        }
        return isEqual;
    }

    public int compareTo(Object otherObject) {
        int result2 = 0;
        if (otherObject instanceof IntegrationStep) {
            IntegrationStep otherIntegrationStep = (IntegrationStep)otherObject;
            if (this.stepNumber < otherIntegrationStep.getStepNumber()) {
                result2 = -1;
            } else if (this.stepNumber > otherIntegrationStep.getStepNumber()) {
                result2 = 1;
            }
        }
        return result2;
    }

    public String toString() {
        StringBuffer result2 = new StringBuffer(600);
        result2.append("Name: \"").append(this.name).append("\", Status: \"").append(this.status).append("\", TimeStamp: \"").append(this.timeStamp).append("\", Detailed Information: ").append(StringHelper.doubleQuote((String)this.detailedInformation));
        return result2.toString();
    }
}

