/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport;

import enea.ose.system.InSignal;
import enea.ose.system.OseProcess;
import enea.ose.system.OutSignal;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.FileSizeExceededException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.ProgressReportFileWriter;
import se.ericsson.crbs.common.DateTimeHelper;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.logging.TraceGroup;

public class ProgressReportFileHandler
implements AbstractLogger {
    private static final String COLON_STRING = ":";
    private static final String[] PACKAGE_NAMES_TO_BE_LOGGED = new String[]{"se.ericsson.crbs.cat.mao.rbsconfiguration", "se.ericsson.crbs.cat.mao.antennanearunit", "se.ericsson.crbs.cat.mao.antennasubunit", "se.ericsson.crbs.cat.mao.antennasystemconfiguration", "se.ericsson.crbs.cat.mao.antennaunit", "se.ericsson.crbs.cat.mao.retsubunit"};
    private static final Class THIS_CLASS = ProgressReportFileHandler.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    protected static final String LOG_FILE_NAME = "Autointegration_report.log";
    private ProgressReportFileWriter progressReportFileWriter = null;
    private String logFilePath = null;

    public ProgressReportFileHandler(String logDirPath) {
        logger.traceEnter(THIS_CLASS, "ProgressReportFileHandler()");
        this.logFilePath = logDirPath.endsWith(File.separator) ? logDirPath + LOG_FILE_NAME : logDirPath + File.separator + LOG_FILE_NAME;
        logger.traceReturn(THIS_CLASS, "ProgressReportFileHandler()");
    }

    public String getLogFilePath() {
        return this.logFilePath;
    }

    public void setLogFilePath(String inputLogFilePath) {
        if (inputLogFilePath != null) {
            this.logFilePath = inputLogFilePath;
        }
    }

    public void integrationStarted() {
        logger.traceEnter(THIS_CLASS, "integrationStarted()");
        if (this.logFilePath != null) {
            try {
                ProgressReportFileWriter.ProgressReportWritingFile progressReportWritingFile = new ProgressReportFileWriter.ProgressReportWritingFile(this.logFilePath, false);
                this.progressReportFileWriter = new ProgressReportFileWriter(progressReportWritingFile);
                logger.traceReturn(THIS_CLASS, "integrationStarted()");
                logger.removeListeningLogger((AbstractLogger)this);
                logger.addListeningLogger((AbstractLogger)this);
            }
            catch (IOException ioe) {
                logger.info(THIS_CLASS, ExceptionHelper.appendReason((String)"Failed to create directory and/or file for Auto Integration log", (Throwable)ioe));
            }
        }
    }

    public void integrationContinued(String inputLogFilePath) {
        logger.traceEnter(THIS_CLASS, "integrationContinued()");
        if (this.logFilePath != null) {
            try {
                this.setLogFilePath(inputLogFilePath);
                ProgressReportFileWriter.ProgressReportWritingFile progressReportWritingFile = new ProgressReportFileWriter.ProgressReportWritingFile(this.logFilePath, true);
                this.progressReportFileWriter = new ProgressReportFileWriter(progressReportWritingFile);
                logger.traceReturn(THIS_CLASS, "integrationContinued()");
                logger.removeListeningLogger((AbstractLogger)this);
                logger.addListeningLogger((AbstractLogger)this);
            }
            catch (IOException ioe) {
                logger.info(THIS_CLASS, ExceptionHelper.appendReason((String)"Failed to create directory and/or file for Auto Integration log", (Throwable)ioe));
            }
        }
    }

    public void integrationFinishedOrFailed() {
        try {
            logger.removeListeningLogger((AbstractLogger)this);
            this.progressReportFileWriter.stopIt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addListeningLogger(AbstractLogger notUsed) {
    }

    public void removeListeningLogger(AbstractLogger notUsed) {
    }

    public void info(Class clazz, String message) {
        StringBuffer stringbuffer = new StringBuffer();
        stringbuffer.append("INFO :");
        stringbuffer.append(ProgressReportFileHandler.getClassAndTreadInfo(clazz)).append(' ');
        stringbuffer.append(message);
        this.writeToFile(clazz, stringbuffer.toString());
    }

    public void traceAbnormal(Class clazz, String message) {
        this.trace(TraceGroup.ABNORMAL, clazz, message);
    }

    public void traceDebug(Class clazz, String message) {
        this.trace(TraceGroup.DEBUG, clazz, message);
    }

    public void traceDebugStackTrace(Class clazz, Throwable throwable) {
        this.trace(TraceGroup.DEBUG, clazz, ExceptionHelper.convertToString((Throwable)throwable));
    }

    public void traceEnter(Class clazz, String message) {
        StringBuffer stringbuffer = new StringBuffer();
        stringbuffer.append("ENTER:");
        stringbuffer.append(ProgressReportFileHandler.getClassAndTreadInfo(clazz)).append(' ');
        stringbuffer.append(message);
        this.writeToFile(clazz, stringbuffer.toString());
    }

    public void traceError(Class clazz, String message) {
        StringBuffer stringbuffer = new StringBuffer();
        stringbuffer.append("ERROR:");
        stringbuffer.append(ProgressReportFileHandler.getClassAndTreadInfo(clazz)).append(' ');
        stringbuffer.append(message);
        this.writeToFile(clazz, stringbuffer.toString());
    }

    public void traceError(Class clazz, String message, Throwable throwable) {
        StringBuffer stringbuffer = new StringBuffer();
        stringbuffer.append("ERROR:");
        stringbuffer.append(ProgressReportFileHandler.getClassAndTreadInfo(clazz)).append(' ');
        stringbuffer.append(message).append(' ');
        stringbuffer.append(ExceptionHelper.convertToString((Throwable)throwable));
        this.writeToFile(clazz, stringbuffer.toString());
    }

    public void traceGeneral(Class clazz, String message) {
        this.trace(TraceGroup.GENERAL, clazz, message);
    }

    public void traceParam(Class clazz, String message) {
        StringBuffer stringbuffer = new StringBuffer();
        stringbuffer.append("PARAM:");
        stringbuffer.append(ProgressReportFileHandler.getClassAndTreadInfo(clazz)).append(' ');
        stringbuffer.append(message);
        this.writeToFile(clazz, stringbuffer.toString());
    }

    public void traceRecSig(Class clazz, String message, InSignal insignal) {
        StringBuffer stringbuffer = new StringBuffer();
        stringbuffer.append("RESIG:");
        stringbuffer.append(ProgressReportFileHandler.getClassAndTreadInfo(clazz)).append(' ');
        stringbuffer.append(message);
        try {
            int sigNo = insignal.getSigNo();
            stringbuffer.append(", SigNo: ");
            stringbuffer.append(sigNo);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        this.writeToFile(clazz, stringbuffer.toString());
    }

    public void traceReturn(Class clazz, String message) {
        StringBuffer stringbuffer = new StringBuffer();
        stringbuffer.append("RETRN:");
        stringbuffer.append(ProgressReportFileHandler.getClassAndTreadInfo(clazz)).append(' ');
        stringbuffer.append(message);
        this.writeToFile(clazz, stringbuffer.toString());
    }

    public void traceSendSig(Class clazz, String message, OutSignal outsignal, OseProcess oseprocess) {
        StringBuffer stringbuffer = new StringBuffer();
        stringbuffer.append("SESIG:");
        stringbuffer.append(ProgressReportFileHandler.getClassAndTreadInfo(clazz)).append(' ');
        stringbuffer.append(message);
        try {
            int sigNo = outsignal.javaToOse();
            stringbuffer.append(", SigNo: ");
            stringbuffer.append(sigNo);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        this.writeToFile(clazz, stringbuffer.toString());
    }

    public void traceState(Class clazz, String message) {
        StringBuffer stringbuffer = new StringBuffer();
        stringbuffer.append("STATE:");
        stringbuffer.append(ProgressReportFileHandler.getClassAndTreadInfo(clazz)).append(' ');
        stringbuffer.append(message);
        this.writeToFile(clazz, stringbuffer.toString());
    }

    public void traceTimer(Class clazz, String message) {
        this.trace(TraceGroup.TIMER, clazz, message);
    }

    private void trace(TraceGroup tracegroup, Class clazz, String message) {
        StringBuffer stringbuffer = new StringBuffer();
        stringbuffer.append("TRACE:");
        stringbuffer.append(tracegroup).append(' ');
        stringbuffer.append(ProgressReportFileHandler.getClassAndTreadInfo(clazz)).append(' ');
        stringbuffer.append(message);
        this.writeToFile(clazz, stringbuffer.toString());
    }

    private static String getClassAndTreadInfo(Class clazz) {
        String packagageName = clazz.getPackage().getName();
        String threadName = Thread.currentThread().getName();
        String className = packagageName.length() > 0 ? clazz.getName().substring(packagageName.length() + 1) : clazz.getName();
        return packagageName + COLON_STRING + threadName + " " + className;
    }

    private void writeToFile(Class clazz, String message) {
        Package packageName = clazz.getPackage();
        if (ProgressReportFileWriter.logAllMessages() || this.logCurrentPackage(packageName)) {
            String timeStamp = DateTimeHelper.dateToString((long)System.currentTimeMillis(), (String)"yyyy-MM-dd HH:mm:ss.SSS", (Locale)Locale.getDefault());
            String messageToBeLogged = timeStamp + "-" + message;
            this.writeToFile(messageToBeLogged);
        }
    }

    private boolean logCurrentPackage(Package packageName) {
        boolean logPackage = false;
        for (int i = 0; i < PACKAGE_NAMES_TO_BE_LOGGED.length; ++i) {
            if (!packageName.getName().startsWith(PACKAGE_NAMES_TO_BE_LOGGED[i])) continue;
            logPackage = true;
            break;
        }
        return logPackage;
    }

    protected void writeToFile(String messageToBeLogged) {
        String logThis = messageToBeLogged;
        if (!logThis.endsWith("\n")) {
            logThis = logThis + "\n";
        }
        try {
            this.progressReportFileWriter.writeToFile(logThis);
        }
        catch (FileSizeExceededException fsee) {
            logger.removeListeningLogger((AbstractLogger)this);
            logger.traceAbnormal(THIS_CLASS, "Log file size for Auto integration exceed");
        }
    }
}

