/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import se.ericsson.crbs.cat.common.StringHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.FileSizeExceededException;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class ProgressReportFileWriter
extends Thread {
    public static final String LOG_ALL_SYSTEM_PROP_NAME = "autointegration_log_all";
    protected static final String LOG_FILE_MAX_SIZE_SYSTEM_PROP_NAME = "autointegration_logfile_maxsize";
    private static final long DEFAULT_MAX_LOG_FILE_SIZE = 2500L;
    protected static final int MAX_BUFFER_SIZE = 10000;
    private static final Class THIS_CLASS = ProgressReportFileWriter.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final Object THREAD_TERMINATED_MUTEX_OBJECT = new Object();
    private static final Object THREAD_MUTEX_OBJECT = new Object();
    private static final Object BUFFER_MUTEX_OBJECT = new Object();
    private static final long WAITING_PERIOD = 5000L;
    private boolean keepRunning = true;
    private boolean running = true;
    private final ProgressReportWritingFile logFile;
    private StringBuffer logFileBuffer;
    private boolean maxFileSizeReached = false;

    public ProgressReportFileWriter(ProgressReportWritingFile progressReportWritingFile) throws IOException {
        super("CRBS_lmCatOamLmU_ProgressReportFlushingThread");
        this.logFile = progressReportWritingFile;
        File logDir = this.logFile.getParentFile();
        try {
            if (progressReportWritingFile.doAppend() && this.logFile.exists()) {
                this.logFileBuffer = new StringBuffer(10000);
                this.writeToFile("####################### Integration of RBS continued #######################\n\n");
            } else {
                this.logFileBuffer = new StringBuffer(10000);
                this.createLogFileDirectory(logDir);
                this.logFile.delete();
                this.logFile.createNewFile();
                this.writeToFile("####################### Integration of RBS started #######################\n\n");
            }
            Runtime.getRuntime().addShutdownHook(new ShutDownFlushingThread(this));
        }
        catch (Exception e) {
            String errorMsg = "Failed to create file path for log files: " + StringHelper.doubleQuote((String)logDir.getAbsolutePath());
            errorMsg = ExceptionHelper.appendReason((String)errorMsg, (Throwable)e);
            throw new IOException(errorMsg);
        }
        this.setDaemon(true);
        this.startIt();
    }

    protected static long getMaxLogFileSize() {
        long maxFileSize = 2500L;
        String propertyMaxSizeString = System.getProperty(LOG_FILE_MAX_SIZE_SYSTEM_PROP_NAME);
        if (propertyMaxSizeString != null) {
            try {
                maxFileSize = Long.parseLong(propertyMaxSizeString);
            }
            catch (NumberFormatException nfe) {
                maxFileSize = 2500L;
            }
        }
        return maxFileSize * 1024L;
    }

    protected static boolean logAllMessages() {
        String propertyLogAllString = System.getProperty(LOG_ALL_SYSTEM_PROP_NAME, "false");
        return "true".equalsIgnoreCase(propertyLogAllString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeToFile(String messageToBeLogged) throws FileSizeExceededException {
        long fileLength = this.logFile.length() + (long)this.logFileBuffer.length();
        long maxFileSize = ProgressReportFileWriter.getMaxLogFileSize();
        String fileSizeExceededMessage = "Max file size (" + (double)maxFileSize / 1024000.0 + " MB) exceeded.";
        if (!ProgressReportFileWriter.logAllMessages() && fileLength + (long)fileSizeExceededMessage.length() + (long)messageToBeLogged.length() > maxFileSize) {
            this.writeFileExceeded(fileSizeExceededMessage);
        } else if (!this.maxFileSizeReached) {
            try {
                Object object = BUFFER_MUTEX_OBJECT;
                synchronized (object) {
                    this.logFileBuffer.append(messageToBeLogged);
                }
                if (this.logFileBuffer.length() >= 10000) {
                    this.flushBuffer();
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFileExceeded(String fileSizeExceededMessage) throws FileSizeExceededException {
        Object object = BUFFER_MUTEX_OBJECT;
        synchronized (object) {
            this.logFileBuffer.append(fileSizeExceededMessage);
        }
        this.flushBuffer();
        object = THREAD_TERMINATED_MUTEX_OBJECT;
        synchronized (object) {
            this.keepRunning = false;
            if (this.running) {
                try {
                    THREAD_TERMINATED_MUTEX_OBJECT.wait(5000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.maxFileSizeReached = true;
        throw new FileSizeExceededException(fileSizeExceededMessage);
    }

    private void startIt() {
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopIt() {
        if (this.keepRunning) {
            try {
                this.writeToFile("\n\n####################### Integration of RBS stopped #######################\n\n");
            }
            catch (Exception exception) {
                // empty catch block
            }
            Object object = THREAD_TERMINATED_MUTEX_OBJECT;
            synchronized (object) {
                Object object2 = THREAD_MUTEX_OBJECT;
                synchronized (object2) {
                    THREAD_MUTEX_OBJECT.notifyAll();
                }
                if (this.running) {
                    try {
                        object2 = THREAD_MUTEX_OBJECT;
                        synchronized (object2) {
                            this.keepRunning = false;
                        }
                        THREAD_TERMINATED_MUTEX_OBJECT.wait(10000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flushBuffer() {
        Object object = THREAD_MUTEX_OBJECT;
        synchronized (object) {
            THREAD_MUTEX_OBJECT.notifyAll();
        }
    }

    public void start() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = THREAD_MUTEX_OBJECT;
        synchronized (object) {
            this.running = true;
            while (this.keepRunning) {
                try {
                    THREAD_MUTEX_OBJECT.wait(5000L);
                    this.writeToFile();
                }
                catch (Exception ignore) {}
            }
            try {
                this.writeToFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        object = THREAD_TERMINATED_MUTEX_OBJECT;
        synchronized (object) {
            this.running = false;
            THREAD_TERMINATED_MUTEX_OBJECT.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile() throws IOException {
        StringBuffer unwrittenData = new StringBuffer();
        Object object = BUFFER_MUTEX_OBJECT;
        synchronized (object) {
            if (this.logFileBuffer.length() > 0) {
                unwrittenData.append(this.logFileBuffer);
                this.logFileBuffer = new StringBuffer(10000);
            }
            this.logFile.write(unwrittenData.toString().getBytes());
        }
    }

    private void createLogFileDirectory(File logFileDir) throws IOException {
        logger.traceEnter(THIS_CLASS, "createLogFileDirectory()");
        if (!logFileDir.exists() && !logFileDir.mkdirs()) {
            String errorMsg = "Failed to create file path for log files: " + StringHelper.doubleQuote((String)logFileDir.getAbsolutePath());
            throw new IOException(errorMsg);
        }
        logger.traceReturn(THIS_CLASS, "createLogFileDirectory()");
    }

    public static class ShutDownFlushingThread
    extends Thread {
        private final ProgressReportFileWriter progressReportFileWriter;

        public ShutDownFlushingThread(ProgressReportFileWriter inputProgressReportFileWriter) {
            super("CRBS_lmCatOamLmU_ShutdownFlushingThread");
            this.progressReportFileWriter = inputProgressReportFileWriter;
        }

        public void run() {
            try {
                this.progressReportFileWriter.flushBuffer();
                this.progressReportFileWriter.stopIt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static class ProgressReportWritingFile
    extends File {
        private final boolean appendToFile;

        public ProgressReportWritingFile(String filePath, boolean inputAppendToFile) throws IOException {
            super(filePath);
            this.appendToFile = inputAppendToFile;
        }

        public boolean doAppend() {
            return this.appendToFile;
        }

        public void write(byte[] unwrittenData) throws IOException {
            FileOutputStream fos = new FileOutputStream(this, true);
            fos.write(unwrittenData);
            fos.flush();
            fos.close();
        }
    }
}

