/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.led;

import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import enea.ose.system.InSignal;
import enea.ose.system.OseProcess;
import enea.ose.system.Signal;
import enea.ose.system.SignalRegistry;
import enea.ose.system.ThisProcess;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.led.LEDProxy;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.led.signals.BcServerConnEstablishCfmSignal;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.led.signals.BcServerConnEstablishRejSignal;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.led.signals.BcServerConnEstablishReqSignal;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.led.signals.BcServerSetVisualIndicationCfmSignal;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.led.signals.BcServerSetVisualIndicationRejSignal;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.led.signals.BcServerSetVisualIndicationReqSignal;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.common.proxy.OseSenderReceiver;
import se.ericsson.crbs.omf.common.proxy.OseSenderReceiverFactoryFactory;
import se.ericsson.crbs.omf.common.proxy.SignalException;

public class LEDProxyImpl
implements LEDProxy {
    private int currentState = -1;
    private static final Class THIS_CLASS = LEDProxyImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    protected static final String ELIB_BC_CONTROLLER_NAME = "BcServer";
    protected static final int ELIB_BC_VISUAL_STATE_O_LOADING_SW = 272;
    protected static final int ELIB_BC_VISUAL_STATE_O_LOADING_SW_END = 273;
    protected static final int ELIB_BC_VISUAL_STATE_O_OPERATIONAL = 288;
    protected static final int ELIB_BC_VISUAL_STATE_O_NO_POWER = 289;
    protected static final int ELIB_BC_VISUAL_STATE_O_BUSY = 304;
    protected static final int ELIB_BC_VISUAL_STATE_O_BUSY_END = 305;
    protected static final int ELIB_BC_VISUAL_STATE_O_DEPENDENT_RESOURCE_MISSING = 320;
    protected static final int ELIB_BC_VISUAL_STATE_O_DEPENDENT_RESOURCE_MISSING_END = 321;
    protected static final int ELIB_BC_VISUAL_STATE_M_FULL_MAINTENANCE_MODE = 784;
    protected static final int ELIB_BC_VISUAL_STATE_M_NO_MAINTENANCE_MODE = 785;
    protected static final int ELIB_BC_VISUAL_STATE_M_REMOVING_TRAFFIC = 817;
    protected static final int ELIB_BC_VISUAL_STATE_M_REMOVING_TRAFFIC_END = 818;
    protected static final int ELIB_BC_VISUAL_STATE_F_HW_FAULT_EXISTS = 1040;
    protected static final int ELIB_BC_VISUAL_STATE_F_NO_HW_FAULT_EXISTS = 1041;
    protected static final int ELIB_BC_VISUAL_STATE_S_A_FAULT_EXIST_IN_THE_NODE = 528;
    protected static final int ELIB_BC_VISUAL_STATE_S_FAULT_IN_REMOTE_UNIT = 529;
    protected static final int ELIB_BC_VISUAL_STATE_S_NO_FAULT_IN_NODE_OR_REMOTE_UNIT = 530;
    protected static final int ELIB_BC_VISUAL_STATE_M_ALARMS_SUPRESSED = 800;
    protected static final int ELIB_BC_VISUAL_STATE_M_ALARMS_SUPRESSED_END = 801;
    private final BlockingQueue myWorkQueue = new LinkedBlockingQueue(1000);
    private final Executor myBcCommunicationExecutor = new ThreadPoolExecutor(1, 1, 10L, TimeUnit.SECONDS, this.myWorkQueue);
    private static final int RECEIVE_TIMEOUT = 10000;

    public int getCurrentState() {
        return this.currentState;
    }

    private void setCurrentState(int state) {
        this.currentState = state;
    }

    public void setLEDVisualState(final int ledCommand) {
        logger.traceEnter(THIS_CLASS, "setLEDVisualState() ledCommand: " + ledCommand);
        this.myBcCommunicationExecutor.execute(new Runnable(){

            public void run() {
                try {
                    LEDProxyImpl.this.setLEDVisualStateInt(ledCommand);
                }
                catch (Exception e) {
                    logger.traceError(THIS_CLASS, "Failed to set visual state on DU LED's ", (Throwable)e);
                }
            }
        });
        logger.traceReturn(THIS_CLASS, "setLEDVisualState()");
    }

    protected void setLEDVisualStateInt(int ledCommand) throws RbsConfigurationFailedException, SignalException {
        logger.traceEnter(THIS_CLASS, "setLEDVisualStateInt() ledCommand:" + ledCommand);
        OseProcess bcServerProcess = this.huntForBcServer();
        this.connectToBcServer(bcServerProcess);
        this.setVisualState(this.translateLedCommandToElibVisualStateConstant(ledCommand), bcServerProcess);
        this.setCurrentState(ledCommand);
        logger.traceReturn(THIS_CLASS, "setLEDVisualStateInt()");
    }

    private int translateLedCommandToElibVisualStateConstant(int ledCommand) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "translateLedCommandToElibVisualStateConstant() ledCommand:" + ledCommand);
        int visualState = -1;
        if (ledCommand == 1) {
            visualState = 272;
        } else if (ledCommand == 3) {
            visualState = 273;
        } else if (ledCommand == 7) {
            visualState = 784;
        } else if (ledCommand == 9) {
            visualState = 785;
        } else if (ledCommand == 6) {
            visualState = 1040;
        } else if (ledCommand == 10) {
            visualState = 1041;
        } else {
            String msg = "Unsupported LED command:" + ledCommand;
            logger.traceError(THIS_CLASS, msg);
            throw new RbsConfigurationFailedException(msg);
        }
        logger.traceReturn(THIS_CLASS, "translateLedCommandToElibVisualStateConstant() visualState:" + visualState);
        return visualState;
    }

    private OseProcess huntForBcServer() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "huntForBcServer() BcServer");
        OseProcess bcServerProcess = OseProcess.hunt((String)ELIB_BC_CONTROLLER_NAME);
        if (bcServerProcess == null) {
            String msg = "Failed to hunt for BcServer";
            logger.traceError(THIS_CLASS, "Failed to hunt for BcServer");
            throw new RbsConfigurationFailedException("Failed to hunt for BcServer");
        }
        logger.traceReturn(THIS_CLASS, "huntForBcServer()");
        return bcServerProcess;
    }

    private void connectToBcServer(OseProcess bcServerProcess) throws SignalException {
        logger.traceEnter(THIS_CLASS, "connectToBcServer()");
        OseSenderReceiver oseSenderReceiver = OseSenderReceiverFactoryFactory.getOseSenderReceiverFactory().getOseSenderReceiver();
        BcServerConnEstablishReqSignal connectReq = new BcServerConnEstablishReqSignal();
        oseSenderReceiver.sendSignal(ThisProcess.getThisProcess(), bcServerProcess, (Signal)connectReq);
        SignalRegistry sigRegistry = new SignalRegistry();
        sigRegistry.add(BcServerConnEstablishCfmSignal.class);
        sigRegistry.add(BcServerConnEstablishRejSignal.class);
        InSignal receivedSignal = oseSenderReceiver.receiveSignal(sigRegistry, 10000);
        if (receivedSignal == null) {
            throw new SignalException("Failed to connect to BcServer, no answer");
        }
        if (receivedSignal instanceof BcServerConnEstablishRejSignal) {
            BcServerConnEstablishRejSignal connectRej = (BcServerConnEstablishRejSignal)receivedSignal;
            throw new SignalException("Failed to connect to BcServer, error code:" + connectRej.getErrorCode() + ", reject cause:" + connectRej.getRejectCause());
        }
        logger.traceReturn(THIS_CLASS, "connectToBcServer()");
    }

    private void setVisualState(int ledCommand, OseProcess bcServerProcess) throws SignalException {
        logger.traceEnter(THIS_CLASS, "setVisualState() " + ledCommand);
        OseSenderReceiver oseSenderReceiver = OseSenderReceiverFactoryFactory.getOseSenderReceiverFactory().getOseSenderReceiver();
        BcServerSetVisualIndicationReqSignal setVisualReq = new BcServerSetVisualIndicationReqSignal(ledCommand);
        oseSenderReceiver.sendSignal(ThisProcess.getThisProcess(), bcServerProcess, (Signal)setVisualReq);
        SignalRegistry sigRegistry = new SignalRegistry();
        sigRegistry.add(BcServerSetVisualIndicationCfmSignal.class);
        sigRegistry.add(BcServerSetVisualIndicationRejSignal.class);
        InSignal receivedSignal = oseSenderReceiver.receiveSignal(sigRegistry, 10000);
        if (receivedSignal == null) {
            throw new SignalException("Failed to set visual state, no answer");
        }
        if (receivedSignal instanceof BcServerSetVisualIndicationRejSignal) {
            BcServerSetVisualIndicationRejSignal setVisualRej = (BcServerSetVisualIndicationRejSignal)receivedSignal;
            throw new SignalException("Failed to set visual state, error code:" + setVisualRej.getErrorCode() + ", reject cause:" + setVisualRej.getRejectCause());
        }
        logger.traceReturn(THIS_CLASS, "setVisualState()");
    }
}

