/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.common.ArrayHelper;
import se.ericsson.crbs.cat.common.FileHelper;
import se.ericsson.crbs.cat.common.StringHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationReportHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLogger;
import se.ericsson.crbs.common.DateTimeHelper;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class RbsConfigurationReportLoggerImpl
implements RbsConfigurationReportLogger {
    public static final Object MUTEX_OBJECT = new Object();
    private static final int MAX_ATTRIBUTE_SIZE = 65000;
    private static RbsConfigurationMao rbsConfiguration;
    private static final String NEW_LINE = "\n";
    private static final SimpleDateFormat sdf;
    private static final SimpleDateFormat sdfFile;
    private static RbsConfigurationReportLoggerImpl instance;
    private static final Class THIS_CLASS;
    private static final AbstractLogger logger;
    private final StringBuffer reportBuffer = new StringBuffer();
    private File reportFile = null;
    private RbsConfigurationHelper helper;
    private final LogEntryWriter logEntryWriter;
    private static final String BACKUP_EXTENSION = ".backup";
    private static final int INDEX_OF_BACKUP_FILE_TO_REMOVE = 1;
    protected static final int MAX_NUMBER_OF_BACKUP_FILES = 5;
    protected boolean attributFull = false;
    protected int configurationReportUpdateCounter = 0;

    private RbsConfigurationReportLoggerImpl() {
        Object attrObj = "0";
        try {
            attrObj = rbsConfiguration.getAttribute("configurationReportUpdateCounter");
            this.configurationReportUpdateCounter = Integer.parseInt(attrObj.toString());
        }
        catch (Exception e) {
            this.configurationReportUpdateCounter = 0;
        }
        this.logEntryWriter = new LogEntryWriter();
        this.logEntryWriter.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RbsConfigurationReportLoggerImpl getInstance() {
        logger.traceEnter(THIS_CLASS, "getInstance()");
        Class clazz = THIS_CLASS;
        synchronized (clazz) {
            if (instance == null) {
                instance = new RbsConfigurationReportLoggerImpl();
            }
        }
        logger.traceReturn(THIS_CLASS, "getInstance() = " + instance);
        return instance;
    }

    public void stop() {
        this.logEntryWriter.stopIt();
    }

    public void finishAndSaveReportFile(boolean cancelAction) {
        logger.traceEnter(THIS_CLASS, "finishAndSaveReportFile()");
        if (this.reportFile.exists() || cancelAction) {
            this.flushLogEntryBufferToFile();
            String newFileName = "true".equalsIgnoreCase(System.getProperty("UNIT_TEST", "false")) ? RbsConfigurationReportHelper.dirName + "reportFile_" + this.getFileTimeStamp() + ".log" : this.helper.getLogDirPath() + "reportFile_" + this.getFileTimeStamp() + ".log";
            boolean success = this.reportFile.renameTo(new File(newFileName));
            if (success) {
                logger.traceDebug(THIS_CLASS, "Renamed report file, " + this.reportFile.getPath() + ", to " + newFileName + ".");
            } else {
                logger.traceDebug(THIS_CLASS, "Failed to rename report file, " + this.reportFile.getPath() + ".");
            }
        }
        logger.traceReturn(THIS_CLASS, "finishAndSaveReportFile()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getFileTimeStamp() {
        Class clazz = THIS_CLASS;
        synchronized (clazz) {
            return DateTimeHelper.dateToString((long)System.currentTimeMillis(), (SimpleDateFormat)sdfFile);
        }
    }

    protected StringBuffer getReport(Coordinator coordinator) {
        String report = "";
        try {
            report = (String)rbsConfiguration.getAttribute("configurationReport", coordinator);
        }
        catch (MoAccessException mae) {
            logger.traceError(THIS_CLASS, "getReport():  Exception while fetching attribute configurationReport in the MO " + rbsConfiguration.getType(), (Throwable)mae);
        }
        return new StringBuffer(report);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StringBuffer getTimeStamp() {
        Class clazz = THIS_CLASS;
        synchronized (clazz) {
            return this.padString(DateTimeHelper.dateToString((long)System.currentTimeMillis(), (SimpleDateFormat)sdf), 25);
        }
    }

    public void init(RbsConfigurationMao aRbsConfiguration) {
        logger.traceEnter(THIS_CLASS, "init(rbsConfiguration) - " + rbsConfiguration);
        rbsConfiguration = aRbsConfiguration;
        this.attributFull = false;
        this.helper = (RbsConfigurationHelper)rbsConfiguration.getRbsConfigurationContext().getHelper(RbsConfigurationHelper.class);
        this.reportFile = "true".equalsIgnoreCase(System.getProperty("UNIT_TEST", "false")) ? new File(RbsConfigurationReportHelper.dirName + "configurationReport.log") : new File(this.helper.getLogDirPath() + "configurationReport.log");
        logger.traceReturn(THIS_CLASS, "init(rbsConfiguration)");
    }

    public void initiateConfigurationReport() {
        logger.traceEnter(THIS_CLASS, "initiateConfigurationReport()");
        this.attributFull = false;
        StringBuffer report = this.getReport(null);
        if ("".equals(report.toString())) {
            report.append(NEW_LINE);
            report.append(this.padString("Time Stamp", 25));
            report.append(this.padString("Attr. Name", 47));
            report.append("Attr. Value");
            report.append(NEW_LINE);
            report.append(NEW_LINE);
            this.saveLogEntry(report);
        }
        logger.traceReturn(THIS_CLASS, "initiateConfigurationReport()");
    }

    public void logAction(String moType, String action, String attributes, String attributeValues) {
        logger.traceDebug(THIS_CLASS, "logAction() action: " + action + " on " + moType);
        StringBuffer logEntry = new StringBuffer();
        logEntry.append(this.getTimeStamp());
        logEntry.append(this.padString(moType + ":" + action, 47));
        if (!"".equals(attributes)) {
            logEntry.append("Attributes: ").append(attributes);
            logEntry.append(NEW_LINE);
            logEntry.append(this.padString("", 72));
            logEntry.append("Values:     ").append(attributeValues);
        }
        logEntry.append(NEW_LINE);
        this.saveLogEntry(logEntry);
    }

    public void logAction(String moType, String action, String[] attributes, Object[] attributeValues) {
        logger.traceDebug(THIS_CLASS, "logAction([]) action: " + action + " on " + moType);
        StringBuffer logEntry = new StringBuffer(32);
        logEntry.append(this.getTimeStamp());
        logEntry.append(this.padString(moType + ":" + action, 47));
        logEntry.append("<- Attribute = Value ->");
        logEntry.append(NEW_LINE);
        for (int index = 0; index < attributes.length && index < attributeValues.length; ++index) {
            logEntry.append(this.padString("", 72));
            this.appendAttribute(logEntry, attributes[index], attributeValues[index]);
            logEntry.append(NEW_LINE);
        }
        this.saveLogEntry(logEntry);
    }

    public void logAttribute(String moType, String attributeName, Object attributeValue) {
        logger.traceDebug(THIS_CLASS, "logging without coordinator");
        this.logAttribute(moType, attributeName, attributeValue, null);
    }

    public void logAttribute(String moType, String attributeName, Object attributeValue, Coordinator coordinator) {
        logger.traceDebug(THIS_CLASS, "logAttribute() attribute " + attributeName + " on " + moType);
        StringBuffer logEntry = new StringBuffer();
        logEntry.append(this.getTimeStamp());
        logEntry.append(this.padString(moType, 47));
        this.appendAttribute(logEntry, attributeName, attributeValue);
        logEntry.append(NEW_LINE);
        this.saveLogEntry(logEntry);
    }

    public void logAttributes(String moType, String[] attributeNames, Object[] attributeValues) {
        logger.traceDebug(THIS_CLASS, "logAttributes() attributes on " + moType);
        StringBuffer logEntry = new StringBuffer(32);
        logEntry.append(this.getTimeStamp());
        logEntry.append(this.padString(moType + ":", 47));
        logEntry.append("<- Attribute = Value ->");
        logEntry.append(NEW_LINE);
        for (int index = 0; index < attributeNames.length && index < attributeValues.length; ++index) {
            logEntry.append(this.padString("", 72));
            this.appendAttribute(logEntry, attributeNames[index], attributeValues[index]);
            logEntry.append(NEW_LINE);
        }
        this.saveLogEntry(logEntry);
    }

    public void logFailure(String failureSlogan, String failureDescr) {
        logger.traceDebug(THIS_CLASS, "logging without coordinator");
        this.logFailure(failureSlogan, failureDescr, null);
    }

    public void logFailure(String failureSlogan, String failureDescr, Coordinator coordinator) {
        logger.traceDebug(THIS_CLASS, "logFailure() - " + failureSlogan + " : " + failureDescr);
        if ("".equals(failureSlogan) && "".equals(failureDescr)) {
            logger.traceDebug(THIS_CLASS, "Fault reason resetted.");
        } else {
            StringBuffer logEntry = new StringBuffer();
            logEntry.append(this.padString("", 112, '-'));
            logEntry.append(NEW_LINE);
            logEntry.append(this.getTimeStamp());
            logEntry.append(this.padString(failureSlogan, 47));
            logEntry.append(failureDescr);
            logEntry.append(NEW_LINE);
            this.saveLogEntry(logEntry);
        }
    }

    public void logInformation(String informationSlogan, String information) {
        logger.traceDebug(THIS_CLASS, "logInformation() - " + informationSlogan + " : " + information);
        StringBuffer logEntry = new StringBuffer();
        logEntry.append(NEW_LINE);
        logEntry.append(this.getTimeStamp());
        logEntry.append(this.padString(informationSlogan, 47));
        logEntry.append(information);
        logEntry.append(NEW_LINE);
        this.saveLogEntry(logEntry);
    }

    public void logInformation(String informationSlogan, String information, Coordinator coordinator) {
        logger.traceDebug(THIS_CLASS, "logInformation() - " + informationSlogan + " : " + information);
        StringBuffer logEntry = new StringBuffer();
        logEntry.append(NEW_LINE);
        logEntry.append(this.getTimeStamp());
        logEntry.append(this.padString(informationSlogan, 47));
        logEntry.append(information);
        logEntry.append(NEW_LINE);
        this.saveLogEntry(logEntry);
    }

    private void appendAttribute(StringBuffer logEntry, String attributeName, Object attributeValue) {
        if (!logEntry.toString().endsWith(" ")) {
            logEntry.append(' ');
        }
        if (attributeValue == null) {
            logEntry.append(attributeName);
            logEntry.append(" = <EMPTY>");
        } else if (attributeValue instanceof Struct) {
            this.apppendStructAttribute(logEntry, attributeName, (Struct)attributeValue);
        } else if (attributeValue.getClass().isArray()) {
            this.appendArrayAttribute(logEntry, attributeName, attributeValue);
        } else if (attributeValue instanceof ManagedObject) {
            logEntry.append(attributeName);
            logEntry.append(" = ");
            logEntry.append(((ManagedObject)attributeValue).getLocalDistinguishedName());
        } else {
            logEntry.append(attributeName);
            logEntry.append(" = ");
            logEntry.append(attributeValue);
        }
    }

    private void appendArrayAttribute(StringBuffer logEntry, String attributeName, Object arrayAttributeValue) {
        if (arrayAttributeValue instanceof int[]) {
            this.appendPrintableArrayToStringbuffer(logEntry, attributeName, ArrayHelper.convertToIntegerArray((int[])arrayAttributeValue));
        } else if (arrayAttributeValue instanceof boolean[]) {
            this.appendPrintableArrayToStringbuffer(logEntry, attributeName, ArrayHelper.convertToBooleanArray((boolean[])arrayAttributeValue));
        } else if (this.isIntegerBooleanOrStringArray(arrayAttributeValue) || this.isObjectArrayOfIntegerBooleanOrString(arrayAttributeValue)) {
            this.appendPrintableArrayToStringbuffer(logEntry, attributeName, (Object[])arrayAttributeValue);
        } else {
            this.appendComplexArrayAttribute(logEntry, attributeName, (Object[])arrayAttributeValue);
        }
    }

    private void appendComplexArrayAttribute(StringBuffer logEntry, String attributeName, Object[] objectArray) {
        String combinedName = attributeName + "[";
        for (int index = 0; index < objectArray.length; ++index) {
            if (index != 0) {
                logEntry.append(this.padString("", 72));
            }
            this.appendAttribute(logEntry, combinedName + index + ']', objectArray[index]);
            if (index == objectArray.length - 1) continue;
            logEntry.append(NEW_LINE);
        }
    }

    private void appendPrintableArrayToStringbuffer(StringBuffer logEntry, String attributName, Object[] printableArray) {
        logEntry.append(attributName);
        logEntry.append(" = ");
        for (int i = 0; i < printableArray.length; ++i) {
            logEntry.append(printableArray[i]);
            if (i == printableArray.length - 1) continue;
            logEntry.append(", ");
        }
    }

    private void apppendStructAttribute(StringBuffer logEntry, String attributeName, Struct structObject) {
        try {
            String[] structmemberNames = structObject.getNames();
            Object[] structmemberValues = structObject.getValues();
            for (int index = 0; index < structmemberNames.length; ++index) {
                String combinedName = attributeName + "." + structmemberNames[index];
                if (index != 0) {
                    logEntry.append(this.padString("", 72));
                }
                this.appendAttribute(logEntry, combinedName, structmemberValues[index]);
                if (index == structmemberNames.length - 1) continue;
                logEntry.append(NEW_LINE);
            }
        }
        catch (MoAccessException mnfe) {
            logEntry.append(attributeName).append("=Struct");
            logger.traceAbnormal(THIS_CLASS, "Exception caught while trying to traverse struct: " + attributeName);
        }
    }

    private boolean isIntegerBooleanOrStringArray(Object arrayAttributeValue) {
        boolean isIntegerBooleanOrStringArray = false;
        if (arrayAttributeValue instanceof Integer[] || arrayAttributeValue instanceof Boolean[] || arrayAttributeValue instanceof String[]) {
            isIntegerBooleanOrStringArray = true;
        }
        return isIntegerBooleanOrStringArray;
    }

    private boolean isObjectArrayOfIntegerBooleanOrString(Object arrayAttributeValue) {
        boolean isObjectArrayOfIntegerBooleanOrString = false;
        Object[] objectArrayAttributeValue = (Object[])arrayAttributeValue;
        if (objectArrayAttributeValue.length > 0 && objectArrayAttributeValue[0] instanceof Integer || objectArrayAttributeValue[0] instanceof Boolean || objectArrayAttributeValue[0] instanceof String) {
            isObjectArrayOfIntegerBooleanOrString = true;
        }
        return isObjectArrayOfIntegerBooleanOrString;
    }

    protected StringBuffer padString(String text, int requiredLength) {
        return this.padString(text, requiredLength, ' ');
    }

    protected StringBuffer padString(String text, int requiredLength, char fillChar) {
        StringBuffer str = new StringBuffer(text);
        int strLength = str.length();
        if (requiredLength > 0 && requiredLength > strLength) {
            for (int i = strLength; i < requiredLength; ++i) {
                str.append(fillChar);
            }
        }
        return str;
    }

    public void restoreConfigurationReport() {
        logger.traceEnter(THIS_CLASS, "restoreConfigurationReport()");
        try {
            File tmpFile = this.createRestoreReportFile();
            FileHelper.copyFile((File)tmpFile, (File)this.reportFile);
            StringBuffer reportAttribute = this.getReport(null);
            String firstPartOfReportFile = FileHelper.getInitialFileContents(this.reportFile, 65000L);
            String nlhFilePath = this.helper.getLocalPath() + "Nlh.xml";
            boolean nlhFileExists = new File(nlhFilePath).exists();
            if (nlhFileExists) {
                this.recreateFromFile(firstPartOfReportFile);
            } else if (!nlhFileExists && reportAttribute.length() > 0 && firstPartOfReportFile.indexOf(reportAttribute.toString()) == -1) {
                this.recreateFromAttribute(reportAttribute);
            } else {
                this.recreateFromFile(firstPartOfReportFile);
            }
            tmpFile.delete();
        }
        catch (FileNotFoundException fnfe) {
            logger.traceDebug(THIS_CLASS, "No old report file found for recovery.");
        }
        catch (IOException ioe) {
            logger.traceDebug(THIS_CLASS, "Could not open any old report file for recovery. Original exception: " + ioe.getLocalizedMessage());
        }
        catch (MoAccessException mae) {
            logger.traceAbnormal(THIS_CLASS, "Generic problem when trying to recover old report file. Original exception: " + mae.getVariablesAsString());
        }
        logger.traceReturn(THIS_CLASS, "restoreConfigurationReport()");
    }

    private void recreateFromAttribute(StringBuffer reportAttribute) throws IOException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "recreateFromAttribute()");
        String filePath = "true".equalsIgnoreCase(System.getProperty("UNIT_TEST", "false")) ? RbsConfigurationReportHelper.dirName + "reportFile_" + this.getFileTimeStamp() + BACKUP_EXTENSION : this.helper.getLogDirPath() + "reportFile_" + this.getFileTimeStamp() + BACKUP_EXTENSION;
        this.removeOldBackupFiles(false);
        FileHelper.copyFile((File)this.reportFile, (File)new File(filePath));
        FileHelper.writeToFile((String)this.reportFile.getAbsolutePath(), (String)reportAttribute.toString(), (boolean)false);
        String logString = "Report file is old or not complete. Report file backup created and then recreated with contents of attribute.";
        logger.traceDebug(THIS_CLASS, "Report file is old or not complete. Report file backup created and then recreated with contents of attribute.");
        logger.traceReturn(THIS_CLASS, "recreateFromAttribute()");
    }

    public void removeOldBackupFiles(boolean cleanUpAction) {
        logger.traceEnter(THIS_CLASS, "removeOldBackupFiles()");
        int numberOfNewestBackupFiles = 3;
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dirInput, String name) {
                return name.endsWith(RbsConfigurationReportLoggerImpl.BACKUP_EXTENSION);
            }
        };
        File[] backupFile = "true".equalsIgnoreCase(System.getProperty("UNIT_TEST", "false")) ? new File(RbsConfigurationReportHelper.dirName).listFiles(filter) : new File(this.helper.getLogDirPath()).listFiles(filter);
        if (backupFile == null) {
            return;
        }
        Arrays.sort(backupFile, new Comparator(){

            public int compare(Object f1, Object f2) {
                return ((File)f1).getName().compareTo(((File)f2).getName());
            }
        });
        if (cleanUpAction) {
            for (int i = 0; i < backupFile.length; ++i) {
                backupFile[i].delete();
            }
        } else if (backupFile.length >= 5) {
            for (int i = 1; i < backupFile.length - 3; ++i) {
                backupFile[i].delete();
            }
        }
        logger.traceReturn(THIS_CLASS, "removeOldBackupFiles()");
    }

    private void recreateFromFile(String firstPartOfReportFile) throws MoAccessException, IOException {
        if (firstPartOfReportFile.length() >= 65000) {
            StringBuffer exceededMessage = new StringBuffer();
            exceededMessage.append("......");
            exceededMessage.append(NEW_LINE);
            exceededMessage.append(this.getTimeStamp());
            exceededMessage.append(" : Configuration report too long. New log entries written to file (");
            exceededMessage.append(this.reportFile.getAbsolutePath());
            exceededMessage.append(") only.");
            int length = 65000 - exceededMessage.length() - 1;
            StringBuffer fullReport = new StringBuffer();
            fullReport.append(firstPartOfReportFile.substring(0, length));
            fullReport.append(exceededMessage);
            logger.traceAbnormal(THIS_CLASS, "Attribute configurationReport is too long and cannot be set. New log entries written to file (" + this.reportFile.getAbsolutePath() + ") only.");
            rbsConfiguration.setReadOnlyAttribute("configurationReport", fullReport.toString());
            this.attributFull = true;
        } else {
            rbsConfiguration.setReadOnlyAttribute("configurationReport", firstPartOfReportFile);
        }
    }

    private File createRestoreReportFile() {
        File tmpFile = new File(this.reportFile.getAbsoluteFile() + ".restore");
        if (tmpFile.exists()) {
            File newFile = new File(tmpFile.getParent(), tmpFile.getName() + "_" + this.getFileTimeStamp());
            boolean successful = tmpFile.renameTo(newFile);
            if (successful) {
                logger.traceAbnormal(THIS_CLASS, "File " + tmpFile.toString() + " should not exist. Renaming file to: " + newFile.getPath());
            } else {
                logger.traceAbnormal(THIS_CLASS, "File " + tmpFile.toString() + " should not exist. Failed to rename file.");
            }
        }
        this.reportFile.renameTo(tmpFile);
        this.reportFile.delete();
        return tmpFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveLogEntry(StringBuffer logEntry) {
        this.filterLogEntry(logEntry);
        Object object = MUTEX_OBJECT;
        synchronized (object) {
            if (null != logEntry) {
                this.reportBuffer.append(logEntry);
            }
        }
    }

    protected void filterLogEntry(StringBuffer logEntry) {
        String[] illegalCharacters = new String[]{"\u00a4", "|", "^", "'"};
        if (logEntry.indexOf("couldn't") != -1) {
            StringHelper.replaceInStringBuffer(logEntry, "couldn't", "could not");
        }
        for (int i = 0; i < illegalCharacters.length; ++i) {
            if (logEntry.indexOf(illegalCharacters[i]) == -1) continue;
            StringHelper.removeString((StringBuffer)logEntry, (String)illegalCharacters[i]);
        }
    }

    private void setConfigurationReportAttribute(StringBuffer copiedReportBuffer) {
        logger.traceEnter(THIS_CLASS, "setConfigurationReportAttribute()");
        if (this.attributFull) {
            logger.traceGeneral(THIS_CLASS, "Skipping set of \"configurationReport\" as attribute is already full");
        } else {
            try {
                StringBuffer reportToBeStoredInAttribute = this.getReport(null);
                reportToBeStoredInAttribute.append(copiedReportBuffer);
                if (reportToBeStoredInAttribute.length() >= 65000) {
                    StringBuffer anotherCopyOfTheReport = new StringBuffer();
                    anotherCopyOfTheReport.append(reportToBeStoredInAttribute);
                    reportToBeStoredInAttribute.setLength(0);
                    StringBuffer exceededMessage = new StringBuffer();
                    exceededMessage.append("......");
                    exceededMessage.append(NEW_LINE);
                    exceededMessage.append(this.getTimeStamp());
                    exceededMessage.append(" : Configuration report too long. New log entries written to file (");
                    exceededMessage.append(this.reportFile.getAbsolutePath());
                    exceededMessage.append(") only.");
                    int maxLength = 65000 - exceededMessage.length() - 1;
                    reportToBeStoredInAttribute.append(anotherCopyOfTheReport.substring(0, maxLength));
                    reportToBeStoredInAttribute.append(exceededMessage);
                    logger.traceAbnormal(THIS_CLASS, "Attribute configurationReport is too long and cannot be set. New log entries written to file (" + this.reportFile.getAbsolutePath() + ") only.");
                    this.attributFull = true;
                }
                rbsConfiguration.setReadOnlyAttribute("configurationReport", reportToBeStoredInAttribute.toString());
                ++this.configurationReportUpdateCounter;
                rbsConfiguration.setReadOnlyAttribute("configurationReportUpdateCounter", new Integer(this.configurationReportUpdateCounter));
            }
            catch (MoAccessException mae) {
                logger.traceAbnormal(THIS_CLASS, "Could not save the attribute configurationReport due to exception: " + mae.getVariablesAsString());
            }
        }
        logger.traceReturn(THIS_CLASS, "setConfigurationReportAttribute()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushLogEntryBufferToFile() {
        Object object = MUTEX_OBJECT;
        synchronized (object) {
            MUTEX_OBJECT.notifyAll();
        }
    }

    static {
        sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.ENGLISH);
        sdfFile = new SimpleDateFormat("yyyy-MM-dd_HHmmss", Locale.ENGLISH);
        instance = null;
        THIS_CLASS = RbsConfigurationReportLoggerImpl.class;
        logger = LoggingService.getLogger((String)RbsConfigurationReportLoggerImpl.class.getName());
    }

    private class LogEntryWriter
    extends Thread {
        private volatile boolean keepRunning;

        public LogEntryWriter() {
            super("RbsConfiguration_LogEntryWritingThread");
            this.keepRunning = true;
        }

        public void stopIt() {
            this.keepRunning = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            StringBuffer copiedReportBuffer = new StringBuffer();
            while (this.keepRunning) {
                try {
                    Object object = MUTEX_OBJECT;
                    synchronized (object) {
                        MUTEX_OBJECT.wait(2000L);
                        copiedReportBuffer.append(RbsConfigurationReportLoggerImpl.this.reportBuffer);
                        RbsConfigurationReportLoggerImpl.this.reportBuffer.setLength(0);
                    }
                    int length = copiedReportBuffer.length();
                    if (length <= 0) continue;
                    FileHelper.writeToFile((String)RbsConfigurationReportLoggerImpl.this.reportFile.getAbsolutePath(), (String)copiedReportBuffer.toString(), (boolean)RbsConfigurationReportLoggerImpl.this.reportFile.exists());
                    RbsConfigurationReportLoggerImpl.this.setConfigurationReportAttribute(copiedReportBuffer);
                    copiedReportBuffer.setLength(0);
                    Object object2 = MUTEX_OBJECT;
                    synchronized (object2) {
                        MUTEX_OBJECT.notifyAll();
                    }
                }
                catch (Exception e) {
                    logger.traceAbnormal(THIS_CLASS, ExceptionHelper.appendReason((String)"Failed to write buffered log entries", (Throwable)e));
                }
            }
        }
    }
}

