/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.rollback;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.common.xml.XmlPack;
import se.ericsson.crbs.cat.mao.rbsconfiguration.rollback.AbstractRollbackStackAttributeItem;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.common.LdnHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.wrappers.MoFactoryMgrWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class CreateRollbackStackItem
extends AbstractRollbackStackAttributeItem {
    private static final Class THIS_CLASS = CreateRollbackStackItem.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final MoFactoryMgrWrapper moFactoryMgrWrapper;

    public CreateRollbackStackItem(MoFactoryMgrWrapper moFactoryMgrWrapperIn, String ldn, String[] attributeNamesIn, Object[] attributeValuesIn) {
        super(ldn, attributeNamesIn, attributeValuesIn);
        this.moFactoryMgrWrapper = moFactoryMgrWrapperIn;
    }

    protected void packItem(Element topElement, XmlPack xmlpack, Document document) {
        Element typeElement = CreateRollbackStackItem.createTypeElement("create", this.getLdn(), document);
        boolean invalidAttrElement = false;
        String[] attributeNames = this.getAttributeNames();
        Object[] attributeValues = this.getAttributeValues();
        for (int i = 0; i < attributeNames.length; ++i) {
            Element attrElement = CreateRollbackStackItem.createAttrElement(xmlpack, attributeNames[i], attributeValues[i], document);
            if (attrElement == null) {
                invalidAttrElement = true;
                break;
            }
            typeElement.appendChild(attrElement);
        }
        if (!invalidAttrElement) {
            topElement.appendChild(typeElement);
        }
    }

    public boolean doRollback(MoRepositoryWrapper moRepositoryWrapper, Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "doRollback()");
        boolean result2 = false;
        String ldn = this.getLdn();
        String id = LdnHelper.getRdnAttributeValue((String)ldn);
        String moType = LdnHelper.getLastLdnElement((String)ldn);
        String parentLdn = this.getParentLdn(ldn);
        MoFactory factory = this.moFactoryMgrWrapper.lookup(moType);
        ManagedObject parent = moRepositoryWrapper.lookup(parentLdn);
        if (factory == null || parent == null) {
            this.logErrorMessage(ldn, factory, parent);
        } else {
            AttrListImpl attrList = new AttrListImpl();
            String[] attrNames = this.getAttributeNames();
            Object[] attrValues = this.getAttributeValues();
            for (int i = 0; i < attrNames.length; ++i) {
                attrList.addElement(attrNames[i], attrValues[i]);
            }
            try {
                factory.createMo(parent, (AttrList)attrList, id, null, coordinator);
                result2 = true;
            }
            catch (MoAccessException mae) {
                String errorMsg = "Exception when trying to create MO " + ldn + ". " + ExceptionHelper.getExceptionMessage((Throwable)mae);
                logger.traceError(THIS_CLASS, errorMsg, (Throwable)mae);
            }
        }
        logger.traceReturn(THIS_CLASS, "doRollback()");
        return result2;
    }

    private String getParentLdn(String ldn) {
        String rdnElement = LdnHelper.getLastLdnElement((String)ldn);
        int index = ldn.lastIndexOf(rdnElement) - 1;
        return ldn.substring(0, index);
    }

    private void logErrorMessage(String ldn, MoFactory factory, ManagedObject parent) {
        String reason = "";
        if (factory == null) {
            reason = "Factory not found.";
        } else if (parent == null) {
            reason = "Parent MO not found.";
        }
        String errorMsg = "Could not create MO " + ldn + ". " + reason;
        logger.traceAbnormal(THIS_CLASS, errorMsg);
    }

    public String getItemInfo() {
        return "Create of MO " + this.getLdn() + " with attributes " + this.getAttributeNames() + " and values " + this.getAttributeValues();
    }
}

