/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.rollback;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.common.xml.XmlPack;
import se.ericsson.crbs.cat.mao.rbsconfiguration.rollback.AbstractRollbackStackItem;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class DeleteRollbackStackItem
extends AbstractRollbackStackItem {
    private static final Class THIS_CLASS = DeleteRollbackStackItem.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public DeleteRollbackStackItem(String inLdn) {
        super(inLdn);
    }

    protected void packItem(Element topElement, XmlPack xmlpack, Document document) {
        Element typeElement = DeleteRollbackStackItem.createTypeElement("delete", this.getLdn(), document);
        topElement.appendChild(typeElement);
    }

    public boolean doRollback(MoRepositoryWrapper moRepositoryWrapper, Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "doRollback()");
        boolean result2 = true;
        String ldn = this.getLdn();
        ManagedObject mo = moRepositoryWrapper.lookup(ldn);
        if (mo == null) {
            String errorMsg = "Could not delete MO " + ldn + ". MO not found.";
            logger.traceAbnormal(THIS_CLASS, errorMsg);
        } else {
            try {
                mo.delete(coordinator);
            }
            catch (MoAccessException mae) {
                result2 = false;
                String errorMsg = "Exception when trying to delete MO " + ldn + ". " + mae.getMessage();
                logger.traceError(THIS_CLASS, errorMsg, (Throwable)mae);
            }
        }
        logger.traceReturn(THIS_CLASS, "doRollback()");
        return result2;
    }

    public String getItemInfo() {
        return "Delete of MO " + this.getLdn();
    }
}

