/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.rollback;

import java.io.IOException;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.SoftwareErrorException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Resource;
import se.ericsson.crbs.cat.common.xml.XmlPack;
import se.ericsson.crbs.cat.common.xml.XmlPackFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.rollback.AbstractRollbackStackItem;
import se.ericsson.crbs.cat.mao.rbsconfiguration.rollback.ActionRollbackStackItem;
import se.ericsson.crbs.cat.mao.rbsconfiguration.rollback.CreateRollbackStackItem;
import se.ericsson.crbs.cat.mao.rbsconfiguration.rollback.DeleteRollbackStackItem;
import se.ericsson.crbs.cat.mao.rbsconfiguration.rollback.RollbackResource;
import se.ericsson.crbs.cat.mao.rbsconfiguration.rollback.RollbackStack;
import se.ericsson.crbs.cat.mao.rbsconfiguration.rollback.RollbackStackXmlHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.rollback.SetRollbackStackItem;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class RollbackStackImpl
implements RollbackStack {
    protected static final String ROLLBACK = "rollback";
    protected static final String ROLLBACK_VERSION = "R1A";
    private static final Class THIS_CLASS = RollbackStackImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String persistantStorageAttributeName = "rollback";
    private final Stack theRollbackStack;
    private final Map transactionToRollbackResourceMap;
    private final RbsConfigurationMao rbsConfigurationMao;
    private final MoRepositoryWrapper moRepositoryWrapper;
    private static RollbackStackImpl instance;

    private RollbackStackImpl(RbsConfigurationMao inRbsConfigurationMao, MoRepositoryWrapper inMoRepositoryWrapper) {
        logger.traceEnter(THIS_CLASS, "");
        this.theRollbackStack = new Stack();
        this.transactionToRollbackResourceMap = new HashMap();
        this.rbsConfigurationMao = inRbsConfigurationMao;
        this.moRepositoryWrapper = inMoRepositoryWrapper;
        logger.traceReturn(THIS_CLASS, "");
    }

    private void initRollbackStack() {
        String xmlString = (String)this.rbsConfigurationMao.retrievePersistently("rollback");
        if (xmlString != null) {
            RollbackStackXmlHandler rollbackStackXmlHandler = new RollbackStackXmlHandler(this, this.moRepositoryWrapper, this.rbsConfigurationMao.getRbsConfigurationContext().getMoFactoryMgrWrapper());
            try {
                System.setProperty("org.xml.sax.driver", "org.apache.xerces.parsers.SAXParser");
                XMLReader xr = XMLReaderFactory.createXMLReader();
                xr.setContentHandler(rollbackStackXmlHandler);
                xr.setErrorHandler(rollbackStackXmlHandler);
                StringReader stringReader = new StringReader(xmlString);
                xr.parse(new InputSource(stringReader));
            }
            catch (SAXException saxe) {
                logger.traceAbnormal(THIS_CLASS, saxe.getMessage());
            }
            catch (IOException ioe) {
                logger.traceAbnormal(THIS_CLASS, ioe.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RollbackStack getInstance(RbsConfigurationMao inRbsConfigurationMao, MoRepositoryWrapper inMoRepositoryWrapper) {
        boolean newInstance = false;
        Class clazz = THIS_CLASS;
        synchronized (clazz) {
            if (instance == null) {
                instance = new RollbackStackImpl(inRbsConfigurationMao, inMoRepositoryWrapper);
                newInstance = true;
            }
        }
        if (newInstance) {
            instance.initRollbackStack();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RollbackStack getNewInstanceForBT(RbsConfigurationMao inRbsConfigurationMao, MoRepositoryWrapper inMoRepositoryWrapper) {
        Class clazz = THIS_CLASS;
        synchronized (clazz) {
            instance = new RollbackStackImpl(inRbsConfigurationMao, inMoRepositoryWrapper);
        }
        instance.initRollbackStack();
        return instance;
    }

    public void pushCreate(String ldn, String[] attributeNames, Object[] attributeValues, Coordinator coordinator) {
        int transactionId = coordinator.getTransactionID();
        RollbackResource rollbackResource = this.initRollbackResource(coordinator, transactionId, true);
        rollbackResource.add(new CreateRollbackStackItem(this.rbsConfigurationMao.getRbsConfigurationContext().getMoFactoryMgrWrapper(), ldn, attributeNames, attributeValues));
    }

    public void pushSet(String ldn, String[] attributeNames, Object[] attributeValues, Coordinator coordinator) {
        int transactionId = coordinator.getTransactionID();
        RollbackResource rollbackResource = this.initRollbackResource(coordinator, transactionId, true);
        rollbackResource.add(new SetRollbackStackItem(ldn, attributeNames, attributeValues));
    }

    public void pushAction(String ldn, String actionName, String[] attributeNames, Object[] attributeValues, Coordinator coordinator) {
        int transactionId = coordinator.getTransactionID();
        RollbackResource rollbackResource = this.initRollbackResource(coordinator, transactionId, true);
        rollbackResource.add(new ActionRollbackStackItem(ldn, actionName, attributeNames, attributeValues));
    }

    public void pushDelete(String ldn, Coordinator coordinator) {
        int transactionId = coordinator.getTransactionID();
        RollbackResource rollbackResource = this.initRollbackResource(coordinator, transactionId, true);
        rollbackResource.add(new DeleteRollbackStackItem(ldn));
    }

    public boolean isEmpty() {
        return this.theRollbackStack.isEmpty();
    }

    private RollbackResource initRollbackResource(Coordinator coordinator, int transactionId, boolean pushRollbackResource) {
        RollbackResource rollbackResource;
        if (this.rollbackResourceExist(transactionId)) {
            rollbackResource = this.getRollbackResource(transactionId);
        } else {
            rollbackResource = new RollbackResource(this, transactionId, pushRollbackResource);
            try {
                coordinator.registerResource((Resource)rollbackResource);
                this.addRollbackResource(transactionId, rollbackResource);
            }
            catch (InactiveTransactionException e) {
                logger.traceError(THIS_CLASS, e.getMessage());
            }
        }
        return rollbackResource;
    }

    private void addRollbackResource(int transactionId, RollbackResource rollbackResource) {
        this.transactionToRollbackResourceMap.put(new Integer(transactionId), rollbackResource);
    }

    private boolean rollbackResourceExist(int transactionId) {
        return this.transactionToRollbackResourceMap.containsKey(new Integer(transactionId));
    }

    private void removeRollbackResource(int transactionId) {
        this.transactionToRollbackResourceMap.remove(new Integer(transactionId));
    }

    private RollbackResource getRollbackResource(int transactionId) {
        return (RollbackResource)this.transactionToRollbackResourceMap.get(new Integer(transactionId));
    }

    public AbstractRollbackStackItem popNextRollbackItem(Coordinator coordinator) {
        int transactionId = coordinator.getTransactionID();
        RollbackResource rollbackResource = this.initRollbackResource(coordinator, transactionId, false);
        AbstractRollbackStackItem rollbackStackItem = null;
        if (!this.theRollbackStack.empty()) {
            rollbackStackItem = (AbstractRollbackStackItem)this.theRollbackStack.pop();
            rollbackResource.add(rollbackStackItem);
        }
        return rollbackStackItem;
    }

    protected void pushRollbackStackItem(AbstractRollbackStackItem rollbackStackItem) {
        this.theRollbackStack.push(rollbackStackItem);
    }

    protected void commit(int transactionId) {
        String tmpString = this.generatePersistantXmlFromStack();
        try {
            this.rbsConfigurationMao.storePersistently("rollback", tmpString);
        }
        catch (MoAccessException e) {
            logger.traceAbnormal(THIS_CLASS, e.getMessage());
        }
        this.removeRollbackResource(transactionId);
    }

    private String generatePersistantXmlFromStack() {
        Enumeration enumeration = this.theRollbackStack.elements();
        XmlPack xmlPack = XmlPackFactory.getXmlPack();
        Document document = xmlPack.createDocument();
        Element topElement = document.createElement("rollback");
        topElement.setAttribute("version", ROLLBACK_VERSION);
        document.appendChild(topElement);
        while (enumeration.hasMoreElements()) {
            AbstractRollbackStackItem rollbackStackItem = (AbstractRollbackStackItem)enumeration.nextElement();
            rollbackStackItem.packItem(topElement, xmlPack, document);
        }
        String xmlString = null;
        try {
            xmlString = xmlPack.transformDocument(document);
        }
        catch (SoftwareErrorException e) {
            logger.traceError(THIS_CLASS, e.getMessage());
        }
        return xmlString;
    }

    public void clearStack() {
        this.theRollbackStack.clear();
        this.transactionToRollbackResourceMap.clear();
        String tmpString = this.generatePersistantXmlFromStack();
        try {
            this.rbsConfigurationMao.storePersistently("rollback", tmpString);
        }
        catch (MoAccessException e) {
            logger.traceAbnormal(THIS_CLASS, e.getMessage());
        }
    }
}

