/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.rollback;

import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.support.servloc.ServiceRepository;
import se.ericsson.crbs.cat.common.xml.ArrayCreator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.rollback.AbstractRollbackStackAttributeItem;
import se.ericsson.crbs.cat.mao.rbsconfiguration.rollback.AbstractRollbackStackItem;
import se.ericsson.crbs.cat.mao.rbsconfiguration.rollback.ActionRollbackStackItem;
import se.ericsson.crbs.cat.mao.rbsconfiguration.rollback.CreateRollbackStackItem;
import se.ericsson.crbs.cat.mao.rbsconfiguration.rollback.DeleteRollbackStackItem;
import se.ericsson.crbs.cat.mao.rbsconfiguration.rollback.RollbackStackImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.rollback.SetRollbackStackItem;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonif.LdnFinder;
import se.ericsson.crbs.omf.mao.commonmo.StructImpl;
import se.ericsson.crbs.omf.mao.genericmo.xml.MoRefParameter;
import se.ericsson.crbs.omf.mao.wrappers.MoFactoryMgrWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class RollbackStackXmlHandler
extends DefaultHandler {
    private static final Class THIS_CLASS = RollbackStackXmlHandler.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final RollbackStackImpl rollbackStack;
    private final MoRepositoryWrapper moRepositoryWrapper;
    private final MoFactoryMgrWrapper moFactoryMgrWrapper;
    private AbstractRollbackStackItem abstractRollbackStackItem;
    private final transient Stack attributeStackName = new Stack();
    private final transient Stack attributeStackType = new Stack();
    private final transient Stack attributeStackValue = new Stack();
    private boolean insideStruct = false;
    private boolean insideArray = false;
    private boolean insideMoRef = false;

    public RollbackStackXmlHandler(RollbackStackImpl inRollbackStack, MoRepositoryWrapper inMoRepositoryWrapper, MoFactoryMgrWrapper inMoFactoryMgrWrapper) {
        this.rollbackStack = inRollbackStack;
        this.moRepositoryWrapper = inMoRepositoryWrapper;
        this.moFactoryMgrWrapper = inMoFactoryMgrWrapper;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
        String msg = "startElement";
        logger.traceEnter(THIS_CLASS, "startElement");
        this.handleVersion(qName, attributes);
        this.handleCreate(qName, attributes);
        this.handleSet(qName, attributes);
        this.handleAction(qName, attributes);
        this.handleDelete(qName, attributes);
        this.storeAttrType(qName, attributes);
        this.storeS32Type(qName, attributes);
        this.storeS64Type(qName, attributes);
        this.storeBooleanType(qName, attributes);
        this.storeStringType(qName, attributes);
        this.storeStructType(qName, attributes);
        this.storeArrayType(qName, attributes);
        this.storeMoRefType(qName, attributes);
        logger.traceReturn(this.getClass(), "startElement");
    }

    private void handleVersion(String qName, Attributes attributes) {
        if ("rollback".equalsIgnoreCase(qName) && !"R1A".equalsIgnoreCase(attributes.getValue("version"))) {
            logger.traceAbnormal(THIS_CLASS, "Inconsistent rollback versions, Executing: R1A Persistent storage: " + attributes.getValue("version"));
        }
    }

    private void handleDelete(String qName, Attributes attributes) {
        if ("delete".equals(qName)) {
            this.attributeStackType.clear();
            this.abstractRollbackStackItem = new DeleteRollbackStackItem(attributes.getValue("ldn"));
        }
    }

    private void handleAction(String qName, Attributes attributes) {
        if ("action".equals(qName)) {
            this.attributeStackType.clear();
            this.abstractRollbackStackItem = new ActionRollbackStackItem(attributes.getValue("ldn"), attributes.getValue("actionName"), null, null);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        String msg = "endElement";
        logger.traceEnter(THIS_CLASS, "endElement");
        if (this.isQNameSupportedOperation(qName)) {
            this.rollbackStack.pushRollbackStackItem(this.abstractRollbackStackItem);
        } else if (this.isQNameSupportedType(qName)) {
            this.resetClassVariables(qName);
            if (this.attributeStackValue.isEmpty()) {
                String errMsg = "Attribute stack is empty at end of element: " + qName;
                logger.traceAbnormal(THIS_CLASS, errMsg);
                return;
            }
            String attrName = (String)this.attributeStackName.pop();
            Object attrValue = this.getAttributeValue();
            this.handleAttributeValue(attrName, attrValue);
        }
        logger.traceReturn(THIS_CLASS, "endElement");
    }

    private boolean isQNameSupportedOperation(String qName) {
        return "create".equalsIgnoreCase(qName) || "set".equalsIgnoreCase(qName) || "delete".equalsIgnoreCase(qName) || "action".equalsIgnoreCase(qName);
    }

    private void storeMoRefType(String qName, Attributes attributes) {
        if ("moref".equalsIgnoreCase(qName)) {
            String attrName = attributes.getValue("name");
            MoRefParameter moRefParameter = new MoRefParameter(attrName == null ? "moref" : attrName);
            this.pushNameTypeValue(attrName, "moref", moRefParameter);
            this.insideMoRef = true;
        }
    }

    private void storeArrayType(String qName, Attributes attributes) {
        if ("array".equalsIgnoreCase(qName)) {
            this.pushNameTypeValue(attributes.getValue("name"), "array", new ArrayCreator());
            this.insideArray = true;
        }
    }

    private void storeStructType(String qName, Attributes attributes) {
        if ("struct".equalsIgnoreCase(qName)) {
            this.pushNameTypeValue(attributes.getValue("name") == null ? "struct" : attributes.getValue("name"), "struct", new StructImpl());
            this.insideStruct = true;
        }
    }

    private void storeStringType(String qName, Attributes attributes) {
        if ("string".equalsIgnoreCase(qName)) {
            this.pushNameTypeValue(attributes.getValue("name"), "string", attributes.getValue("value"));
        }
    }

    private void storeBooleanType(String qName, Attributes attributes) {
        if ("boolean".equalsIgnoreCase(qName)) {
            this.pushNameTypeValue(attributes.getValue("name"), "boolean", attributes.getValue("value"));
        }
    }

    private void storeS64Type(String qName, Attributes attributes) {
        if ("s64".equalsIgnoreCase(qName)) {
            this.pushNameTypeValue(attributes.getValue("name"), "s64", attributes.getValue("value"));
        }
    }

    private void storeS32Type(String qName, Attributes attributes) {
        if ("s32".equalsIgnoreCase(qName)) {
            this.pushNameTypeValue(attributes.getValue("name"), "s32", attributes.getValue("value"));
        }
    }

    private void storeAttrType(String qName, Attributes attributes) {
        if ("attr".equalsIgnoreCase(qName)) {
            this.pushNameTypeValue(attributes.getValue("name"), attributes.getValue("type"), attributes.getValue("value"));
        }
    }

    private void pushNameTypeValue(String attrName, String attrType, Object attrValue) {
        this.attributeStackName.push(attrName);
        if ("s32".equalsIgnoreCase(attrType)) {
            this.attributeStackValue.push(new Integer(Integer.parseInt(attrValue.toString())));
        } else if ("s64".equalsIgnoreCase(attrType)) {
            this.attributeStackValue.push(new Long(Long.parseLong(attrValue.toString())));
        } else if ("boolean".equalsIgnoreCase(attrType)) {
            this.attributeStackValue.push(Boolean.valueOf(attrValue.toString()));
        } else {
            this.attributeStackValue.push(attrValue);
        }
        if (!(this.insideArray || this.insideStruct || this.insideMoRef)) {
            this.attributeStackType.push(attrType);
        }
    }

    private void handleSet(String qName, Attributes attributes) {
        if ("set".equals(qName)) {
            this.attributeStackType.clear();
            this.abstractRollbackStackItem = new SetRollbackStackItem(attributes.getValue("ldn"), null, null);
        }
    }

    private void handleCreate(String qName, Attributes attributes) {
        if ("create".equals(qName)) {
            this.attributeStackType.clear();
            this.abstractRollbackStackItem = new CreateRollbackStackItem(this.moFactoryMgrWrapper, attributes.getValue("ldn"), null, null);
        }
    }

    private Object getAttributeValue() throws SAXException {
        Object attrValue = this.attributeStackValue.pop();
        if (attrValue instanceof MoRefParameter) {
            try {
                attrValue = this.convertMoRefParameterToMo((MoRefParameter)attrValue);
            }
            catch (MoNotFoundException moNotFoundException) {
                throw new SAXException("The referenced MO could not be found using FroType and FroId", (Exception)((Object)moNotFoundException));
            }
        }
        return attrValue;
    }

    private void handleAttributeValue(String attrName, Object attrValue) throws SAXException {
        if (this.attributeStackValue.isEmpty()) {
            ((AbstractRollbackStackAttributeItem)this.abstractRollbackStackItem).addAttribute(attrName, attrValue);
            String genMsg = "Attribute " + attrName + " added to attribute list.";
            logger.traceGeneral(THIS_CLASS, genMsg);
        } else {
            this.addCurrEltToCompositeParentElt(attrName, attrValue);
        }
    }

    private void addCurrEltToCompositeParentElt(String name, Object value) throws SAXException {
        Object parent = this.attributeStackValue.peek();
        if (parent instanceof StructImpl) {
            ((StructImpl)parent).addElement(name, value);
        } else if (parent instanceof ArrayCreator) {
            ((ArrayCreator)parent).addElement(value);
        } else if (parent instanceof MoRefParameter) {
            this.handleEndElementForMoRef(name, value, parent);
        }
    }

    private void handleEndElementForMoRef(String name, Object value, Object parent) {
        MoRefParameter moRefParameter = (MoRefParameter)parent;
        if ("ldn".equalsIgnoreCase(name)) {
            moRefParameter.setLdn((String)value);
        } else if ("froType".equalsIgnoreCase(name)) {
            moRefParameter.setFroType(((Integer)value).intValue());
        } else if ("froId".equalsIgnoreCase(name)) {
            moRefParameter.setFroId(((Integer)value).intValue());
        }
    }

    private boolean isQNameSupportedType(String qName) {
        return "s32".equals(qName) || "s64".equals(qName) || "string".equals(qName) || "array".equals(qName) || "struct".equals(qName) || "moref".equals(qName) || "boolean".equals(qName) || "attr".equals(qName);
    }

    private ManagedObject convertMoRefParameterToMo(MoRefParameter attrValue) throws MoNotFoundException {
        ManagedObject result2;
        String ldn = attrValue.getLdn();
        if (ldn == null) {
            ServiceRepository serviceRepository = ServiceLocatorFacade.getRepository();
            LdnFinder ldnFinder = (LdnFinder)serviceRepository.getService(LdnFinder.class);
            ldn = ldnFinder.getManagedObjectLdn((long)attrValue.getFroType(), (long)attrValue.getFroId());
        }
        if ((result2 = this.moRepositoryWrapper.lookup(ldn)) == null) {
            throw new MoNotFoundException("Could not find MO: " + ldn);
        }
        return result2;
    }

    private void resetClassVariables(String qName) {
        if (this.insideStruct && "struct".equals(qName)) {
            this.insideStruct = false;
        } else if (this.insideArray && "array".equals(qName)) {
            this.insideArray = false;
        } else if (this.insideMoRef && "moref".equals(qName)) {
            this.insideMoRef = false;
        }
    }
}

