/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class FileEncryptor {
    private static final Class THIS_CLASS = FileEncryptor.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final int keyLength = 16;
    private final int keyOffset = 2;
    private final String algorithm = "AES";

    private Cipher makeCipher(String password, int encryptMode) throws GeneralSecurityException, IOException {
        logger.traceEnter(THIS_CLASS, "makeCipher()");
        BouncyCastleProvider bcJce = new BouncyCastleProvider();
        Security.addProvider((Provider)bcJce);
        Provider[] providers = Security.getProviders();
        for (int i = 0; i < providers.length; ++i) {
            logger.traceDebug(THIS_CLASS, "JCE Provider found: " + providers[i].getName());
        }
        SecretKeySpec secretKey = new SecretKeySpec(this.getCopy(password.getBytes(), 2, 18), "AES");
        Cipher cipher = Cipher.getInstance("AES", (Provider)bcJce);
        cipher.init(encryptMode, secretKey);
        logger.traceReturn(THIS_CLASS, "makeCipher()");
        return cipher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encryptFile(String fileName, String password) throws GeneralSecurityException, IOException {
        logger.traceEnter(THIS_CLASS, "encryptFile(): " + fileName);
        File inFile = new File(fileName);
        Cipher cipher = this.makeCipher(password, 1);
        int blockSize = 8;
        int paddedCount = blockSize - (int)inFile.length() % blockSize;
        int padded = (int)inFile.length() + paddedCount;
        byte[] decData = new byte[padded];
        FileInputStream inStream = new FileInputStream(inFile);
        try {
            inStream.read(decData);
        }
        finally {
            inStream.close();
        }
        for (int i = (int)inFile.length(); i < padded; ++i) {
            decData[i] = (byte)paddedCount;
        }
        byte[] encData = cipher.doFinal(decData);
        FileOutputStream outStream = new FileOutputStream(fileName);
        try {
            outStream.write(encData);
        }
        finally {
            outStream.close();
        }
        logger.traceReturn(THIS_CLASS, "encryptFile()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decryptFile(String fileName, String password) throws GeneralSecurityException, IOException {
        logger.traceEnter(THIS_CLASS, "decryptFile(): " + fileName);
        File inFile = new File(fileName);
        Cipher cipher = this.makeCipher(password, 2);
        FileInputStream inStream = new FileInputStream(inFile);
        byte[] encData = new byte[(int)inFile.length()];
        try {
            inStream.read(encData);
        }
        finally {
            inStream.close();
        }
        byte[] decData = cipher.doFinal(encData);
        if (decData.length - 1 > 0) {
            byte padCount = decData[decData.length - 1];
            if (padCount >= 1 && padCount <= 8) {
                decData = this.getCopy(decData, 0, decData.length - padCount);
            }
            FileOutputStream target = new FileOutputStream(new File(fileName + "_decrypted"));
            try {
                target.write(decData);
            }
            finally {
                target.close();
            }
        }
        logger.traceReturn(THIS_CLASS, "decryptFile()");
    }

    private byte[] getCopy(byte[] original, int from, int to) {
        int newLength = to - from;
        int start = 0;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        int targetLength = original.length - from;
        byte[] copy = new byte[newLength];
        if (newLength > targetLength && targetLength > 0) {
            System.arraycopy(original, from, copy, start, targetLength);
        } else if (newLength <= targetLength) {
            System.arraycopy(original, from, copy, start, newLength);
        }
        return copy;
    }
}

