/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.security;

import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationContext;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.security.cppsec.esa.ExpressSecurityActivation;
import se.ericsson.security.cppsec.esa.SecurityActivationException;

public class SecurityHelper {
    private static final Class THIS_CLASS = SecurityHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetSecurityActivation(String failureSlogan, RbsConfigurationMao rbsConfigurationMao, ExpressSecurityActivation esa, Object esaLock) {
        logger.traceEnter(THIS_CLASS, "resetSecurityActivation()");
        try {
            logger.traceDebug(THIS_CLASS, "waiting for esa.install to finish before calling esa.reset...");
            Object object = esaLock;
            synchronized (object) {
                logger.traceDebug(THIS_CLASS, "time to call esa.reset if install has been run...");
                String esaInstalled = (String)rbsConfigurationMao.retrievePersistently("esaInstalled");
                if (Boolean.TRUE.toString().equals(esaInstalled)) {
                    logger.traceDebug(THIS_CLASS, "install has been run! yes indeed. Calling esa.reset");
                    esa.reset();
                    logger.traceDebug(THIS_CLASS, "esa.reset successful");
                    rbsConfigurationMao.storePersistently("esaInstalled", Boolean.FALSE.toString());
                    logger.traceDebug(THIS_CLASS, "has set esa installed started to false");
                }
            }
        }
        catch (SecurityActivationException sae) {
            this.handleException(failureSlogan, rbsConfigurationMao, (Exception)((Object)sae));
        }
        catch (MoAccessException mae) {
            this.handleException(failureSlogan, rbsConfigurationMao, (Exception)((Object)mae));
        }
        logger.traceReturn(THIS_CLASS, "resetSecurityActivation()");
    }

    private void handleException(String failureSlogan, RbsConfigurationMao rbsConfigurationMao, Exception e) {
        RbsConfigurationContext rbsConfigurationContext = rbsConfigurationMao.getRbsConfigurationContext();
        RbsConfigurationHelper helper = (RbsConfigurationHelper)rbsConfigurationContext.getHelper(RbsConfigurationHelper.class);
        String errorMsg = ExceptionHelper.appendReason((String)"Could not perform reset of Security Activation due to exception.", (Throwable)e);
        helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, failureSlogan, errorMsg);
        logger.traceError(THIS_CLASS, errorMsg, (Throwable)e);
    }
}

